/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Comparator;
import org.objectstyle.cayenne.CayenneRuntimeException;

public class PropertyComparator
implements Comparator {
    protected Method getter;
    protected boolean ascending;

    public static String capitalize(String s) {
        if (s.length() == 0) {
            return s;
        }
        char[] chars = s.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    public static Method findReadMethod(String propertyName, Class beanClass) {
        String base = PropertyComparator.capitalize(propertyName);
        try {
            return beanClass.getMethod("get" + base, null);
        }
        catch (Exception ex) {
            try {
                return beanClass.getMethod("is" + base, null);
            }
            catch (Exception ex2) {
                return null;
            }
        }
    }

    public static Object readProperty(String propertyName, Object bean) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (bean == null) {
            throw new NullPointerException("Null bean. Property: " + propertyName);
        }
        Method getter = PropertyComparator.findReadMethod(propertyName, bean.getClass());
        if (getter == null) {
            throw new NoSuchMethodException("No such property '" + propertyName + "' in class " + bean.getClass().getName());
        }
        return getter.invoke(bean, null);
    }

    public PropertyComparator(String propertyName, Class beanClass) {
        this(propertyName, beanClass, true);
    }

    public PropertyComparator(String propertyName, Class beanClass, boolean ascending) {
        this.getter = PropertyComparator.findReadMethod(propertyName, beanClass);
        if (this.getter == null) {
            throw new CayenneRuntimeException("No getter for " + propertyName);
        }
        this.ascending = ascending;
    }

    public int compare(Object o1, Object o2) {
        return this.ascending ? this.compareAsc(o1, o2) : this.compareAsc(o2, o1);
    }

    protected int compareAsc(Object o1, Object o2) {
        if (o1 == null && o2 == null || o1 == o2) {
            return 0;
        }
        if (o1 == null && o2 != null) {
            return -1;
        }
        if (o1 != null && o2 == null) {
            return 1;
        }
        try {
            Comparable p1 = (Comparable)this.getter.invoke(o1, null);
            Comparable p2 = (Comparable)this.getter.invoke(o2, null);
            return p1 == null ? -1 : p1.compareTo(p2);
        }
        catch (Exception ex) {
            throw new CayenneRuntimeException("Error reading property.", ex);
        }
    }
}

