/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.wocompat;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.PredicateUtils;
import org.objectstyle.cayenne.CayenneRuntimeException;
import org.objectstyle.cayenne.dba.TypesMapping;
import org.objectstyle.cayenne.exp.parser.ASTDbPath;
import org.objectstyle.cayenne.map.DataMap;
import org.objectstyle.cayenne.map.DbEntity;
import org.objectstyle.cayenne.map.DbJoin;
import org.objectstyle.cayenne.map.DbRelationship;
import org.objectstyle.cayenne.map.ObjEntity;
import org.objectstyle.cayenne.map.ObjRelationship;
import org.objectstyle.cayenne.project.NamedObjectFactory;
import org.objectstyle.cayenne.query.AbstractQuery;
import org.objectstyle.cayenne.query.Query;
import org.objectstyle.cayenne.util.ResourceLocator;
import org.objectstyle.cayenne.wocompat.EODbAttribute;
import org.objectstyle.cayenne.wocompat.EOModelHelper;
import org.objectstyle.cayenne.wocompat.EOObjAttribute;
import org.objectstyle.cayenne.wocompat.EOObjEntity;
import org.objectstyle.cayenne.wocompat.EOQuery;
import org.objectstyle.cayenne.wocompat.EOSQLQuery;
import org.objectstyle.cayenne.wocompat.parser.Parser;

public class EOModelProcessor {
    protected Predicate prototypeChecker = new Predicate(){

        public boolean evaluate(Object object) {
            if (object == null) {
                return false;
            }
            String entityName = object.toString();
            return entityName.startsWith("EO") && entityName.endsWith("Prototypes");
        }
    };
    static /* synthetic */ Class class$org$objectstyle$cayenne$map$DbRelationship;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map loadModeIndex(String path) throws Exception {
        URL base;
        ResourceLocator locator = new ResourceLocator();
        locator.setSkipClasspath(false);
        locator.setSkipCurrentDirectory(false);
        locator.setSkipHomeDirectory(true);
        locator.setSkipAbsolutePath(false);
        if (!path.endsWith(".eomodeld")) {
            path = path + ".eomodeld";
        }
        if ((base = locator.findDirectoryResource(path)) == null) {
            throw new FileNotFoundException("Can't find EOModel: " + path);
        }
        Parser plistParser = new Parser();
        InputStream in = new URL(base, "index.eomodeld").openStream();
        try {
            plistParser.ReInit(in);
            Map map = (Map)plistParser.propertyList();
            return map;
        }
        finally {
            in.close();
        }
    }

    public DataMap loadEOModel(String path) throws Exception {
        return this.loadEOModel(path, false);
    }

    public DataMap loadEOModel(String path, boolean generateClientClass) throws Exception {
        String name;
        EOModelHelper helper = this.makeHelper(path, generateClientClass);
        DataMap dataMap = helper.getDataMap();
        ArrayList modelNames = new ArrayList(helper.modelNamesAsList());
        CollectionUtils.filter(modelNames, PredicateUtils.notPredicate(this.prototypeChecker));
        Iterator it = modelNames.iterator();
        while (it.hasNext()) {
            name = (String)it.next();
            this.makeEntity(helper, name, generateClientClass);
        }
        Collections.sort(modelNames, new InheritanceComparator(dataMap));
        it = modelNames.iterator();
        while (it.hasNext()) {
            name = (String)it.next();
            EOObjEntity e = (EOObjEntity)dataMap.getObjEntity(name);
            this.makeAttributes(helper, e);
        }
        it = modelNames.iterator();
        while (it.hasNext()) {
            name = (String)it.next();
            this.makeRelationships(helper, dataMap.getObjEntity(name));
        }
        it = modelNames.iterator();
        while (it.hasNext()) {
            name = (String)it.next();
            this.makeFlatRelationships(helper, dataMap.getObjEntity(name));
        }
        it = modelNames.iterator();
        while (it.hasNext()) {
            name = (String)it.next();
            DbEntity dbEntity = dataMap.getObjEntity(name).getDbEntity();
            if (dbEntity == null) continue;
            this.makeReverseDbRelationships(dbEntity);
        }
        it = modelNames.iterator();
        while (it.hasNext()) {
            name = (String)it.next();
            Iterator queries = helper.queryNames(name);
            while (queries.hasNext()) {
                String queryName = (String)queries.next();
                System.out.println("Processing FetchSpecification: " + queryName);
                EOObjEntity entity = (EOObjEntity)dataMap.getObjEntity(name);
                this.makeQuery(helper, entity, queryName);
            }
        }
        return dataMap;
    }

    protected boolean isPrototypesEntity(String entityName) {
        return this.prototypeChecker.evaluate(entityName);
    }

    protected EOModelHelper makeHelper(String path, boolean genereateClientClass) throws Exception {
        return new EOModelHelper(path);
    }

    protected Query makeQuery(EOModelHelper helper, EOObjEntity entity, String queryName) {
        DataMap dataMap = helper.getDataMap();
        Map queryPlist = helper.queryPListMap(entity.getName(), queryName);
        if (queryPlist == null) {
            return null;
        }
        AbstractQuery query = queryPlist.containsKey("hints") ? new EOSQLQuery((ObjEntity)entity, queryPlist) : new EOQuery((ObjEntity)entity, queryPlist);
        query.setName(entity.qualifiedQueryName(queryName));
        dataMap.addQuery(query);
        return query;
    }

    protected EOObjEntity makeEntity(EOModelHelper helper, String name, boolean generateClientClass) {
        DataMap dataMap = helper.getDataMap();
        Map entityPlist = helper.entityPListMap(name);
        EOObjEntity objEntity = new EOObjEntity(name);
        objEntity.setIsClientEntity(generateClientClass);
        String parent = (String)entityPlist.get("parent");
        objEntity.setClassName(helper.entityClass(name, generateClientClass));
        if (parent != null) {
            objEntity.setHasSuperClass(true);
            objEntity.setSuperClassName(helper.entityClass(parent, generateClientClass));
        }
        objEntity.setIsAbstractEntity("Y".equals(entityPlist.get("isAbstractEntity")));
        String dbEntityName = (String)entityPlist.get("externalName");
        if (dbEntityName != null) {
            boolean createDbEntity = true;
            if (parent != null) {
                Map parentData;
                String parentName = parent;
                while (parentName != null && (parentData = helper.entityPListMap(parentName)) != null) {
                    String parentExternalName = (String)parentData.get("externalName");
                    if (parentExternalName == null) {
                        parentName = (String)parentData.get("parent");
                        continue;
                    }
                    if (!dbEntityName.equals(parentExternalName)) break;
                    createDbEntity = false;
                    break;
                }
            }
            if (createDbEntity) {
                int i = 0;
                String dbEntityBaseName = dbEntityName;
                while (dataMap.getDbEntity(dbEntityName) != null) {
                    dbEntityName = dbEntityBaseName + i++;
                }
                objEntity.setDbEntityName(dbEntityName);
                DbEntity de = new DbEntity(dbEntityName);
                dataMap.addDbEntity(de);
            }
        }
        objEntity.setReadOnly("Y".equals(entityPlist.get("isReadOnly")));
        objEntity.setSuperEntityName((String)entityPlist.get("parent"));
        dataMap.addObjEntity(objEntity);
        return objEntity;
    }

    protected void makeAttributes(EOModelHelper helper, EOObjEntity objEntity) {
        Map parentData;
        Map entityPlistMap = helper.entityPListMap(objEntity.getName());
        List primaryKeys = (List)entityPlistMap.get("primaryKeyAttributes");
        List classProperties = objEntity.getIsClientEntity() ? (List)entityPlistMap.get("clientClassProperties") : (List)entityPlistMap.get("classProperties");
        List attributes = (List)entityPlistMap.get("attributes");
        DbEntity dbEntity = objEntity.getDbEntity();
        if (primaryKeys == null) {
            primaryKeys = Collections.EMPTY_LIST;
        }
        if (classProperties == null) {
            classProperties = Collections.EMPTY_LIST;
        }
        if (attributes == null) {
            attributes = Collections.EMPTY_LIST;
        }
        boolean singleTableInheritance = false;
        String parentName = (String)entityPlistMap.get("parent");
        while (parentName != null && (parentData = helper.entityPListMap(parentName)) != null) {
            String parentExternalName = (String)parentData.get("externalName");
            if (parentExternalName == null) {
                parentName = (String)parentData.get("parent");
                continue;
            }
            if (dbEntity.getName() == null || !dbEntity.getName().equals(parentExternalName)) break;
            singleTableInheritance = true;
            break;
        }
        Iterator it = attributes.iterator();
        while (it.hasNext()) {
            String valueType;
            String attrType;
            String attrName;
            Map attrMap = (Map)it.next();
            String prototypeName = (String)attrMap.get("prototypeName");
            Map prototypeAttrMap = helper.getPrototypeAttributeMapFor(prototypeName);
            String dbAttrName = (String)attrMap.get("columnName");
            if (null == dbAttrName) {
                dbAttrName = (String)prototypeAttrMap.get("columnName");
            }
            if (null == (attrName = (String)attrMap.get("name"))) {
                attrName = (String)prototypeAttrMap.get("name");
            }
            if (null == (attrType = (String)attrMap.get("valueClassName"))) {
                attrType = (String)prototypeAttrMap.get("valueClassName");
            }
            if ((valueType = (String)attrMap.get("valueType")) == null) {
                valueType = (String)prototypeAttrMap.get("valueType");
            }
            String javaType = helper.javaTypeForEOModelerType(attrType, valueType);
            EODbAttribute dbAttr = null;
            if (!(dbAttrName == null || dbEntity == null || singleTableInheritance && dbEntity.getAttribute(dbAttrName) != null)) {
                Object allowsNull;
                Integer scale;
                int i = 0;
                String dbAttributeBaseName = dbAttrName;
                while (dbEntity.getAttribute(dbAttrName) != null) {
                    dbAttrName = dbAttributeBaseName + i++;
                }
                dbAttr = new EODbAttribute(dbAttrName, TypesMapping.getSqlTypeByJava(javaType), dbEntity);
                dbAttr.setEoAttributeName(attrName);
                dbEntity.addAttribute(dbAttr);
                Integer width = (Integer)attrMap.get("width");
                if (null == width) {
                    width = (Integer)prototypeAttrMap.get("width");
                }
                if (width != null) {
                    dbAttr.setMaxLength(width);
                }
                if (null == (scale = (Integer)attrMap.get("scale"))) {
                    scale = (Integer)prototypeAttrMap.get("scale");
                }
                if (scale != null) {
                    dbAttr.setPrecision(scale);
                }
                if (primaryKeys.contains(attrName)) {
                    dbAttr.setPrimaryKey(true);
                }
                dbAttr.setMandatory(!"Y".equals(allowsNull = attrMap.get("allowsNull")));
            }
            if (!classProperties.contains(attrName)) continue;
            EOObjAttribute attr = new EOObjAttribute(attrName, javaType, objEntity);
            String entityReadOnlyString = (String)entityPlistMap.get("isReadOnly");
            String attributeReadOnlyString = (String)attrMap.get("isReadOnly");
            if ("Y".equals(entityReadOnlyString) || "Y".equals(attributeReadOnlyString)) {
                attr.setReadOnly(true);
            }
            attr.setDbAttributeName(dbAttrName);
            objEntity.addAttribute(attr);
        }
    }

    protected void makeRelationships(EOModelHelper helper, ObjEntity objEntity) {
        Map entityPlistMap = helper.entityPListMap(objEntity.getName());
        List classProps = (List)entityPlistMap.get("classProperties");
        List rinfo = (List)entityPlistMap.get("relationships");
        Collection attributes = (Collection)entityPlistMap.get("attributes");
        if (rinfo == null) {
            return;
        }
        if (classProps == null) {
            classProps = Collections.EMPTY_LIST;
        }
        if (attributes == null) {
            attributes = Collections.EMPTY_LIST;
        }
        DbEntity dbSrc = objEntity.getDbEntity();
        Iterator it = rinfo.iterator();
        while (it.hasNext()) {
            Map relMap = (Map)it.next();
            String targetName = (String)relMap.get("destination");
            if (targetName == null) continue;
            String relName = (String)relMap.get("name");
            boolean toMany = "Y".equals(relMap.get("isToMany"));
            boolean toDependentPK = "Y".equals(relMap.get("propagatesPrimaryKey"));
            ObjEntity target = helper.getDataMap().getObjEntity(targetName);
            if (target == null) continue;
            DbEntity dbTarget = target.getDbEntity();
            Map targetPlistMap = helper.entityPListMap(targetName);
            Collection targetAttributes = (Collection)targetPlistMap.get("attributes");
            DbRelationship dbRel = null;
            if (dbSrc != null && dbTarget != null && (dbRel = (DbRelationship)dbSrc.getRelationship(relName)) == null) {
                dbRel = new DbRelationship();
                dbRel.setSourceEntity(dbSrc);
                dbRel.setTargetEntity(dbTarget);
                dbRel.setToMany(toMany);
                dbRel.setName(relName);
                dbRel.setToDependentPK(toDependentPK);
                dbSrc.addRelationship(dbRel);
                List joins = (List)relMap.get("joins");
                Iterator jIt = joins.iterator();
                while (jIt.hasNext()) {
                    Map joinMap = (Map)jIt.next();
                    DbJoin join = new DbJoin(dbRel);
                    String sourceAttributeName = (String)joinMap.get("sourceAttribute");
                    join.setSourceName(this.columnName(attributes, sourceAttributeName));
                    String targetAttributeName = (String)joinMap.get("destinationAttribute");
                    join.setTargetName(this.columnName(targetAttributes, targetAttributeName));
                    dbRel.addJoin(join);
                }
            }
            if (!classProps.contains(relName)) continue;
            ObjRelationship rel = new ObjRelationship();
            rel.setName(relName);
            rel.setSourceEntity(objEntity);
            rel.setTargetEntity(target);
            objEntity.addRelationship(rel);
            if (dbRel == null) continue;
            rel.addDbRelationship(dbRel);
        }
    }

    protected void makeReverseDbRelationships(DbEntity dbEntity) {
        if (dbEntity == null) {
            throw new NullPointerException("Attempt to create reverse relationships for the null DbEntity.");
        }
        ArrayList clone = new ArrayList(dbEntity.getRelationships());
        Iterator it = clone.iterator();
        while (it.hasNext()) {
            DbRelationship relationship = (DbRelationship)it.next();
            if (relationship.getReverseRelationship() != null) continue;
            DbRelationship reverse = relationship.createReverseRelationship();
            String name = NamedObjectFactory.createName(class$org$objectstyle$cayenne$map$DbRelationship == null ? EOModelProcessor.class$("org.objectstyle.cayenne.map.DbRelationship") : class$org$objectstyle$cayenne$map$DbRelationship, reverse.getSourceEntity(), relationship.getName() + "Reverse");
            reverse.setName(name);
            relationship.getTargetEntity().addRelationship(reverse);
        }
    }

    protected void makeFlatRelationships(EOModelHelper helper, ObjEntity e) {
        Map info = helper.entityPListMap(e.getName());
        List rinfo = (List)info.get("relationships");
        if (rinfo == null) {
            return;
        }
        Iterator it = rinfo.iterator();
        while (it.hasNext()) {
            Map relMap = (Map)it.next();
            String targetPath = (String)relMap.get("definition");
            if (targetPath == null) continue;
            ObjRelationship flatRel = new ObjRelationship();
            flatRel.setName((String)relMap.get("name"));
            flatRel.setSourceEntity(e);
            e.addRelationship(flatRel);
            DbEntity dbEntity = e.getDbEntity();
            if (dbEntity == null) continue;
            ASTDbPath exp = new ASTDbPath(targetPath);
            Iterator path = dbEntity.resolvePathComponents(exp);
            DbRelationship firstRel = null;
            DbRelationship lastRel = null;
            while (path.hasNext()) {
                lastRel = (DbRelationship)path.next();
                flatRel.addDbRelationship(lastRel);
                if (firstRel != null) continue;
                firstRel = lastRel;
            }
            if (firstRel != null && lastRel != null) {
                Collection potentialTargets = e.getDataMap().getMappedEntities((DbEntity)lastRel.getTargetEntity());
                if (potentialTargets.size() != 1) {
                    throw new CayenneRuntimeException("One and only one entity should be mapped to " + lastRel.getTargetEntity().getName() + ". Instead found : " + potentialTargets.size());
                }
                flatRel.setTargetEntity((ObjEntity)potentialTargets.iterator().next());
                continue;
            }
            throw new CayenneRuntimeException("relationship in the path was null!");
        }
    }

    String columnName(Collection entityAttributes, String attributeName) {
        if (attributeName == null) {
            return null;
        }
        Iterator it = entityAttributes.iterator();
        while (it.hasNext()) {
            Map map = (Map)it.next();
            if (!attributeName.equals(map.get("name"))) continue;
            return (String)map.get("columnName");
        }
        return null;
    }

    final class InheritanceComparator
    implements Comparator {
        DataMap dataMap;

        InheritanceComparator(DataMap dataMap) {
            this.dataMap = dataMap;
        }

        public int compare(Object o1, Object o2) {
            if (o1 == null) {
                return o2 != null ? -1 : 0;
            }
            if (o2 == null) {
                return 1;
            }
            String name1 = o1.toString();
            String name2 = o2.toString();
            ObjEntity e1 = this.dataMap.getObjEntity(name1);
            ObjEntity e2 = this.dataMap.getObjEntity(name2);
            return this.compareEntities(e1, e2);
        }

        int compareEntities(ObjEntity e1, ObjEntity e2) {
            if (e1 == null) {
                return e2 != null ? -1 : 0;
            }
            if (e2 == null) {
                return 1;
            }
            if (e1.isSubentityOf(e2)) {
                return 1;
            }
            if (e2.isSubentityOf(e1)) {
                return -1;
            }
            return e1.getName().compareTo(e2.getName());
        }
    }
}

