/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.xml;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import org.objectstyle.cayenne.CayenneRuntimeException;
import org.objectstyle.cayenne.property.PropertyUtils;
import org.objectstyle.cayenne.xml.SerializableEntity;
import org.objectstyle.cayenne.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

final class XMLMappingDescriptor {
    private SerializableEntity rootEntity;
    private Map entities;

    XMLMappingDescriptor(String mappingUrl) throws CayenneRuntimeException {
        Document document;
        DocumentBuilder builder = XMLUtil.newBuilder();
        try {
            document = builder.parse(mappingUrl);
        }
        catch (Exception ex) {
            throw new CayenneRuntimeException("Error parsing XML at " + mappingUrl, ex);
        }
        Element root = document.getDocumentElement();
        if (!"model".equals(root.getNodeName())) {
            throw new CayenneRuntimeException("Root of the mapping model must be \"model\"");
        }
        HashMap<String, SerializableEntity> entities = new HashMap<String, SerializableEntity>();
        Iterator it = XMLUtil.getChildren(root).iterator();
        while (it.hasNext()) {
            Element e = (Element)it.next();
            SerializableEntity entity = new SerializableEntity(this, e);
            String tag = e.getAttribute("xmlTag");
            entities.put(tag, entity);
            if (this.rootEntity != null) continue;
            this.rootEntity = entity;
        }
        this.entities = entities;
    }

    SerializableEntity getRootEntity() {
        return this.rootEntity;
    }

    Object decode(Element xml) throws CayenneRuntimeException {
        Object ret = this.newInstance(this.rootEntity.getName());
        Iterator it = XMLUtil.getChildren(xml).iterator();
        while (it.hasNext()) {
            Element value = (Element)it.next();
            this.decodeProperty(ret, this.rootEntity.getDescriptor(), value);
        }
        return ret;
    }

    SerializableEntity getEntity(String name) {
        return (SerializableEntity)this.entities.get(name);
    }

    private String getEntityRef(Element rootEntity, String ref) {
        Iterator it = XMLUtil.getChildren(rootEntity).iterator();
        while (it.hasNext()) {
            Element child = (Element)it.next();
            if (!child.getAttribute("xmlTag").equals(ref)) continue;
            return child.getAttribute("name");
        }
        return null;
    }

    private void decodeProperty(Object object, Element entity, Element encProperty) throws CayenneRuntimeException {
        List children = XMLUtil.getChildren(encProperty);
        String xmlTag = encProperty.getNodeName();
        if (children.isEmpty()) {
            Iterator it = XMLUtil.getChildren(entity).iterator();
            while (it.hasNext()) {
                Element e = (Element)it.next();
                if (!e.getAttribute("xmlTag").equals(xmlTag)) continue;
                PropertyUtils.setProperty(object, e.getAttribute("name"), XMLUtil.getText(encProperty));
            }
        } else {
            Object o = this.newInstance(this.getEntity(xmlTag).getDescriptor().getAttribute("name"));
            Iterator it = children.iterator();
            while (it.hasNext()) {
                Element child = (Element)it.next();
                this.decodeProperty(o, this.getEntity(xmlTag).getDescriptor(), child);
            }
            Object property = PropertyUtils.getProperty(object, this.getEntityRef(entity, xmlTag));
            if (property instanceof Collection) {
                Collection c = (Collection)property;
                c.add(o);
            } else {
                PropertyUtils.setProperty(object, this.getEntityRef(entity, xmlTag), o);
            }
        }
    }

    private Object newInstance(String className) throws CayenneRuntimeException {
        try {
            return Class.forName(className, true, Thread.currentThread().getContextClassLoader()).newInstance();
        }
        catch (Exception ex) {
            throw new CayenneRuntimeException("Error creating instance of class " + className, ex);
        }
    }
}

