/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.client;

import javax.jms.JMSException;
import javax.jms.QueueSession;
import javax.jms.TransactionInProgressException;
import javax.jms.XAQueueSession;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.exolab.jms.client.JmsQueueSession;
import org.exolab.jms.client.JmsXAQueueConnection;
import org.exolab.jms.client.JmsXATopicSession;

public class JmsXAQueueSession
extends JmsQueueSession
implements XAQueueSession,
XAResource {
    private Long _rid = null;

    JmsXAQueueSession(JmsXAQueueConnection connection, boolean transacted, int ackMode) throws JMSException {
        super(connection, transacted, ackMode);
    }

    public QueueSession getQueueSession() throws JMSException {
        return this;
    }

    public XAResource getXAResource() {
        return this;
    }

    public boolean getTransacted() throws JMSException {
        return true;
    }

    public void commit() throws JMSException {
        throw new TransactionInProgressException("Cannot call commit on XASession");
    }

    public void rollback() throws JMSException {
        throw new TransactionInProgressException("Cannot call rollback on XASession");
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        this.getJmsSessionStub().commit(xid, onePhase);
    }

    public void end(Xid xid, int flags) throws XAException {
        this.getJmsSessionStub().end(xid, flags);
    }

    public void forget(Xid xid) throws XAException {
        this.getJmsSessionStub().forget(xid);
    }

    public int getTransactionTimeout() throws XAException {
        return this.getJmsSessionStub().getTransactionTimeout();
    }

    public boolean isSameRM(XAResource xares) throws XAException {
        boolean result = false;
        if (xares != null && xares instanceof JmsXATopicSession && ((JmsXATopicSession)xares).getResourceManagerId() == this.getResourceManagerId()) {
            result = true;
        }
        return result;
    }

    public int prepare(Xid xid) throws XAException {
        return this.getJmsSessionStub().prepare(xid);
    }

    public Xid[] recover(int flag) throws XAException {
        return this.getJmsSessionStub().recover(flag);
    }

    public void rollback(Xid xid) throws XAException {
        this.getJmsSessionStub().rollback(xid);
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        return this.getJmsSessionStub().setTransactionTimeout(seconds);
    }

    public void start(Xid xid, int flags) throws XAException {
        this.getJmsSessionStub().start(xid, flags);
    }

    public long getResourceManagerId() throws XAException {
        if (this._rid == null) {
            this._rid = new Long(this.getJmsSessionStub().getResourceManagerId());
        }
        return this._rid;
    }
}

