/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.config;

import java.io.Serializable;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;

public abstract class HttpConfigurationType
implements Serializable {
    private String _host = "localhost";
    private int _port = 8080;
    private boolean _has_port;
    private String _proxyHost;
    private int _proxyPort;
    private boolean _has_proxyPort;
    private int _clientPingInterval = 15;
    private boolean _has_clientPingInterval;
    private String _serverServlet = "/openjms/OpenJMSServer";
    private String _jndiServlet = "/openjms/OpenJMSJndi";
    private String _adminServlet = "/openjms/OpenJMSServlet";

    public HttpConfigurationType() {
        this.setHost("localhost");
        this.setServerServlet("/openjms/OpenJMSServer");
        this.setJndiServlet("/openjms/OpenJMSJndi");
        this.setAdminServlet("/openjms/OpenJMSServlet");
    }

    public void deleteClientPingInterval() {
        this._has_clientPingInterval = false;
    }

    public void deletePort() {
        this._has_port = false;
    }

    public void deleteProxyPort() {
        this._has_proxyPort = false;
    }

    public String getAdminServlet() {
        return this._adminServlet;
    }

    public int getClientPingInterval() {
        return this._clientPingInterval;
    }

    public String getHost() {
        return this._host;
    }

    public String getJndiServlet() {
        return this._jndiServlet;
    }

    public int getPort() {
        return this._port;
    }

    public String getProxyHost() {
        return this._proxyHost;
    }

    public int getProxyPort() {
        return this._proxyPort;
    }

    public String getServerServlet() {
        return this._serverServlet;
    }

    public boolean hasClientPingInterval() {
        return this._has_clientPingInterval;
    }

    public boolean hasPort() {
        return this._has_port;
    }

    public boolean hasProxyPort() {
        return this._has_proxyPort;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public void setAdminServlet(String adminServlet) {
        this._adminServlet = adminServlet;
    }

    public void setClientPingInterval(int clientPingInterval) {
        this._clientPingInterval = clientPingInterval;
        this._has_clientPingInterval = true;
    }

    public void setHost(String host) {
        this._host = host;
    }

    public void setJndiServlet(String jndiServlet) {
        this._jndiServlet = jndiServlet;
    }

    public void setPort(int port) {
        this._port = port;
        this._has_port = true;
    }

    public void setProxyHost(String proxyHost) {
        this._proxyHost = proxyHost;
    }

    public void setProxyPort(int proxyPort) {
        this._proxyPort = proxyPort;
        this._has_proxyPort = true;
    }

    public void setServerServlet(String serverServlet) {
        this._serverServlet = serverServlet;
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

