/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.server.http;

import java.io.IOException;
import java.rmi.UnknownHostException;
import java.util.HashMap;
import java.util.Vector;
import javax.jms.JMSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.core.http.HttpClient;
import org.exolab.core.mipc.MultiplexConnectionIfc;
import org.exolab.jms.client.JmsMessageListener;
import org.exolab.jms.client.JmsQueue;
import org.exolab.jms.client.JmsTopic;
import org.exolab.jms.server.JmsServerSession;
import org.exolab.jms.server.http.HttpJmsSessionSender;
import org.exolab.jms.server.mipc.IpcJmsServer;
import org.exolab.jms.server.mipc.IpcJmsSessionConnection;

public class HttpJmsSessionConnection
extends IpcJmsSessionConnection {
    private HashMap _consumerList = new HashMap();
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$server$http$HttpJmsSessionConnection == null ? (class$org$exolab$jms$server$http$HttpJmsSessionConnection = HttpJmsSessionConnection.class$("org.exolab.jms.server.http.HttpJmsSessionConnection")) : class$org$exolab$jms$server$http$HttpJmsSessionConnection));
    static /* synthetic */ Class class$org$exolab$jms$server$http$HttpJmsSessionConnection;

    public HttpJmsSessionConnection(IpcJmsServer server) {
        super(server);
    }

    protected Vector createReceiver(JmsServerSession session, JmsQueue queue, Long consumerId, String selector, MultiplexConnectionIfc not_used, String host, String port, String url) {
        if (session != null) {
            try {
                session.createReceiver(queue, consumerId.longValue(), selector);
                this.addSession(session, url, host, port);
            }
            catch (JMSException error) {
                return this.pack(new Boolean(false), (Object)error);
            }
            catch (Exception error) {
                return this.pack(new Boolean(false), error.getMessage());
            }
        }
        return this.pack(new Boolean(true), null);
    }

    protected Vector createBrowser(JmsServerSession session, JmsQueue queue, Long clientId, String selector, MultiplexConnectionIfc not_used, String host, String port, String url) {
        Vector result = null;
        if (session == null) {
            result = this.pack(new Boolean(true), null);
        } else {
            try {
                session.createBrowser(queue, clientId.longValue(), selector);
                this.addSession(session, url, host, port);
                result = this.pack(new Boolean(true), null);
            }
            catch (JMSException error) {
                result = this.pack(new Boolean(false), (Object)error);
            }
            catch (Exception error) {
                return this.pack(new Boolean(false), error.getMessage());
            }
        }
        return result;
    }

    protected Vector createSubscriber(JmsServerSession session, JmsTopic topic, String name, Long clientId, String selector, Boolean noLocal, MultiplexConnectionIfc not_used, String host, String port, String url) {
        if (session != null) {
            try {
                session.createSubscriber(topic, name, clientId.longValue(), selector, noLocal.booleanValue());
                this.addSession(session, url, host, port);
            }
            catch (JMSException error) {
                return this.pack(new Boolean(false), (Object)error);
            }
            catch (Exception error) {
                return this.pack(new Boolean(false), error.getMessage());
            }
        }
        return this.pack(new Boolean(true), null);
    }

    protected Vector close(JmsServerSession session, MultiplexConnectionIfc connection) {
        this.removeSession(session);
        return super.close(session, connection);
    }

    protected void disconnect(JmsServerSession session) {
        if (session != null) {
            this.removeSession(session);
            try {
                session.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private synchronized void addSession(JmsServerSession session, String url, String host, String port) throws UnknownHostException, IOException {
        HttpJmsSessionSender sender;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Adding session for client, webserver URL=" + url + ", host=" + host + ", port=" + port));
        }
        if ((sender = (HttpJmsSessionSender)this._consumerList.get(session.getSessionId())) == null) {
            HttpClient client = new HttpClient(url, "HttpJmsSessionConnection");
            sender = new HttpJmsSessionSender(this, client, session, host, port);
            this._consumerList.put(session.getSessionId(), sender);
            session.setMessageListener((JmsMessageListener)sender);
        }
    }

    private synchronized void removeSession(JmsServerSession session) {
        HttpJmsSessionSender sender = (HttpJmsSessionSender)this._consumerList.remove(session.getSessionId());
        if (sender != null) {
            sender.close();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

