/*
 * Decompiled with CFR 0.152.
 */
package org.walluck.oscar;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.walluck.oscar.AIMConnection;
import org.walluck.oscar.AIMFrame;
import org.walluck.oscar.AIMInputStream;
import org.walluck.oscar.AIMOutputStream;
import org.walluck.oscar.AIMSession;
import org.walluck.oscar.AIMUtil;
import org.walluck.oscar.FLAP;
import org.walluck.oscar.SNAC;
import org.walluck.oscar.handlers.MiscListener;
import org.walluck.oscar.handlers.SNACHandler;

public class ReceiveQueueThread
extends Thread {
    private static final Logger LOG = Logger.getLogger((String)ReceiveQueueThread.class.getName());
    private AIMSession sess;
    private AIMConnection conn;
    private volatile Thread thread = this;
    private static final int SLEEP_TIME = 100;

    public ReceiveQueueThread(AIMSession sess, AIMConnection conn) {
        this.sess = sess;
        this.conn = conn;
    }

    private void handleIncomingFrame(AIMFrame frame) throws IOException {
        FLAP flap = frame.getFLAP();
        SNAC snac = frame.getSNAC();
        byte[] data = frame.getData();
        SNACHandler handler = null;
        String debugMsg = null;
        AIMOutputStream buffer = new AIMOutputStream();
        if (flap != null) {
            debugMsg = "<== FLAP(" + Integer.toHexString(flap.getCommand()) + ", " + Integer.toHexString((short)flap.getChannel()) + ", " + Integer.toHexString(flap.getSeqNum()) + ", " + flap.getLength() + ")";
            buffer.writeFLAP(flap);
        }
        if (snac != null) {
            debugMsg = debugMsg + " SNAC(" + Integer.toHexString(snac.getFamily()) + ", " + Integer.toHexString(snac.getSubtype()) + ", " + Integer.toHexString(snac.getFlags()) + ", " + Integer.toHexString(snac.getId()) + ", " + snac.getVersion() + ")";
            buffer.writeSNAC(snac);
            handler = snac.getSubtype() != 1 ? frame.getConn().getSess().getHandler(snac.getFamily()) : frame.getConn().getSess().getHandler(65535);
        }
        if (data != null) {
            debugMsg = debugMsg + " DATA(" + (snac != null ? data.length + 10 : data.length) + ")";
            buffer.writeBytes(data);
        }
        if (snac != null) {
            LOG.debug((Object)(AIMUtil.snacToString(snac.getFamily(), 0) + "::" + AIMUtil.snacToString(snac.getFamily(), snac.getSubtype())));
        }
        if (debugMsg != null) {
            LOG.debug(debugMsg);
        }
        LOG.debug((Object)AIMUtil.hexdump(buffer.getBytes()));
        if (snac != null && handler != null && data != null) {
            handler.handleSNAC(this.sess, handler, frame, snac, new AIMInputStream(new ByteArrayInputStream(data)));
            if (!frame.isHandled()) {
                LOG.warn((Object)("Unhandled SNAC 0x" + Integer.toHexString(snac.getFamily()) + "/0x" + Integer.toHexString(snac.getSubtype())));
                Iterator i = frame.getConn().getListeners(65535, 65534);
                while (i.hasNext()) {
                    ((MiscListener)i.next()).unhandledFrame(this.sess, frame);
                }
            } else {
                this.conn.remSNAC(snac.getId());
            }
        }
    }

    public synchronized void flush() {
        AIMFrame frame;
        this.thread = null;
        while ((frame = (AIMFrame)this.conn.getReceiveQueue().pop()) != null) {
            try {
                this.handleIncomingFrame(frame);
            }
            catch (IOException ioe) {
                LOG.error((Object)"IOExce[tion", (Throwable)ioe);
            }
        }
    }

    public void run() {
        Thread thisThread = Thread.currentThread();
        while (this.thread == thisThread && this.conn != null && this.conn.getReceiveQueue() != null && this.thread != null) {
            AIMFrame frame = (AIMFrame)this.conn.getReceiveQueue().pop();
            if (frame != null) {
                try {
                    this.handleIncomingFrame(frame);
                }
                catch (IOException ioe) {
                    LOG.debug((Object)("IOException in ReceiveQueueThread.run(): " + ioe));
                }
                continue;
            }
            try {
                ReceiveQueueThread.sleep(100L);
            }
            catch (InterruptedException ie) {
                LOG.debug((Object)("InterruptedException in ReceiveQueueThread.run(): " + ie));
            }
        }
    }
}

