/*
 * Decompiled with CFR 0.152.
 */
package org.walluck.oscar.channel.rendezvous;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.walluck.oscar.AIMConnection;
import org.walluck.oscar.AIMFrame;
import org.walluck.oscar.AIMInputStream;
import org.walluck.oscar.AIMOutputStream;
import org.walluck.oscar.AIMSession;
import org.walluck.oscar.AIMUtil;
import org.walluck.oscar.IncomingIMCH2;
import org.walluck.oscar.SNAC;
import org.walluck.oscar.TLVChain;
import org.walluck.oscar.UserInfo;
import org.walluck.oscar.channel.rendezvous.Rendezvous;
import org.walluck.oscar.handlers.SNACHandler;
import org.walluck.oscar.handlers.icq.SendRTFMsg;

public class ICQRTFRendezvous
extends Rendezvous {
    private static final Logger LOG = Logger.getLogger((String)ICQRTFRendezvous.class.getName());
    private SendRTFMsg rtfMsg;
    private AIMConnection conn;

    public ICQRTFRendezvous() {
        this.setService(16384);
    }

    public SendRTFMsg getRTFMsg() {
        return this.rtfMsg;
    }

    public void setRTFMsg(SendRTFMsg rtfMsg) {
        this.rtfMsg = rtfMsg;
    }

    public AIMConnection getConn() {
        return this.conn;
    }

    public void setConn(AIMConnection conn) {
        this.conn = conn;
    }

    public void setRequest() throws IOException {
        SendRTFMsg args = this.rtfMsg;
        String rtfcap = "{97B12751-243C-4334-AD22-D6ABF73F1492}";
        TLVChain tlvchain = new TLVChain(3);
        tlvchain.addShort(10, 1);
        tlvchain.addNull(15);
        AIMOutputStream buffer = new AIMOutputStream(53 + args.getRTFMsg().length() + 1 + 4 + 4 + 2 + rtfcap.length() + 1);
        buffer.writeShortLE(27);
        buffer.writeShortLE(9);
        buffer.writeCaps(8192);
        buffer.writeShortLE(0);
        buffer.writeIntLE(0);
        buffer.writeByte(0);
        int msgId = this.conn.nextMsgId();
        buffer.writeShortLE(msgId);
        buffer.writeShortLE(14);
        buffer.writeShortLE(msgId);
        buffer.writeIntLE(0);
        buffer.writeIntLE(0);
        buffer.writeIntLE(0);
        buffer.writeShortLE(1);
        buffer.writeIntLE(0);
        buffer.writeShortLE(args.getRTFMsg().length() + 1);
        buffer.writeString0(args.getRTFMsg());
        buffer.writeICQColor(args.getFgColor());
        buffer.writeICQColor(args.getBgColor());
        buffer.writeIntLE(rtfcap.length() + 1);
        buffer.writeString0(rtfcap);
        tlvchain.addBytes(10001, buffer.getBytes());
        this.setType(0);
        this.setServiceData(tlvchain);
    }

    public void handleServiceData(AIMSession sess, SNACHandler handler, AIMFrame frame, SNAC snac, UserInfo userinfo, IncomingIMCH2 args, AIMInputStream buffer) throws IOException {
        if (buffer == null || buffer.isEmpty()) {
            LOG.error((Object)"Server relay with no bytes remaining");
            return;
        }
        short len = buffer.readShortLE();
        byte[] data = buffer.readBytes(len);
        AIMInputStream inbuffer = new AIMInputStream(new ByteArrayInputStream(data));
        short tcpver = inbuffer.readShortLE();
        int caps = inbuffer.readCaps(16);
        byte[] unknown = inbuffer.readBytes(3);
        int type = inbuffer.readIntLE();
        short seq1 = inbuffer.readShortLE();
        len = buffer.readShortLE();
        data = buffer.readBytes(len);
        inbuffer = new AIMInputStream(new ByteArrayInputStream(data));
        short seq2 = inbuffer.readShortLE();
        byte[] unknown2 = inbuffer.readBytes(len - 2);
        byte msgtype = buffer.readByte();
        byte msgflags = buffer.readByte();
        short unknownv = buffer.readShortLE();
        short priority = buffer.readShortLE();
        if (buffer.getEmpty() >= 3) {
            SendRTFMsg rtfMsg = new SendRTFMsg();
            rtfMsg.setDestSN(userinfo.getSN());
            rtfMsg.setRTFMsg(buffer.readStringLLLE());
            rtfMsg.setFgColor(buffer.readICQColor());
            rtfMsg.setBgColor(buffer.readICQColor());
            args.getInfo().setRTFMsg(rtfMsg);
            int reqClass = -1;
            if (buffer.getEmpty() >= 4) {
                int length = buffer.readIntLE();
                String uuid = buffer.readString(length);
                data = AIMUtil.uuidToByteArray(uuid);
                inbuffer = new AIMInputStream(new ByteArrayInputStream(data));
                reqClass = inbuffer.readCaps(data.length);
                args.setReqClass(reqClass);
            }
            if (reqClass == -1) {
                args.setReqClass(4096);
            }
            LOG.debug((Object)("RTF message=" + args.getInfo().getRTFMsg().getRTFMsg() + ", foreground color=" + args.getInfo().getRTFMsg().getFgColor() + ", background color=" + args.getInfo().getRTFMsg().getBgColor() + ", reqClass=0x" + Integer.toHexString(args.getReqClass())));
        }
    }
}

