/*
 * Decompiled with CFR 0.152.
 */
package org.walluck.oscar.components;

import java.net.URL;
import java.util.HashMap;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;

public class IconManager {
    private static final Logger log = Logger.getLogger((String)IconManager.class.getName());
    private static IconManager me = null;
    private HashMap iconMap = new HashMap();
    private boolean debug = true;

    public static synchronized IconManager getInstance() {
        if (me == null) {
            me = new IconManager();
        }
        return me;
    }

    public synchronized ImageIcon getIcon(String name) {
        String imageLocation;
        ImageIcon icon = (ImageIcon)this.iconMap.get(name);
        if (icon != null) {
            return icon;
        }
        URL imageURL = IconManager.class.getResource(imageLocation = "/img/" + name + ".gif");
        if (imageURL == null) {
            imageLocation = "/img/" + name + ".png";
            imageURL = IconManager.class.getResource(imageLocation);
        }
        if (imageURL == null) {
            if (this.debug) {
                log.debug((Object)("Icon '" + name + "' requested, but can't be found!"));
            }
            return null;
        }
        icon = new ImageIcon(imageURL);
        this.iconMap.put(name, icon);
        if (this.debug) {
            log.debug((Object)("Icon '" + name + "' retrieved as '" + imageLocation + "', and added to cache!"));
        }
        return icon;
    }
}

