/*
 * Decompiled with CFR 0.152.
 */
package org.walluck.oscar.handlers;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.walluck.oscar.AIMConnection;
import org.walluck.oscar.AIMFrame;
import org.walluck.oscar.AIMInputStream;
import org.walluck.oscar.AIMOutputStream;
import org.walluck.oscar.AIMSession;
import org.walluck.oscar.AIMUtil;
import org.walluck.oscar.SNAC;
import org.walluck.oscar.TLV;
import org.walluck.oscar.TLVChain;
import org.walluck.oscar.handlers.ICQListener;
import org.walluck.oscar.handlers.SNACHandler;
import org.walluck.oscar.handlers.icq.ICQClientInfo;
import org.walluck.oscar.handlers.icq.ICQMetaFound;
import org.walluck.oscar.handlers.icq.ICQMetaGeneral;
import org.walluck.oscar.handlers.icq.ICQMetaMore;
import org.walluck.oscar.handlers.icq.ICQMetaWP;
import org.walluck.oscar.handlers.icq.ICQMetaWork;
import org.walluck.oscar.handlers.icq.ICQOfflineMsg;
import org.walluck.oscar.handlers.icq.ICQPacket;
import org.walluck.oscar.handlers.icq.ICQSMSMessage;

public class ICQHandler
extends SNACHandler {
    private static final Logger LOG = Logger.getLogger((String)ICQHandler.class.getName());

    public ICQHandler() {
        this.setFamily(21);
        this.setVersion(1);
    }

    public void reqOfflineMsgs(AIMSession sess) throws IOException {
        AIMConnection conn;
        if (sess == null || (conn = AIMConnection.findByGroup(sess, 21)) == null) {
            throw new NullPointerException();
        }
        ICQPacket p = new ICQPacket(sess.getSN(), 60, 0);
        conn.enqueueFrame(new AIMFrame(conn, p, null));
    }

    public void ackOfflineMsgs(AIMSession sess) throws IOException {
        AIMConnection conn;
        if (sess == null || (conn = AIMConnection.findByGroup(sess, 21)) == null) {
            throw new NullPointerException();
        }
        ICQPacket p = new ICQPacket(sess.getSN(), 62, 0);
        conn.enqueueFrame(new AIMFrame(conn, p, null));
    }

    public void metaSetGeneral(AIMSession sess, ICQMetaGeneral user) throws IOException {
        AIMConnection conn;
        if (sess == null || (conn = AIMConnection.findByGroup(sess, 21)) == null) {
            throw new NullPointerException();
        }
        ICQPacket p = new ICQPacket(sess.getSN(), 2000, 1002);
        AIMOutputStream buffer = new AIMOutputStream();
        buffer.writeStringLLLE0(user.getNick());
        buffer.writeStringLLLE0(user.getFirst());
        buffer.writeStringLLLE0(user.getLast());
        buffer.writeStringLLLE0(user.getEmail());
        buffer.writeStringLLLE0(user.getCity());
        buffer.writeStringLLLE0(user.getState());
        buffer.writeStringLLLE0(user.getPhone());
        buffer.writeStringLLLE0(user.getFax());
        buffer.writeStringLLLE0(user.getStreet());
        buffer.writeStringLLLE0(user.getCellular());
        buffer.writeStringLLLE0(user.getZip());
        buffer.writeShortLE(user.getCountry());
        buffer.writeByte(user.getTimezone());
        buffer.writeByte(user.getFlags());
        conn.enqueueFrame(new AIMFrame(conn, p, buffer));
    }

    public void metaSetMore(AIMSession sess, ICQMetaMore user) throws IOException {
        AIMConnection conn;
        if (sess == null || (conn = AIMConnection.findByGroup(sess, 21)) == null) {
            throw new NullPointerException();
        }
        ICQPacket p = new ICQPacket(sess.getSN(), 2000, 1021);
        AIMOutputStream buffer = new AIMOutputStream(12 + user.getHomepage().length() + 1);
        buffer.writeShortLE(user.getAge());
        buffer.writeByte(user.getSex());
        buffer.writeStringLLLE0(user.getHomepage());
        buffer.writeShortLE(user.getYear());
        buffer.writeByte(user.getMonth());
        buffer.writeByte(user.getDay());
        buffer.writeByte(user.getLang1());
        buffer.writeByte(user.getLang2());
        buffer.writeByte(user.getLang3());
        conn.enqueueFrame(new AIMFrame(conn, p, buffer));
    }

    public void metaSetAbout(AIMSession sess, String about) throws IOException {
        AIMConnection conn;
        if (sess == null || (conn = AIMConnection.findByGroup(sess, 21)) == null) {
            throw new NullPointerException();
        }
        ICQPacket p = new ICQPacket(sess.getSN(), 2000, 1030);
        AIMOutputStream buffer = new AIMOutputStream(2 + about.length() + 1);
        buffer.writeStringLLLE0(about);
        conn.enqueueFrame(new AIMFrame(conn, p, buffer));
    }

    public void metaSetOrg(AIMSession sess, byte orgCount, ArrayList orgAreas, ArrayList orgDescriptions, byte affiliationCount, ArrayList affiliationAreas, ArrayList affiliationDescriptions) throws IOException {
        int i;
        AIMConnection conn;
        if (sess == null || (conn = AIMConnection.findByGroup(sess, 21)) == null) {
            throw new NullPointerException();
        }
        ICQPacket p = new ICQPacket(sess.getSN(), 2000, 1060);
        AIMOutputStream buffer = new AIMOutputStream();
        buffer.writeByte(orgCount);
        for (i = 0; i < orgCount; ++i) {
            buffer.writeStringLLLE0((String)orgAreas.get(i));
            buffer.writeStringLLLE0((String)orgDescriptions.get(i));
        }
        buffer.writeByte(affiliationCount);
        for (i = 0; i < affiliationCount; ++i) {
            buffer.writeStringLLLE0((String)affiliationAreas.get(i));
            buffer.writeStringLLLE0((String)affiliationDescriptions.get(i));
        }
        conn.enqueueFrame(new AIMFrame(conn, p, buffer));
    }

    public void metaSetSecurity(AIMSession sess, byte auth, byte webAware, byte direct, byte kind) throws IOException {
        AIMConnection conn;
        if (sess == null || (conn = AIMConnection.findByGroup(sess, 21)) == null) {
            throw new NullPointerException();
        }
        ICQPacket p = new ICQPacket(sess.getSN(), 2000, 1060);
        AIMOutputStream buffer = new AIMOutputStream(4);
        buffer.writeByte(auth);
        buffer.writeByte(webAware);
        buffer.writeByte(direct);
        buffer.writeByte(kind);
        conn.enqueueFrame(new AIMFrame(conn, p, buffer));
    }

    public void metaSetPassword(AIMSession sess, String newPassword) throws IOException {
        AIMConnection conn;
        if (sess == null || (conn = AIMConnection.findByGroup(sess, 21)) == null) {
            throw new NullPointerException();
        }
        ICQPacket p = new ICQPacket(sess.getSN(), 2000, 1070);
        AIMOutputStream buffer = new AIMOutputStream(2 + newPassword.length() + 1);
        buffer.writeStringLLLE0(newPassword);
        conn.enqueueFrame(new AIMFrame(conn, p, buffer));
    }

    public void metaReqBasicInfo(AIMSession sess, int uin) throws IOException {
        AIMConnection conn;
        if (sess == null || (conn = AIMConnection.findByGroup(sess, 21)) == null) {
            throw new NullPointerException();
        }
        ICQPacket p = new ICQPacket(sess.getSN(), 2000, 1210);
        AIMOutputStream buffer = new AIMOutputStream(4);
        buffer.writeIntLE(uin);
        conn.enqueueFrame(new AIMFrame(conn, p, buffer));
    }

    public void metaReqUnkInfo(AIMSession sess, int uin) throws IOException {
        AIMConnection conn;
        if (sess == null || (conn = AIMConnection.findByGroup(sess, 21)) == null) {
            throw new NullPointerException();
        }
        ICQPacket p = new ICQPacket(sess.getSN(), 2000, 1202);
        AIMOutputStream buffer = new AIMOutputStream(4);
        buffer.writeIntLE(uin);
        conn.enqueueFrame(new AIMFrame(conn, p, buffer));
    }

    public void metaReqInfo(AIMSession sess, int uin) throws IOException {
        AIMConnection conn;
        if (sess == null || (conn = AIMConnection.findByGroup(sess, 21)) == null) {
            throw new NullPointerException();
        }
        ICQPacket p = new ICQPacket(sess.getSN(), 2000, 1232);
        AIMOutputStream buffer = new AIMOutputStream(4);
        buffer.writeIntLE(uin);
        conn.enqueueFrame(new AIMFrame(conn, p, buffer));
    }

    public void metaSearchWP(AIMSession sess, ICQMetaWP wp) throws IOException {
        AIMConnection conn;
        if (sess == null || (conn = AIMConnection.findByGroup(sess, 21)) == null) {
            throw new NullPointerException();
        }
        ICQPacket p = new ICQPacket(sess.getSN(), 2000, 1331);
        AIMOutputStream buffer = new AIMOutputStream();
        buffer.writeStringLLLE0(wp.getFirst());
        buffer.writeStringLLLE0(wp.getLast());
        buffer.writeStringLLLE0(wp.getNick());
        buffer.writeStringLLLE0(wp.getEmail());
        buffer.writeShortLE(wp.getMinAge());
        buffer.writeShortLE(wp.getMaxAge());
        buffer.writeByte(wp.getSex());
        buffer.writeByte(wp.getLanguage());
        buffer.writeStringLLLE0(wp.getCity());
        buffer.writeStringLLLE0(wp.getState());
        buffer.writeShortLE(wp.getCountry());
        buffer.writeStringLLLE0(wp.getCompany());
        buffer.writeStringLLLE0(wp.getDepartment());
        buffer.writeStringLLLE0(wp.getPosition());
        buffer.writeByte(wp.getOccupation());
        buffer.writeShortLE(wp.getPastArea());
        buffer.writeStringLLLE0(wp.getPastDescription());
        buffer.writeShortLE(wp.getInterestArea());
        buffer.writeStringLLLE0(wp.getInterestDescription());
        buffer.writeShortLE(wp.getAffiliationArea());
        buffer.writeStringLLLE0(wp.getAffiliationDescription());
        buffer.writeShortLE(wp.getHomepageArea());
        buffer.writeStringLLLE0(wp.getHomepageDescription());
        buffer.writeByte(wp.isOnline() ? 1 : 0);
        conn.enqueueFrame(new AIMFrame(conn, p, buffer));
    }

    public void searchByPersInf(AIMSession sess, String name, String surname, String nick, String email) throws IOException {
        AIMConnection conn;
        if (sess == null || (conn = AIMConnection.findByGroup(sess, 21)) == null) {
            throw new NullPointerException();
        }
        ICQPacket p = new ICQPacket(sess.getSN(), 2000, 1375);
        AIMOutputStream buffer = new AIMOutputStream();
        buffer.writeShortLE(320);
        buffer.writeStringLLLE0(name);
        buffer.writeShortLE(330);
        buffer.writeStringLLLE0(surname);
        buffer.writeShortLE(340);
        buffer.writeStringLLLE0(nick);
        buffer.writeShortLE(350);
        buffer.writeStringLLLE0(email);
        conn.enqueueFrame(new AIMFrame(conn, p, buffer));
    }

    public void searchByUIN(AIMSession sess, int uin) throws IOException {
        AIMConnection conn;
        if (sess == null || (conn = AIMConnection.findByGroup(sess, 21)) == null) {
            throw new NullPointerException();
        }
        ICQPacket p = new ICQPacket(sess.getSN(), 2000, 1385);
        AIMOutputStream buffer = new AIMOutputStream(10);
        buffer.writeShortLE(310);
        buffer.writeShortLE(4);
        buffer.writeIntLE(uin);
        conn.enqueueFrame(new AIMFrame(conn, p, buffer));
    }

    public void searchByMail(AIMSession sess, String email) throws IOException {
        AIMConnection conn;
        if (sess == null || (conn = AIMConnection.findByGroup(sess, 21)) == null) {
            throw new NullPointerException();
        }
        ICQPacket p = new ICQPacket(sess.getSN(), 2000, 1395);
        AIMOutputStream buffer = new AIMOutputStream(4 + email.length() + 1);
        buffer.writeShortLE(350);
        buffer.writeStringLLLE0(email);
        conn.enqueueFrame(new AIMFrame(conn, p, buffer));
    }

    public void searchRandom(AIMSession sess, int group) throws IOException {
        AIMConnection conn;
        if (sess == null || (conn = AIMConnection.findByGroup(sess, 21)) == null) {
            throw new NullPointerException();
        }
        ICQPacket p = new ICQPacket(sess.getSN(), 2000, 1870);
        AIMOutputStream buffer = new AIMOutputStream(2);
        buffer.writeShortLE(group);
        conn.enqueueFrame(new AIMFrame(conn, p, buffer));
    }

    public void setRandom(AIMSession sess, int group) throws IOException {
        AIMConnection conn;
        if (sess == null || (conn = AIMConnection.findByGroup(sess, 21)) == null) {
            throw new NullPointerException();
        }
        ICQPacket p = new ICQPacket(sess.getSN(), 2000, 1886);
        AIMOutputStream buffer = new AIMOutputStream(36);
        buffer.writeShortLE(group);
        if (group != 0) {
            buffer.writeIntLE(544);
            buffer.writeIntLE(0);
            buffer.writeIntLE(0);
            buffer.writeIntLE(0);
            buffer.writeByte(4);
            buffer.writeShortLE(2);
            buffer.writeIntLE(0);
            buffer.writeIntLE(20480);
            buffer.writeIntLE(768);
            buffer.writeShortLE(0);
        }
        conn.enqueueFrame(new AIMFrame(conn, p, buffer));
    }

    public void metaSomething(AIMSession sess) throws IOException {
        AIMConnection conn;
        if (sess == null || (conn = AIMConnection.findByGroup(sess, 21)) == null) {
            throw new NullPointerException();
        }
        ICQPacket p = new ICQPacket(sess.getSN(), 2000, 1880);
        AIMOutputStream buffer = new AIMOutputStream(35);
        buffer.writeIntLE(1);
        buffer.writeIntLE(8194);
        buffer.writeIntLE(0);
        buffer.writeIntLE(0);
        buffer.writeIntLE(0x8040000);
        buffer.writeIntLE(0);
        buffer.writeIntLE(0x50000000);
        buffer.writeIntLE(0x3000000);
        buffer.writeShortLE(0);
        buffer.writeByte(0);
        conn.enqueueFrame(new AIMFrame(conn, p, buffer));
    }

    public void reqXML(AIMSession sess) throws IOException {
        AIMConnection conn;
        if (sess == null || (conn = AIMConnection.findByGroup(sess, 21)) == null) {
            throw new NullPointerException();
        }
        String[] urls = new String[]{"ChannelsURL", "BannersURL", "DataFilesURL", "PartnersURL", "ReadersURL", "CLBannersURL", "DomainsURL", "LicenseKeysURL", "ShowMOTDOnFirstTime", "SMSShortSigTail", "SMSMedSigTail", "SMSLongSigTail", "ReportToICQ"};
        for (int i = 0; i < urls.length; ++i) {
            ICQPacket p = new ICQPacket(sess.getSN(), 2000, 2200);
            AIMOutputStream buffer = new AIMOutputStream();
            buffer.writeStringLLLE0("<key>" + urls[i] + "</key>");
            conn.enqueueFrame(new AIMFrame(conn, p, buffer));
        }
    }

    public void identifyClient(AIMSession sess) throws IOException {
        AIMConnection conn;
        if (sess == null || (conn = AIMConnection.findByGroup(sess, 21)) == null) {
            throw new NullPointerException();
        }
        ICQPacket p = new ICQPacket(sess.getSN(), 2000, 2750);
        AIMOutputStream buffer = new AIMOutputStream(80);
        ICQClientInfo ci = new ICQClientInfo();
        buffer.writeShortLE(ci.getMajor());
        buffer.writeShortLE(ci.getMinor());
        buffer.writeShortLE(ci.getPoint());
        buffer.writeShortLE(ci.getBuild());
        buffer.writeIntLE(ci.getDistributionCode());
        buffer.writeIntLE(740392080);
        buffer.writeIntLE(299060625);
        buffer.writeIntLE(67169197);
        buffer.writeIntLE(-1297443156);
        buffer.writeShortLE(0);
        buffer.writeIntLE(768);
        buffer.writeShortLE(11264);
        buffer.writeShortLE(1);
        buffer.writeShortLE(256);
        buffer.writeIntLE(0);
        buffer.writeIntLE(0);
        buffer.writeIntLE(0);
        buffer.writeIntLE(0);
        buffer.writeIntLE(0);
        buffer.writeIntLE(0);
        buffer.writeIntLE(0);
        buffer.writeIntLE(0);
        buffer.writeIntLE(0);
        buffer.writeIntLE(0);
        conn.enqueueFrame(new AIMFrame(conn, p, buffer));
    }

    public void sendSMS(AIMSession sess, ICQSMSMessage sms) throws IOException {
        AIMConnection conn;
        if (sess == null || (conn = AIMConnection.findByGroup(sess, 21)) == null) {
            throw new NullPointerException();
        }
        ICQPacket p = new ICQPacket(sess.getSN(), 2000, 5250);
        p.setSMS(true);
        String smsMessage = sms.toString();
        AIMOutputStream buffer = new AIMOutputStream(smsMessage.length());
        buffer.writeString(smsMessage);
        conn.enqueueFrame(new AIMFrame(conn, p, buffer));
    }

    /*
     * WARNING - void declaration
     */
    private void icqResponse(AIMSession sess, SNACHandler handler, AIMFrame frame, SNAC snac, AIMInputStream buffer) throws IOException {
        block25: {
            short subtype;
            block42: {
                AIMInputStream buffer2;
                block41: {
                    block40: {
                        block39: {
                            block38: {
                                block37: {
                                    void var20_67;
                                    block36: {
                                        void var20_64;
                                        block35: {
                                            block34: {
                                                block33: {
                                                    block32: {
                                                        block31: {
                                                            block30: {
                                                                block29: {
                                                                    block28: {
                                                                        block27: {
                                                                            short cmd;
                                                                            block26: {
                                                                                block24: {
                                                                                    TLVChain tlvchain = buffer.readTLVChain();
                                                                                    TLV tlv = tlvchain.getTLV(1, 1);
                                                                                    if (tlv == null) {
                                                                                        LOG.warn((Object)"corrupt ICQ response");
                                                                                        return;
                                                                                    }
                                                                                    buffer2 = new AIMInputStream(new ByteArrayInputStream(tlv.getValue()));
                                                                                    short cmdlen = buffer2.readShortLE();
                                                                                    int ouruin = buffer2.readIntLE();
                                                                                    cmd = buffer2.readShortLE();
                                                                                    short reqid = buffer2.readShortLE();
                                                                                    ICQPacket icqPacket = new ICQPacket("" + ouruin, cmd, 0);
                                                                                    icqPacket.setId(reqid);
                                                                                    frame.setICQPacket(icqPacket);
                                                                                    LOG.debug((Object)("<== ICQPACKET(0x" + Integer.toHexString(cmd) + ", 0x" + Integer.toHexString(reqid) + ")"));
                                                                                    byte[] b = buffer2.readBytes(buffer2.available());
                                                                                    LOG.debug((Object)AIMUtil.hexdump(b));
                                                                                    buffer2 = new AIMInputStream(new ByteArrayInputStream(b));
                                                                                    if (cmd != 65) break block24;
                                                                                    ICQOfflineMsg msg = new ICQOfflineMsg();
                                                                                    msg.setSender(buffer2.readIntLE());
                                                                                    msg.setYear(buffer2.readShortLE());
                                                                                    msg.setMonth(buffer2.readByte());
                                                                                    msg.setDay(buffer2.readByte());
                                                                                    msg.setHour(buffer2.readByte());
                                                                                    msg.setMinute(buffer2.readByte());
                                                                                    msg.setType(buffer2.readShortLE());
                                                                                    msg.setMsg(buffer2.readStringLLLE());
                                                                                    Iterator i = frame.getConn().getListeners(21, 3);
                                                                                    while (i.hasNext()) {
                                                                                        ((ICQListener)i.next()).srvOfflineMsg(sess, frame, msg);
                                                                                    }
                                                                                    break block25;
                                                                                }
                                                                                if (cmd != 66) break block26;
                                                                                Iterator i = frame.getConn().getListeners(21, 3);
                                                                                while (i.hasNext()) {
                                                                                    ((ICQListener)i.next()).srvOfflineMsgDone(sess, frame);
                                                                                }
                                                                                break block25;
                                                                            }
                                                                            if (cmd != 2010) break block25;
                                                                            subtype = buffer2.readShortLE();
                                                                            byte result = buffer2.readByte();
                                                                            LOG.debug((Object)("ICQ Meta command, subtype=0x" + Integer.toHexString(subtype) + ", result=0x" + Integer.toHexString(result)));
                                                                            if (result != 10) {
                                                                                return;
                                                                            }
                                                                            if (subtype != 100) break block27;
                                                                            Iterator iterator = frame.getConn().getListeners(21, 3);
                                                                            while (iterator.hasNext()) {
                                                                                ((ICQListener)iterator.next()).srvMetaGeneralDone(sess, frame);
                                                                            }
                                                                            break block25;
                                                                        }
                                                                        if (subtype != 120) break block28;
                                                                        Iterator iterator = frame.getConn().getListeners(21, 3);
                                                                        while (iterator.hasNext()) {
                                                                            ((ICQListener)iterator.next()).srvMetaMoreDone(sess, frame);
                                                                        }
                                                                        break block25;
                                                                    }
                                                                    if (subtype != 130) break block29;
                                                                    Iterator iterator = frame.getConn().getListeners(21, 3);
                                                                    while (iterator.hasNext()) {
                                                                        ((ICQListener)iterator.next()).srvMetaAboutDone(sess, frame);
                                                                    }
                                                                    break block25;
                                                                }
                                                                if (subtype != 170) break block30;
                                                                Iterator iterator = frame.getConn().getListeners(21, 3);
                                                                while (iterator.hasNext()) {
                                                                    ((ICQListener)iterator.next()).srvMetaPassDone(sess, frame);
                                                                }
                                                                break block25;
                                                            }
                                                            if (subtype != 200) break block31;
                                                            String string = buffer2.readStringLLLE();
                                                            String first = buffer2.readStringLLLE();
                                                            String last = buffer2.readStringLLLE();
                                                            String string2 = buffer2.readStringLLLE();
                                                            String city = buffer2.readStringLLLE();
                                                            String state = buffer2.readStringLLLE();
                                                            String phone = buffer2.readStringLLLE();
                                                            String fax = buffer2.readStringLLLE();
                                                            String street = buffer2.readStringLLLE();
                                                            String cellular = buffer2.readStringLLLE();
                                                            String zip = buffer2.readStringLLLE();
                                                            short country = buffer2.readShortLE();
                                                            byte timezone = buffer2.readByte();
                                                            byte flags = buffer2.readByte();
                                                            short unknown = buffer2.readShortLE();
                                                            ICQMetaGeneral img = new ICQMetaGeneral();
                                                            img.setNick(string);
                                                            img.setFirst(first);
                                                            img.setLast(last);
                                                            img.setEmail(string2);
                                                            img.setCity(city);
                                                            img.setState(state);
                                                            img.setPhone(phone);
                                                            img.setFax(fax);
                                                            img.setStreet(street);
                                                            img.setCellular(cellular);
                                                            img.setZip(zip);
                                                            img.setCountry(country);
                                                            img.setTimezone(timezone);
                                                            img.setFlags(flags);
                                                            img.setUnknown(unknown);
                                                            Iterator i = frame.getConn().getListeners(21, 3);
                                                            while (i.hasNext()) {
                                                                ((ICQListener)i.next()).srvMetaGeneral(sess, frame, img);
                                                            }
                                                            break block25;
                                                        }
                                                        if (subtype != 210) break block32;
                                                        String string = buffer2.readStringLLLE();
                                                        String state = buffer2.readStringLLLE();
                                                        String phone = buffer2.readStringLLLE();
                                                        String string3 = buffer2.readStringLLLE();
                                                        String address = buffer2.readStringLLLE();
                                                        String zip = buffer2.readStringLLLE();
                                                        short country = buffer2.readShortLE();
                                                        String company = buffer2.readStringLLLE();
                                                        String department = buffer2.readStringLLLE();
                                                        String position = buffer2.readStringLLLE();
                                                        short occupation = buffer2.readShortLE();
                                                        String homepage = buffer2.readStringLLLE();
                                                        ICQMetaWork imw = new ICQMetaWork();
                                                        imw.setCity(string);
                                                        imw.setState(state);
                                                        imw.setPhone(phone);
                                                        imw.setFax(string3);
                                                        imw.setAddress(address);
                                                        imw.setZip(zip);
                                                        imw.setCountry(country);
                                                        imw.setCompany(company);
                                                        imw.setDepartment(department);
                                                        imw.setPosition(position);
                                                        imw.setOccupation(occupation);
                                                        imw.setHomepage(homepage);
                                                        Iterator i = frame.getConn().getListeners(21, 3);
                                                        while (i.hasNext()) {
                                                            ((ICQListener)i.next()).srvMetaWork(sess, frame, imw);
                                                        }
                                                        break block25;
                                                    }
                                                    if (subtype != 220) break block33;
                                                    short s = buffer2.readShortLE();
                                                    byte sex = buffer2.readByte();
                                                    String homepage = buffer2.readStringLLLE();
                                                    short s2 = buffer2.readShortLE();
                                                    byte month = buffer2.readByte();
                                                    byte day = buffer2.readByte();
                                                    byte lang1 = buffer2.readByte();
                                                    byte lang2 = buffer2.readByte();
                                                    byte lang3 = buffer2.readByte();
                                                    short unknown = buffer2.readShortLE();
                                                    ICQMetaMore imm = new ICQMetaMore();
                                                    imm.setAge(s);
                                                    imm.setSex(sex);
                                                    imm.setHomepage(homepage);
                                                    imm.setYear(s2);
                                                    imm.setMonth(month);
                                                    imm.setDay(day);
                                                    imm.setLang1(lang1);
                                                    imm.setLang2(lang2);
                                                    imm.setLang3(lang3);
                                                    imm.setUnknown(unknown);
                                                    Iterator i = frame.getConn().getListeners(21, 3);
                                                    while (i.hasNext()) {
                                                        ((ICQListener)i.next()).srvMetaMore(sess, frame, imm);
                                                    }
                                                    break block25;
                                                }
                                                if (subtype != 230) break block34;
                                                String string = buffer2.readStringLLLE();
                                                Iterator i = frame.getConn().getListeners(21, 3);
                                                while (i.hasNext()) {
                                                    ((ICQListener)i.next()).srvMetaAbout(sess, frame, string);
                                                }
                                                break block25;
                                            }
                                            if (subtype != 235) break block35;
                                            byte by = buffer2.readByte();
                                            byte flags = buffer2.readByte();
                                            String email = buffer2.readStringLLLE();
                                            Iterator iterator = frame.getConn().getListeners(21, 3);
                                            while (iterator.hasNext()) {
                                                ((ICQListener)iterator.next()).srvMetaMoreEmail(sess, frame, by, flags, email);
                                            }
                                            break block25;
                                        }
                                        if (subtype != 240) break block36;
                                        byte by = buffer2.readByte();
                                        ArrayList<Short> interestAreas = new ArrayList<Short>(by);
                                        ArrayList<String> interestDescriptions = new ArrayList<String>(by);
                                        boolean bl = false;
                                        while (var20_64 < by) {
                                            short interestArea = buffer2.readShortLE();
                                            String interestDescription = buffer2.readStringLLLE();
                                            interestAreas.add(new Short(interestArea));
                                            interestDescriptions.add(interestDescription);
                                            ++var20_64;
                                        }
                                        Iterator iterator = frame.getConn().getListeners(21, 3);
                                        while (iterator.hasNext()) {
                                            ((ICQListener)iterator.next()).srvMetaInterest(sess, frame, by, interestAreas, interestDescriptions);
                                        }
                                        break block25;
                                    }
                                    if (subtype != 248) break block37;
                                    byte by = buffer2.readByte();
                                    ArrayList<Short> pastAreas = new ArrayList<Short>(by);
                                    ArrayList<String> pastDescriptions = new ArrayList<String>(by);
                                    boolean bl = false;
                                    while (var20_67 < by) {
                                        short pastArea = buffer2.readShortLE();
                                        String pastDescription = buffer2.readStringLLLE();
                                        pastAreas.add(new Short(pastArea));
                                        pastDescriptions.add(pastDescription);
                                        ++var20_67;
                                    }
                                    byte by2 = buffer2.readByte();
                                    ArrayList<Short> affiliationAreas = new ArrayList<Short>(by2);
                                    ArrayList<String> affiliationDescriptions = new ArrayList<String>(by2);
                                    for (int i = 0; i < by2; ++i) {
                                        short affiliationArea = buffer2.readShortLE();
                                        String affiliationDescription = buffer2.readStringLLLE();
                                        affiliationAreas.add(new Short(affiliationArea));
                                        affiliationDescriptions.add(affiliationDescription);
                                    }
                                    Iterator i = frame.getConn().getListeners(21, 3);
                                    while (i.hasNext()) {
                                        ((ICQListener)i.next()).srvMetaBackground(sess, frame, by, pastAreas, pastDescriptions, by2, affiliationAreas, affiliationDescriptions);
                                    }
                                    break block25;
                                }
                                if (subtype != 261 && subtype != 260) break block38;
                                String string = buffer2.readStringLLLE();
                                String first = buffer2.readStringLLLE();
                                String last = buffer2.readStringLLLE();
                                String string4 = buffer2.readStringLLLE();
                                ICQMetaGeneral img = new ICQMetaGeneral();
                                img.setNick(string);
                                img.setFirst(first);
                                img.setLast(last);
                                img.setEmail(string4);
                                Iterator i = frame.getConn().getListeners(21, 3);
                                while (i.hasNext()) {
                                    ((ICQListener)i.next()).srvMetaInfo(sess, frame, img);
                                }
                                break block25;
                            }
                            if (subtype != 270) break block39;
                            int n = buffer2.readIntLE();
                            Iterator i = frame.getConn().getListeners(21, 3);
                            while (i.hasNext()) {
                                ((ICQListener)i.next()).srvMeta10E(sess, frame, n);
                            }
                            break block25;
                        }
                        if (subtype != 420) break block40;
                        short s = buffer2.readShortLE();
                        int uin = buffer2.readIntLE();
                        String nick = buffer2.readStringLLLE();
                        String string = buffer2.readStringLLLE();
                        String last = buffer2.readStringLLLE();
                        String email = buffer2.readStringLLLE();
                        byte flags = buffer2.readByte();
                        short status = buffer2.readShortLE();
                        byte sex = buffer2.readByte();
                        byte age = buffer2.readByte();
                        byte unknown = buffer2.readByte();
                        ICQMetaFound imf = new ICQMetaFound();
                        imf.setUIN(uin);
                        imf.setNick(nick);
                        imf.setFirst(string);
                        imf.setLast(last);
                        imf.setEmail(email);
                        imf.setFlags(flags);
                        imf.setStatus(status);
                        imf.setSex(sex);
                        imf.setAge(age);
                        imf.setUnknown(unknown);
                        Iterator i = frame.getConn().getListeners(21, 3);
                        while (i.hasNext()) {
                            ((ICQListener)i.next()).srvMetaFound(sess, frame, imf);
                        }
                        break block25;
                    }
                    if (subtype != 430) break block41;
                    short s = buffer2.readShortLE();
                    int uin = buffer2.readIntLE();
                    String nick = buffer2.readStringLLLE();
                    String string = buffer2.readStringLLLE();
                    String last = buffer2.readStringLLLE();
                    String email = buffer2.readStringLLLE();
                    byte flags = buffer2.readByte();
                    short status = buffer2.readShortLE();
                    byte sex = buffer2.readByte();
                    byte age = buffer2.readByte();
                    int missed = buffer2.readIntLE();
                    byte unknown = buffer2.readByte();
                    ICQMetaFound imf = new ICQMetaFound();
                    imf.setUIN(uin);
                    imf.setNick(nick);
                    imf.setFirst(string);
                    imf.setLast(last);
                    imf.setEmail(email);
                    imf.setFlags(flags);
                    imf.setStatus(status);
                    imf.setSex(sex);
                    imf.setAge(age);
                    imf.setUnknown(unknown);
                    Iterator i = frame.getConn().getListeners(21, 3);
                    while (i.hasNext()) {
                        ((ICQListener)i.next()).srvMetaLast(sess, frame, imf, missed);
                    }
                    break block25;
                }
                if (subtype != 870) break block42;
                int n = buffer2.readIntLE();
                short group = buffer2.readShortLE();
                byte[] externalIP = buffer2.readBytes(4);
                int n2 = buffer2.readIntLE();
                byte[] internalIP = buffer2.readBytes(4);
                byte tcpFlags = buffer2.readByte();
                short tcpVersion = buffer2.readShortLE();
                byte[] unknown = buffer2.readBytes(buffer.available());
                Iterator i = frame.getConn().getListeners(21, 3);
                while (i.hasNext()) {
                    ((ICQListener)i.next()).srvMetaRandom(sess, frame, n, group, externalIP, n2, internalIP, tcpFlags, tcpVersion, unknown);
                }
                break block25;
            }
            if (subtype != 880) break block25;
            Iterator iterator = frame.getConn().getListeners(21, 3);
            while (iterator.hasNext()) {
                ((ICQListener)iterator.next()).srvMetaRandomDone(sess, frame);
            }
        }
    }

    public void handleSNAC(AIMSession sess, SNACHandler handler, AIMFrame frame, SNAC snac, AIMInputStream buffer) throws IOException {
        if (snac.getSubtype() == 3) {
            this.icqResponse(sess, handler, frame, snac, buffer);
        } else {
            LOG.warn((Object)("Unrecognized SNAC(" + Integer.toHexString(snac.getFamily()) + ", " + Integer.toHexString(snac.getSubtype()) + ")"));
            frame.setHandled(false);
        }
    }
}

