/*
 * Decompiled with CFR 0.152.
 */
package org.walluck.oscar.handlers;

import java.io.IOException;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.walluck.oscar.AIMConnection;
import org.walluck.oscar.AIMFrame;
import org.walluck.oscar.AIMInputStream;
import org.walluck.oscar.AIMOutputStream;
import org.walluck.oscar.AIMSession;
import org.walluck.oscar.FLAP;
import org.walluck.oscar.SNAC;
import org.walluck.oscar.handlers.IconListener;
import org.walluck.oscar.handlers.SNACHandler;

public class IconHandler
extends SNACHandler {
    private static final Logger LOG = Logger.getLogger((String)IconHandler.class.getName());

    public IconHandler() {
        this.setFamily(16);
        this.setVersion(1);
    }

    public void upload(AIMSession sess, byte[] icon) throws IOException {
        AIMConnection conn;
        if (sess == null || (conn = AIMConnection.findByGroup(sess, this.getFamily())) == null || icon == null || icon.length == 0) {
            throw new NullPointerException();
        }
        FLAP flap = new FLAP(2);
        SNAC snac = new SNAC(16, 2, 0, null, true);
        AIMOutputStream buffer = new AIMOutputStream(4 + icon.length);
        buffer.writeShort(1);
        buffer.writeShort(icon.length);
        buffer.writeBytes(icon);
        conn.enqueueFrame(new AIMFrame(conn, 0, flap, snac, buffer));
    }

    private void uploadAck(AIMSession sess, SNACHandler handler, AIMFrame frame, SNAC snac, AIMInputStream buffer) throws IOException {
        byte[] cksum = buffer.readBytes(buffer.getEmpty());
        Iterator i = frame.getConn().getListeners(16, 3);
        while (i.hasNext()) {
            ((IconListener)i.next()).uploadAck(sess, frame, cksum);
        }
    }

    public void request(AIMSession sess, String sn, byte[] iconcsum) throws IOException {
        AIMConnection conn;
        if (sess == null || (conn = AIMConnection.findByGroup(sess, this.getFamily())) == null) {
            throw new NullPointerException();
        }
        FLAP flap = new FLAP(2);
        SNAC snac = new SNAC(16, 4, 0, null, true);
        AIMOutputStream buffer = new AIMOutputStream(1 + sn.length() + 4 + 1 + iconcsum.length);
        buffer.writeStringL(sn);
        buffer.writeByte(1);
        buffer.writeShort(1);
        buffer.writeByte(1);
        buffer.writeByte(iconcsum.length);
        buffer.writeBytes(iconcsum);
        conn.enqueueFrame(new AIMFrame(conn, 0, flap, snac, buffer));
    }

    private void parseIcon(AIMSession sess, SNACHandler handler, AIMFrame frame, SNAC snac, AIMInputStream buffer) throws IOException {
        String sn = buffer.readStringL();
        LOG.debug((Object)("parseIcon: sn=" + sn));
        short flags = buffer.readShort();
        byte number = buffer.readByte();
        byte iconsumlen = buffer.readByte();
        byte[] iconcsum = buffer.readBytes(iconsumlen);
        short iconlen = buffer.readShort();
        byte[] icon = buffer.readBytes(iconlen);
        Iterator i = frame.getConn().getListeners(16, 5);
        while (i.hasNext()) {
            ((IconListener)i.next()).parseIcon(sess, frame, sn, iconcsum, icon);
        }
    }

    public void handleSNAC(AIMSession sess, SNACHandler handler, AIMFrame frame, SNAC snac, AIMInputStream buffer) throws IOException {
        if (snac.getSubtype() == 3) {
            this.uploadAck(sess, handler, frame, snac, buffer);
        } else if (snac.getSubtype() == 5) {
            this.parseIcon(sess, handler, frame, snac, buffer);
        } else {
            LOG.warn((Object)("Unrecognized SNAC(" + Integer.toHexString(snac.getFamily()) + ", " + Integer.toHexString(snac.getSubtype()) + ")"));
            frame.setHandled(false);
        }
    }
}

