/*
 * Decompiled with CFR 0.152.
 */
package org.walluck.oscar.handlers;

import java.io.IOException;
import java.net.InetAddress;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import org.apache.log4j.Logger;
import org.walluck.oscar.AIMConnection;
import org.walluck.oscar.AIMFrame;
import org.walluck.oscar.AIMInputStream;
import org.walluck.oscar.AIMOutputStream;
import org.walluck.oscar.AIMSession;
import org.walluck.oscar.AIMUtil;
import org.walluck.oscar.Chat;
import org.walluck.oscar.FLAP;
import org.walluck.oscar.RateClass;
import org.walluck.oscar.Redir;
import org.walluck.oscar.SNAC;
import org.walluck.oscar.SNACPair;
import org.walluck.oscar.SNACVersion;
import org.walluck.oscar.TLV;
import org.walluck.oscar.TLVChain;
import org.walluck.oscar.UserInfo;
import org.walluck.oscar.handlers.MiscHandler;
import org.walluck.oscar.handlers.SNACHandler;
import org.walluck.oscar.handlers.ServiceListener;
import org.walluck.oscar.handlers.icq.tcp.DirectClient;
import org.walluck.oscar.tools.Tool;

public class ServiceHandler
extends SNACHandler {
    private static final Logger LOG = Logger.getLogger((String)ServiceHandler.class.getName());

    public ServiceHandler() {
        this.setFamily(1);
        this.setVersion(3);
    }

    public void clientReady(AIMSession sess, AIMConnection conn) throws IOException {
        FLAP flap = new FLAP(2);
        SNAC snac = new SNAC(1, 2, 0, null, false);
        AIMOutputStream buffer = new AIMOutputStream();
        Iterator i = sess.getHandlers().iterator();
        while (i.hasNext()) {
            SNACHandler handler = (SNACHandler)i.next();
            int group = -1;
            if (handler == null || !conn.supportsGroup(handler.getFamily())) continue;
            buffer.writeShort(handler.getFamily());
            buffer.writeShort(handler.getVersion());
            Tool tool = sess.getTool(handler.getFamily());
            if (tool != null) {
                buffer.writeShort(tool.getId());
                buffer.writeShort(tool.getVersion());
            }
            LOG.debug((Object)("clientReady: 0x" + Integer.toHexString(handler.getFamily()) + "/0x" + Integer.toHexString(handler.getVersion()) + "/0x" + Integer.toHexString(tool.getId()) + "/0x" + Integer.toHexString(tool.getVersion())));
        }
        conn.enqueueFrame(new AIMFrame(conn, 0, flap, snac, buffer));
    }

    private void hostOnline(AIMSession sess, SNACHandler handler, AIMFrame frame, SNAC snac, AIMInputStream buffer) throws IOException {
        while (!buffer.isEmpty()) {
            frame.getConn().addGroup(buffer.readShort());
        }
        this.sendVersions(sess, frame.getConn());
    }

    public void reqService(AIMSession sess, AIMConnection conn, int serviceID) throws IOException {
        MiscHandler misc = (MiscHandler)sess.getHandler(65535);
        misc.genericReqShort(sess, conn, 1, 4, serviceID);
    }

    private void redirect(AIMSession sess, SNACHandler handler, AIMFrame frame, SNAC snac, AIMInputStream buffer) throws IOException {
        TLVChain tlvchain = buffer.readTLVChain();
        Redir redir = new Redir();
        short group = tlvchain.getTLV(13, 1).getValueShort();
        redir.setGroup(group);
        String ip = tlvchain.getTLV(5, 1).getValueString();
        redir.setIp(ip);
        byte[] cookie = tlvchain.getTLV(6, 1).getValue();
        redir.setCookie(cookie);
        LOG.debug((Object)("Got redirect for group 0x" + Integer.toHexString(group) + " to ip address " + ip));
        SNAC origSNAC = frame.getConn().remSNAC(snac.getId());
        if (redir.getGroup() == 14 && origSNAC != null) {
            Chat chat = (Chat)origSNAC.getData();
            redir.setChat(chat);
        }
        Iterator i = frame.getConn().getListeners(1, 5);
        while (i.hasNext()) {
            ((ServiceListener)i.next()).redirect(sess, frame, redir);
        }
    }

    private void reqRates(AIMSession sess, AIMConnection conn) throws IOException {
        MiscHandler misc = (MiscHandler)sess.getHandler(65535);
        misc.genericReqNull(sess, conn, 1, 6);
    }

    private void rcAddClass(AIMConnection conn, RateClass rc) {
        conn.addRate(rc);
    }

    private RateClass rcFindClass(AIMConnection conn, int classID) {
        return conn.findRate(classID);
    }

    private void rcAddPair(AIMConnection conn, RateClass rc, int family, int subtype) {
        SNACPair sp = new SNACPair();
        sp.setRateClass(rc);
        sp.setFamily(family);
        sp.setSubtype(subtype);
        conn.getMembers().add(sp);
    }

    private void rateResp(AIMSession sess, SNACHandler handler, AIMFrame frame, SNAC snac, AIMInputStream buffer) throws IOException {
        int i;
        int numclasses = buffer.readShort();
        for (i = 0; i < numclasses; ++i) {
            RateClass rc = buffer.readRateClass();
            if (handler.getVersion() >= 3) {
                rc.setUnknown(buffer.readBytes(5));
            }
            LOG.debug((Object)("Adding rate class id = " + rc.getClassID() + ", window size = " + rc.getWindowSize() + ", clear = " + rc.getClear() + ", alert = " + rc.getAlert() + ", limit = " + rc.getLimit() + ", disconnect = " + rc.getDisconnect() + ", current = " + rc.getCurrent() + ", max = " + rc.getMax() + ", unknown = " + AIMUtil.byteArrayToHexString(rc.getUnknown())));
            LOG.debug((Object)"Setting rc.getCurrent() to rc.getMax()");
            rc.setCurrent(rc.getMax());
            this.rcAddClass(frame.getConn(), rc);
        }
        for (i = 0; i < numclasses; ++i) {
            short classID = buffer.readShort();
            int count = buffer.readShort();
            RateClass rc = this.rcFindClass(frame.getConn(), classID);
            for (int j = 0; j < count; ++j) {
                short family = buffer.readShort();
                short subtype = buffer.readShort();
                if (rc == null) continue;
                this.rcAddPair(frame.getConn(), rc, family, subtype);
            }
        }
        this.ratesAddParam(sess, frame.getConn());
        Iterator i2 = frame.getConn().getListeners(1, 7);
        while (i2.hasNext()) {
            ((ServiceListener)i2.next()).rateResp(sess, frame);
        }
    }

    public void ratesAddParam(AIMSession sess, AIMConnection conn) throws IOException {
        FLAP flap = new FLAP(2);
        SNAC snac = new SNAC(1, 8, 0, null, false);
        AIMOutputStream buffer = new AIMOutputStream();
        Iterator i = conn.getRates().iterator();
        while (i.hasNext()) {
            RateClass rc = (RateClass)i.next();
            buffer.writeShort(rc.getClassID());
        }
        conn.enqueueFrame(new AIMFrame(conn, 0, flap, snac, buffer));
    }

    public void ratesDelParam(AIMSession sess, AIMConnection conn) throws IOException {
        FLAP flap = new FLAP(2);
        SNAC snac = new SNAC(1, 9, 0, null, false);
        AIMOutputStream buffer = new AIMOutputStream();
        Iterator i = conn.getRates().iterator();
        while (i.hasNext()) {
            RateClass rc = (RateClass)i.next();
            buffer.writeShort(rc.getClassID());
            LOG.debug((Object)("Writing class: 0x" + Integer.toHexString(rc.getClassID())));
        }
        conn.enqueueFrame(new AIMFrame(conn, 0, flap, snac, buffer));
    }

    private void rateChange(AIMSession sess, SNACHandler handler, AIMFrame frame, SNAC snac, AIMInputStream buffer) throws IOException {
        short code = buffer.readShort();
        RateClass rc = buffer.readRateClass();
        frame.getConn().updateRate(rc.getClassID());
        if (code == 3) {
            frame.getConn().findRate(rc.getClassID()).setLimited(true);
        }
        Iterator i = frame.getConn().getListeners(1, 10);
        while (i.hasNext()) {
            ((ServiceListener)i.next()).rateChange(sess, frame, code, rc);
        }
    }

    private void serverPause(AIMSession sess, SNACHandler handler, AIMFrame frame, SNAC snac, AIMInputStream buffer) {
        Iterator i = frame.getConn().getListeners(1, 11);
        while (i.hasNext()) {
            ((ServiceListener)i.next()).serverPause(sess, frame);
        }
    }

    public void sendPauseAck(AIMSession sess, AIMConnection conn) throws IOException {
        FLAP flap = new FLAP(2);
        SNAC snac = new SNAC(1, 12, 0, null, false);
        AIMOutputStream buffer = new AIMOutputStream();
        Iterator i = sess.getHandlers().iterator();
        while (i.hasNext()) {
            int group = ((SNACHandler)i.next()).getFamily();
            if (!conn.supportsGroup(group)) continue;
            buffer.writeShort(group);
        }
        conn.enqueueFrame(new AIMFrame(conn, 0, flap, snac, buffer));
    }

    private void serverResume(AIMSession sess, SNACHandler handler, AIMFrame frame, SNAC snac, AIMInputStream buffer) {
        Iterator i = frame.getConn().getListeners(1, 13);
        while (i.hasNext()) {
            ((ServiceListener)i.next()).serverResume(sess, frame);
        }
    }

    public void reqPersonalInfo(AIMSession sess, AIMConnection conn) throws IOException {
        MiscHandler misc = (MiscHandler)sess.getHandler(65535);
        misc.genericReqNull(sess, conn, 1, 14);
    }

    private void selfInfo(AIMSession sess, SNACHandler handler, AIMFrame frame, SNAC snac, AIMInputStream buffer) throws IOException {
        UserInfo userinfo = buffer.readUserInfo();
        Iterator i = frame.getConn().getListeners(1, 15);
        while (i.hasNext()) {
            ((ServiceListener)i.next()).selfInfo(sess, frame, userinfo);
        }
    }

    private void evilNotify(AIMSession sess, SNACHandler handler, AIMFrame frame, SNAC snac, AIMInputStream buffer) throws IOException {
        UserInfo userinfo = null;
        short newEvil = buffer.readShort();
        if (!buffer.isEmpty()) {
            userinfo = buffer.readUserInfo();
        }
        Iterator i = frame.getConn().getListeners(1, 16);
        while (i.hasNext()) {
            ((ServiceListener)i.next()).evilNotify(sess, frame, newEvil, userinfo);
        }
    }

    public void setIdle(AIMSession sess, int idleTime) throws IOException {
        AIMConnection conn;
        if (sess == null || (conn = AIMConnection.findByGroup(sess, 4)) == null) {
            throw new NullPointerException();
        }
        MiscHandler misc = (MiscHandler)sess.getHandler(65535);
        misc.genericReqInt(sess, conn, 1, 17, idleTime, false);
    }

    private void migrate(AIMSession sess, SNACHandler handler, AIMFrame frame, SNAC snac, AIMInputStream buffer) throws IOException {
        int groupCount = buffer.readShort();
        for (int i = 0; i < groupCount; ++i) {
            short group = buffer.readShort();
            LOG.warn((Object)("Bifurcated migration unsupported, group=" + Integer.toHexString(group)));
        }
        TLVChain tlvchain = buffer.readTLVChain();
        String ip = null;
        TLV tlv = tlvchain.getTLV(5, 1);
        if (tlv != null) {
            ip = tlv.getValueString();
        }
        byte[] cookie = tlvchain.getTLV(6, 1).getValue();
        Iterator i = frame.getConn().getListeners(1, 18);
        while (i.hasNext()) {
            ((ServiceListener)i.next()).migrate(sess, frame, ip, cookie);
        }
    }

    private void motd(AIMSession sess, SNACHandler handler, AIMFrame frame, SNAC snac, AIMInputStream buffer) throws IOException {
        short id = buffer.readShort();
        TLVChain tlvchain = buffer.readTLVChain();
        String msg = null;
        TLV tlv = tlvchain.getTLV(11, 1);
        if (tlv != null) {
            msg = tlv.getValueString();
        }
        Iterator i = frame.getConn().getListeners(1, 19);
        while (i.hasNext()) {
            ((ServiceListener)i.next()).motd(sess, frame, id, msg);
        }
    }

    public void setPrivacyFlags(AIMSession sess, AIMConnection conn, int flags) throws IOException {
        MiscHandler misc = (MiscHandler)sess.getHandler(65535);
        misc.genericReqInt(sess, conn, 1, 20, flags, false);
    }

    public void nop(AIMSession sess, AIMConnection conn) throws IOException {
        MiscHandler misc = (MiscHandler)sess.getHandler(65535);
        misc.genericReqNull(sess, conn, 1, 22);
    }

    private void sendVersions(AIMSession sess, AIMConnection conn) throws IOException {
        FLAP flap = new FLAP(2);
        SNAC snac = new SNAC(1, 23, 0, null, false);
        AIMOutputStream buffer = new AIMOutputStream();
        Iterator i = sess.getHandlers().iterator();
        while (i.hasNext()) {
            SNACHandler handler = (SNACHandler)i.next();
            int group = -1;
            if (handler == null || !conn.supportsGroup(handler.getFamily())) continue;
            buffer.writeShort(handler.getFamily());
            buffer.writeShort(handler.getVersion());
            LOG.debug((Object)("sendVersions: 0x" + Integer.toHexString(handler.getFamily()) + "/0x" + Integer.toHexString(handler.getVersion())));
        }
        conn.enqueueFrame(new AIMFrame(conn, 0, flap, snac, buffer));
    }

    private void hostVersions(AIMSession sess, SNACHandler handler, AIMFrame frame, SNAC snac, AIMInputStream buffer) throws IOException {
        ArrayList<SNACVersion> serverHandlers = new ArrayList<SNACVersion>(buffer.getEmpty() / 4);
        while (!buffer.isEmpty()) {
            SNACVersion sp = new SNACVersion();
            sp.setFamily(buffer.readShort());
            sp.setVersion(buffer.readShort());
            serverHandlers.add(sp);
            LOG.debug((Object)("hostVersions: 0x" + Integer.toHexString(sp.getFamily()) + "/0x" + Integer.toHexString(sp.getVersion())));
        }
        Iterator i = serverHandlers.iterator();
        while (i.hasNext()) {
            SNACVersion sp = (SNACVersion)i.next();
            SNACHandler handler2 = sess.getHandler(sp.getFamily());
            if (handler2 != null) {
                if (sp.getVersion() == handler2.getVersion()) continue;
                LOG.warn((Object)("hostVersions: handler mismatch for family 0x" + Integer.toHexString(sp.getFamily()) + ". We support version " + handler.getVersion() + ", but the server supports version " + sp.getVersion()));
                continue;
            }
            if (sess.isICQ() || sp.getFamily() == 21) continue;
            LOG.warn((Object)("hostVersions: We don't support family " + Integer.toHexString(sp.getFamily()) + " but the server does"));
        }
        this.reqRates(sess, frame.getConn());
    }

    public void setExtStatus(AIMSession sess, int status) throws IOException {
        AIMConnection conn;
        if (sess == null || (conn = AIMConnection.findByGroup(sess, 4)) == null) {
            throw new NullPointerException();
        }
        int ourStatus = 0x20020000 | status;
        FLAP flap = new FLAP(2);
        SNAC snac = new SNAC(1, 30, 0, null, false);
        TLVChain tlvchain = new TLVChain(3);
        tlvchain.addInt(6, ourStatus);
        tlvchain.addShort(8, 0);
        AIMOutputStream buffer2 = new AIMOutputStream(37);
        DirectClient dc = new DirectClient(sess, Integer.parseInt(sess.getSN()), null, 0, true);
        dc.start();
        buffer2.writeBytes(InetAddress.getLocalHost().getAddress());
        buffer2.writeInt(dc.getLocalPort());
        buffer2.writeByte(4);
        buffer2.writeShort(8);
        buffer2.writeInt(new Random().nextInt());
        buffer2.writeInt(80);
        buffer2.writeInt(3);
        buffer2.writeInt((int)(System.currentTimeMillis() - 1814400000L));
        buffer2.writeInt((int)System.currentTimeMillis());
        buffer2.writeInt((int)(System.currentTimeMillis() - 300000L));
        buffer2.writeShort(0);
        tlvchain.addBytes(12, buffer2.getBytes());
        AIMOutputStream buffer = new AIMOutputStream(tlvchain.length());
        buffer.writeTLVChain(tlvchain);
        conn.enqueueFrame(new AIMFrame(conn, 0, flap, snac, buffer));
    }

    public void setAvailableMsg(AIMSession sess, String msg, String enc) throws IOException {
        AIMConnection conn;
        if (sess == null || (conn = AIMConnection.findByGroup(sess, 4)) == null) {
            throw new NullPointerException();
        }
        FLAP flap = new FLAP(2);
        SNAC snac = new SNAC(1, 30, 0, null, false);
        int msglen = msg != null ? msg.length() : 0;
        AIMOutputStream buffer2 = new AIMOutputStream(8 + msglen);
        buffer2.writeShort(2);
        buffer2.writeByte(4);
        buffer2.writeByte(msglen + 4);
        buffer2.writeStringLL(msg);
        if (enc == null || enc.equals("utf-8")) {
            buffer2.writeShort(0);
        } else {
            buffer2.writeShort(1);
            buffer2.writeShort(0);
            buffer2.writeStringLL(enc);
        }
        TLVChain tlvchain = new TLVChain(1);
        tlvchain.addBytes(29, buffer2.getBytes());
        AIMOutputStream buffer = new AIMOutputStream(tlvchain.length());
        buffer.writeTLVChain(tlvchain);
        conn.enqueueFrame(new AIMFrame(conn, 0, flap, snac, buffer));
    }

    private void memRequest(AIMSession sess, SNACHandler handler, AIMFrame frame, SNAC snac, AIMInputStream buffer) throws IOException {
        int offset = buffer.readInt();
        int len = buffer.readInt();
        TLVChain tlvchain = buffer.readTLVChain();
        String modname = tlvchain.getTLV(1, 1).getValueString();
        LOG.warn((Object)("memRequest: Data at " + Integer.toHexString(offset) + "(" + len + " bytes) of " + (modname != null ? modname : "aim.exe") + " requested"));
        Iterator i = frame.getConn().getListeners(1, 31);
        while (i.hasNext()) {
            ((ServiceListener)i.next()).memRequest(sess, frame, offset, len, modname);
        }
    }

    public void sendMemBlock(AIMSession sess, AIMConnection conn, int offset, int len, byte[] buf, int flag) throws IOException {
        if (sess == null || conn == null) {
            throw new NullPointerException();
        }
        FLAP flap = new FLAP(2);
        SNAC snac = new SNAC(1, 32, 0, null, false);
        AIMOutputStream buffer = new AIMOutputStream(34);
        buffer.writeShort(16);
        if (flag == 1 && buf != null && len == 16) {
            buffer.writeByte(16);
        } else if (buf != null && len > 0) {
            try {
                MessageDigest md = MessageDigest.getInstance("MD5");
                md.update(buf);
                buffer.writeBytes(md.digest());
            }
            catch (NoSuchAlgorithmException nsae) {
                LOG.error((Object)"NoSuchAlgorithmException", (Throwable)nsae);
            }
        } else if (len == 0) {
            try {
                MessageDigest md = MessageDigest.getInstance("MD5");
                md.update(new byte[]{0});
                buffer.writeBytes(md.digest());
            }
            catch (NoSuchAlgorithmException nsae) {
                LOG.error((Object)"NoSuchAlgorithmException", (Throwable)nsae);
            }
        } else if (offset == 0x3FFFFFF && len == 0x3FFFFFF) {
            buffer.writeInt(1151950118);
            buffer.writeInt(-766966749);
            buffer.writeInt(-1816624609);
            buffer.writeInt(1371884289);
        } else if (offset == 4096 && len == 0) {
            buffer.writeInt(-736260903);
            buffer.writeInt(-1895779836);
            buffer.writeInt(-377484904);
            buffer.writeInt(-319274370);
        } else {
            LOG.warn((Object)("Unknown hash request: offset=" + offset + ", length=" + len));
        }
        conn.enqueueFrame(new AIMFrame(conn, 0, flap, snac, buffer));
    }

    private void extStatus(AIMSession sess, SNACHandler handler, AIMFrame frame, SNAC snac, AIMInputStream buffer) throws IOException {
        short type = buffer.readShort();
        byte flags = buffer.readByte();
        byte length = buffer.readByte();
        switch (type) {
            case 0: 
            case 1: {
                break;
            }
            case 2: {
                break;
            }
        }
        frame.setHandled(false);
    }

    public void setSecureIM(AIMSession sess) throws IOException {
        AIMConnection conn;
        byte[] md5sum = null;
        if (sess == null || (conn = AIMConnection.findByGroup(sess, 4)) == null) {
            throw new NullPointerException();
        }
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md5sum = md.digest();
        }
        catch (NoSuchAlgorithmException nsae) {
            LOG.error((Object)"NoSuchAlgorithmException", (Throwable)nsae);
        }
        FLAP flap = new FLAP(2);
        SNAC snac = new SNAC(1, 34, 0, null, false);
        AIMOutputStream buffer = new AIMOutputStream(2 * (4 + md5sum.length));
        buffer.writeShort(1026);
        buffer.writeByte(1);
        buffer.writeByte(md5sum.length);
        buffer.writeBytes(md5sum);
        buffer.writeShort(1027);
        buffer.writeByte(1);
        buffer.writeByte(md5sum.length);
        buffer.writeBytes(md5sum);
        conn.enqueueFrame(new AIMFrame(conn, 0, flap, snac, buffer));
    }

    private void secureIM(AIMSession sess, SNACHandler handler, AIMFrame frame, SNAC snac, AIMInputStream buffer) throws IOException {
        short type = buffer.readShort();
        byte flag = buffer.readByte();
        byte length = buffer.readByte();
        byte[] md5sum = buffer.readBytes(length);
        LOG.debug((Object)("type=0x" + Integer.toHexString(type) + ", flag=0x" + Integer.toHexString(flag) + ", length=" + length + ", md5sum=" + AIMUtil.byteArrayToHexString(md5sum)));
        byte seven = buffer.readByte();
        if (seven != 7) {
            LOG.warn((Object)("Expected byte=0x7, but byte=0x" + Integer.toHexString(seven)));
        }
        type = buffer.readShort();
        flag = buffer.readByte();
        length = buffer.readByte();
        md5sum = buffer.readBytes(length);
        LOG.debug((Object)("type=0x" + Integer.toHexString(type) + ", flag=0x" + Integer.toHexString(flag) + ", length=" + length + ", md5sum=" + AIMUtil.byteArrayToHexString(md5sum)));
        type = buffer.readShort();
        flag = buffer.readByte();
        length = buffer.readByte();
        md5sum = buffer.readBytes(length);
        LOG.debug((Object)("type=0x" + Integer.toHexString(type) + ", flag=0x" + Integer.toHexString(flag) + ", length=" + length + ", md5sum=" + AIMUtil.byteArrayToHexString(md5sum)));
        seven = buffer.readByte();
        if (seven != 7) {
            LOG.warn((Object)("Expected byte=0x7, but byte=0x" + Integer.toHexString(seven)));
        }
        type = buffer.readShort();
        flag = buffer.readByte();
        length = buffer.readByte();
        md5sum = buffer.readBytes(length);
        LOG.debug((Object)("type=0x" + Integer.toHexString(type) + ", flag=0x" + Integer.toHexString(flag) + ", length=" + length + ", md5sum=" + AIMUtil.byteArrayToHexString(md5sum)));
        frame.setHandled(false);
    }

    public void handleSNAC(AIMSession sess, SNACHandler handler, AIMFrame frame, SNAC snac, AIMInputStream buffer) throws IOException {
        if (snac.getSubtype() == 3) {
            this.hostOnline(sess, handler, frame, snac, buffer);
        } else if (snac.getSubtype() == 5) {
            this.redirect(sess, handler, frame, snac, buffer);
        } else if (snac.getSubtype() == 7) {
            this.rateResp(sess, handler, frame, snac, buffer);
        } else if (snac.getSubtype() == 10) {
            this.rateChange(sess, handler, frame, snac, buffer);
        } else if (snac.getSubtype() == 11) {
            this.serverPause(sess, handler, frame, snac, buffer);
        } else if (snac.getSubtype() == 13) {
            this.serverResume(sess, handler, frame, snac, buffer);
        } else if (snac.getSubtype() == 15) {
            this.selfInfo(sess, handler, frame, snac, buffer);
        } else if (snac.getSubtype() == 16) {
            this.evilNotify(sess, handler, frame, snac, buffer);
        } else if (snac.getSubtype() == 18) {
            this.migrate(sess, handler, frame, snac, buffer);
        } else if (snac.getSubtype() == 19) {
            this.motd(sess, handler, frame, snac, buffer);
        } else if (snac.getSubtype() == 24) {
            this.hostVersions(sess, handler, frame, snac, buffer);
        } else if (snac.getSubtype() == 31) {
            this.memRequest(sess, handler, frame, snac, buffer);
        } else if (snac.getSubtype() == 33) {
            this.extStatus(sess, handler, frame, snac, buffer);
        } else if (snac.getSubtype() == 35) {
            this.secureIM(sess, handler, frame, snac, buffer);
        } else {
            LOG.warn((Object)("Unrecognized SNAC(" + Integer.toHexString(snac.getFamily()) + ", " + Integer.toHexString(snac.getSubtype()) + ")"));
            frame.setHandled(false);
        }
    }
}

