/*
 * Decompiled with CFR 0.152.
 */
package org.walluck.oscar.handlers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.walluck.oscar.AIMConnection;
import org.walluck.oscar.AIMFrame;
import org.walluck.oscar.AIMInputStream;
import org.walluck.oscar.AIMOutputStream;
import org.walluck.oscar.AIMSession;
import org.walluck.oscar.FLAP;
import org.walluck.oscar.SNAC;
import org.walluck.oscar.Stat;
import org.walluck.oscar.TLVChain;
import org.walluck.oscar.handlers.SNACHandler;
import org.walluck.oscar.handlers.StatsListener;

public class StatsHandler
extends SNACHandler {
    private static final Logger LOG = Logger.getLogger((String)StatsHandler.class.getName());

    public StatsHandler() {
        this.setFamily(11);
        this.setVersion(1);
    }

    private static Stat findStat(ArrayList stats, int type, int id) {
        Stat stat = null;
        for (int i = 0; i < stats.size(); ++i) {
            stat = (Stat)stats.get(i);
            if (stat.getType() != type || stat.getId() != id) continue;
            return stat;
        }
        stat = new Stat(type, id);
        stats.add(stat);
        return stat;
    }

    public void reportEvent(AIMSession sess, AIMConnection conn, ArrayList stats, int type, int id) {
        Stat stat = StatsHandler.findStat(stats, type, id);
        stat.setCount(stat.getCount() + 1);
    }

    public void reportStats(AIMSession sess, AIMConnection conn, ArrayList stats, boolean wantResponse) throws IOException {
        AIMOutputStream buffer1 = new AIMOutputStream(stats.size() * 6);
        buffer1.writeStats(stats, 1);
        byte[] stats1 = buffer1.getBytes();
        AIMOutputStream buffer2 = new AIMOutputStream(stats.size() * 6);
        buffer2.writeStats(stats, 2);
        byte[] stats2 = buffer2.getBytes();
        if (stats1 == null && stats2 == null) {
            return;
        }
        FLAP flap = new FLAP(2);
        SNAC snac = new SNAC(11, 3, 0, null, false);
        TLVChain tlvchain = new TLVChain(3);
        if (stats1 != null) {
            tlvchain.addBytes(2, stats1);
        }
        if (stats2 != null) {
            tlvchain.addBytes(1, stats2);
        }
        if (wantResponse) {
            tlvchain.addNull(3);
            snac.setWantResponse(true);
        }
        AIMOutputStream buffer = new AIMOutputStream(tlvchain.length());
        buffer.writeTLVChain(tlvchain);
        conn.enqueueFrame(new AIMFrame(conn, 0, flap, snac, buffer));
    }

    private void reportInterval(AIMSession sess, SNACHandler handler, AIMFrame frame, SNAC snac, AIMInputStream buffer) throws IOException {
        short interval = buffer.readShort();
        Iterator i = frame.getConn().getListeners(11, 2);
        while (i.hasNext()) {
            ((StatsListener)i.next()).reportInterval(sess, frame, interval);
        }
    }

    private void reportAck(AIMSession sess, SNACHandler handler, AIMFrame frame, SNAC snac, AIMInputStream buffer) throws IOException {
        Iterator i = frame.getConn().getListeners(11, 4);
        while (i.hasNext()) {
            ((StatsListener)i.next()).reportAck(sess, frame, buffer);
        }
    }

    public void handleSNAC(AIMSession sess, SNACHandler handler, AIMFrame frame, SNAC snac, AIMInputStream buffer) throws IOException {
        if (snac.getSubtype() == 2) {
            this.reportInterval(sess, handler, frame, snac, buffer);
        } else if (snac.getSubtype() == 4) {
            this.reportAck(sess, handler, frame, snac, buffer);
        } else {
            LOG.warn((Object)("Unrecognized SNAC(" + Integer.toHexString(snac.getFamily()) + ", " + Integer.toHexString(snac.getSubtype()) + ")"));
            frame.setHandled(false);
        }
    }
}

