/*
 * Decompiled with CFR 0.152.
 */
package org.walluck.oscar.handlers.directim;

import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.walluck.oscar.AIMInputStream;
import org.walluck.oscar.AIMOutputStream;
import org.walluck.oscar.AIMSession;
import org.walluck.oscar.AIMUtil;
import org.walluck.oscar.channel.rendezvous.DirectIMRendezvous;
import org.walluck.oscar.handlers.ICBMHandler;
import org.walluck.oscar.handlers.directim.DirectIMHeader;
import org.walluck.oscar.handlers.directim.DirectIMListener;

public class DirectIM
extends Thread {
    private static final Logger LOG = Logger.getLogger((String)DirectIM.class.getName());
    private AIMSession sess;
    private byte[] cookie;
    private String screenname;
    private String host;
    private int port;
    private boolean wantResponse;
    private boolean listener = false;
    private boolean sender = false;
    private Socket socket;
    private ServerSocket ssocket;
    private volatile Thread thread = this;
    private boolean threadSuspended;
    private static final int SOCKET_TIMEOUT = 300000;

    public DirectIM(AIMSession sess, byte[] cookie, String screenname, String host, int port, boolean wantResponse) {
        this.sess = sess;
        this.cookie = cookie;
        this.screenname = screenname;
        this.host = host;
        this.port = port;
        LOG.debug((Object)("Connecting to/Connection from " + host + ":" + port));
        this.wantResponse = wantResponse;
    }

    public void setListener(boolean listener) {
        this.listener = listener;
    }

    public boolean isListener() {
        return this.listener;
    }

    public void setSender(boolean sender) {
        this.sender = sender;
    }

    public boolean isSender() {
        return this.sender;
    }

    public void end() {
        this.cleanup();
    }

    private void cleanup() {
        try {
            this.thread = null;
            if (this.socket != null) {
                this.socket.close();
                this.socket = null;
            }
        }
        catch (IOException ioe) {
            LOG.error((Object)"IOException", (Throwable)ioe);
        }
    }

    private void waitForConnection() {
        Iterator i;
        LOG.debug((Object)("Connecting to " + this.host + ":" + this.port));
        try {
            this.ssocket = new ServerSocket(0);
            this.ssocket.setSoTimeout(300000);
        }
        catch (IOException ioe) {
            LOG.error((Object)"IOException", (Throwable)ioe);
            i = this.sess.getListeners(254, 3);
            while (i.hasNext()) {
                ((DirectIMListener)i.next()).dimDisconnect(this.sess, null);
            }
            this.cleanup();
        }
        try {
            this.socket = this.ssocket.accept();
            this.socket.setSoTimeout(300000);
            Iterator i2 = this.sess.getListeners(254, 96);
            while (i2.hasNext()) {
                ((DirectIMListener)i2.next()).dimEstablished(this.sess);
            }
        }
        catch (InterruptedIOException iioe) {
            LOG.error((Object)"InterruptedIOException", (Throwable)iioe);
            i = this.sess.getListeners(254, 3);
            while (i.hasNext()) {
                ((DirectIMListener)i.next()).dimDisconnect(this.sess, null);
            }
            this.cleanup();
        }
        catch (IOException ioe) {
            LOG.error((Object)"IOException", (Throwable)ioe);
            i = this.sess.getListeners(254, 3);
            while (i.hasNext()) {
                ((DirectIMListener)i.next()).dimDisconnect(this.sess, null);
            }
            this.cleanup();
        }
        LOG.debug((Object)("Connection received from " + this.host + ":" + this.port));
    }

    private void initiateConnection() {
        LOG.debug((Object)("Connecting to " + this.host + ":" + this.port));
        try {
            this.socket = new Socket(this.host, this.port);
            this.socket.setSoTimeout(300000);
            Iterator i = this.sess.getListeners(254, 96);
            while (i.hasNext()) {
                ((DirectIMListener)i.next()).dimEstablished(this.sess);
            }
        }
        catch (UnknownHostException uhe) {
            LOG.error((Object)"UnknownHostException", (Throwable)uhe);
            if (!this.sender) {
                this.threadSuspended = true;
            } else {
                Iterator i = this.sess.getListeners(254, 3);
                while (i.hasNext()) {
                    ((DirectIMListener)i.next()).dimDisconnect(this.sess, null);
                }
                this.cleanup();
            }
        }
        catch (IOException ioe) {
            LOG.error((Object)"IOException", (Throwable)ioe);
            if (!this.sender) {
                this.threadSuspended = true;
            }
            Iterator i = this.sess.getListeners(254, 3);
            while (i.hasNext()) {
                ((DirectIMListener)i.next()).dimDisconnect(this.sess, null);
            }
            this.cleanup();
        }
        LOG.debug((Object)("Connected to " + this.host + ":" + this.port));
    }

    public void sendTyping(boolean typing) throws IOException {
        DirectIMHeader dh = new DirectIMHeader();
        dh.setType(1);
        dh.setUnknown(6);
        dh.setCookie(this.cookie);
        dh.setPayloadLength(0);
        dh.setFlags(typing ? 14 : 2);
        dh.setSN(this.screenname);
        dh.setPayload(null);
        this.sendDirectIMHeader(dh);
    }

    public void sendIM(int charset, int charSubset, String msg) throws IOException {
        if (msg == null) {
            throw new NullPointerException();
        }
        DirectIMHeader dh = new DirectIMHeader();
        dh.setType(1);
        dh.setUnknown(6);
        dh.setCookie(this.cookie);
        dh.setPayloadLength(msg.length());
        dh.setCharset(charset);
        dh.setCharSubset(charSubset);
        dh.setFlags(0);
        dh.setSN(this.screenname);
        dh.setPayload(msg.getBytes(AIMUtil.charsetAOLToJava(charset)));
        this.sendDirectIMHeader(dh);
    }

    private void sendRequest() {
        DirectIMRendezvous rv = new DirectIMRendezvous();
        rv.setCookie(this.cookie);
        rv.setPort(this.port);
        try {
            rv.setRequest();
            ICBMHandler im = (ICBMHandler)this.sess.getHandler(4);
            im.sendRendezvous(this.sess, this.screenname, rv);
        }
        catch (IOException ioe) {
            LOG.error((Object)"IOException", (Throwable)ioe);
        }
    }

    private void parse(AIMInputStream buffer) {
        DirectIMHeader dh = null;
        try {
            LOG.debug((Object)"Got Direct IM");
            dh = buffer.readDirectIMHeader();
            AIMOutputStream tmpbuffer = new AIMOutputStream(256);
            tmpbuffer.writeDirectIMHeader(dh);
            LOG.debug((Object)AIMUtil.hexdump(tmpbuffer.getBytes()));
            if (dh.getType() == 1) {
                if (dh.getFlags() == 14) {
                    LOG.debug((Object)(dh.getSN() + " has started typing"));
                    Iterator i = this.sess.getListeners(254, 4);
                    while (i.hasNext()) {
                        ((DirectIMListener)i.next()).typing(this.sess, dh, dh.getSN(), 1);
                    }
                } else if (dh.getFlags() == 2) {
                    LOG.debug((Object)(dh.getSN() + " has stopped typing"));
                    Iterator i = this.sess.getListeners(254, 4);
                    while (i.hasNext()) {
                        ((DirectIMListener)i.next()).typing(this.sess, dh, dh.getSN(), 0);
                    }
                } else if (dh.getFlags() == 0) {
                    LOG.warn((Object)"IM image: Don't read payload all at once");
                    if (dh.getPayloadLength() > 0) {
                        Iterator i = this.sess.getListeners(254, 48);
                        while (i.hasNext()) {
                            ((DirectIMListener)i.next()).image(this.sess, dh, dh.getSN(), dh.getPayload());
                        }
                    } else {
                        LOG.warn((Object)("Unknown Direct IM flags=0x" + Integer.toHexString(dh.getFlags())));
                        Iterator i = this.sess.getListeners(254, 64);
                        while (i.hasNext()) {
                            ((DirectIMListener)i.next()).unknownFlags(this.sess, dh, dh.getSN(), dh.getFlags(), dh.getPayload());
                        }
                    }
                }
            } else {
                LOG.warn((Object)("Unknown Direct IM type=0x" + Integer.toHexString(dh.getType())));
                Iterator i = this.sess.getListeners(254, 80);
                while (i.hasNext()) {
                    ((DirectIMListener)i.next()).unknownType(this.sess, dh, dh.getSN(), dh.getType(), dh.getPayload());
                }
            }
        }
        catch (EOFException oefe) {
            Iterator i = this.sess.getListeners(254, 3);
            while (i.hasNext()) {
                ((DirectIMListener)i.next()).dimDisconnect(this.sess, dh);
            }
            this.cleanup();
        }
        catch (IOException ioe) {
            LOG.error((Object)"IOException", (Throwable)ioe);
            Iterator i = this.sess.getListeners(254, 3);
            while (i.hasNext()) {
                ((DirectIMListener)i.next()).dimDisconnect(this.sess, dh);
            }
            this.cleanup();
        }
    }

    private void sendDirectIMHeader(DirectIMHeader dh) throws IOException {
        AIMOutputStream buffer2 = new AIMOutputStream(256);
        buffer2.writeDirectIMHeader(dh);
        byte[] packet = buffer2.getBytes();
        dh.setLength(packet.length);
        AIMOutputStream buffer = new AIMOutputStream(dh.getMagic().length() + 4 + packet.length);
        buffer.writeString(dh.getMagic());
        buffer.writeInt(dh.getLength());
        buffer.writeBytes(packet);
        LOG.debug((Object)AIMUtil.hexdump(buffer.getBytes()));
        this.socket.getOutputStream().write(buffer.getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Thread thisThread = Thread.currentThread();
        if (this.thread != thisThread) {
            return;
        }
        DirectIM directIM = this;
        synchronized (directIM) {
            while (this.threadSuspended && this.thread == thisThread) {
                try {
                    this.wait();
                }
                catch (InterruptedException ie) {
                    LOG.error((Object)"InterruptedException", (Throwable)ie);
                    this.thread = null;
                    Iterator i = this.sess.getListeners(254, 3);
                    while (i.hasNext()) {
                        ((DirectIMListener)i.next()).dimDisconnect(this.sess, null);
                    }
                }
            }
        }
        if (this.listener) {
            this.waitForConnection();
        } else {
            this.initiateConnection();
        }
        if (this.sender) {
            this.sendRequest();
        }
        try {
            AIMInputStream buffer = new AIMInputStream(this.socket.getInputStream());
            while (this.thread == thisThread) {
                this.parse(buffer);
            }
        }
        catch (IOException ioe) {
            LOG.error((Object)"IOException", (Throwable)ioe);
        }
    }
}

