/*
 * Decompiled with CFR 0.152.
 */
package org.walluck.oscar.handlers.news;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.walluck.oscar.News;
import org.walluck.oscar.handlers.news.NewsSection;

public class NewsHandler {
    private static final Logger LOG = Logger.getLogger((String)NewsHandler.class.getName());
    public static final String NEWS_URL = "http://headlines.aim.aol.com/aim/headlines.html";

    public ArrayList getNews() {
        ArrayList<NewsSection> newsPaper = new ArrayList<NewsSection>(20);
        try {
            String line;
            URL url = new URL(NEWS_URL);
            BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream()));
            NewsSection newsSection = null;
            News news = null;
            while ((line = br.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(line, "=");
                String key = st.nextToken();
                String value = st.nextToken();
                if (key.equals("Subsection")) {
                    if (newsSection != null) {
                        newsPaper.add(newsSection);
                        for (int i = 0; i < newsSection.size(); ++i) {
                            News newsLocal = (News)newsSection.get(i);
                            LOG.debug((Object)(newsSection.getName().toUpperCase() + ": " + newsLocal.getHeadline() + " <" + newsLocal.getURL() + ">"));
                        }
                    }
                    newsSection = new NewsSection();
                    newsSection.setName(value);
                    continue;
                }
                if (key.equals("Headline")) {
                    news = new News();
                    news.setHeadline(value);
                    continue;
                }
                if (key.equals("URL")) {
                    news.setURL(value);
                    newsSection.add(news);
                    continue;
                }
                if (key.equals("End")) break;
                if (key.equals("Section") || key.equals("Title")) continue;
                LOG.warn((Object)("Unknown news key=" + key + ", line=" + line));
            }
            br.close();
        }
        catch (MalformedURLException mue) {
            LOG.error((Object)"MalformedURLException", (Throwable)mue);
        }
        catch (IOException ioe) {
            LOG.error((Object)"IOException", (Throwable)ioe);
        }
        return newsPaper;
    }
}

