/*
 * Decompiled with CFR 0.152.
 */
package org.walluck.oscar.tools;

import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.walluck.oscar.AIMSession;
import org.walluck.oscar.MsgCookie;
import org.walluck.oscar.handlers.filetransfer.FileTransfer;
import org.walluck.oscar.tools.Tool;

public class FileTransferTool
extends Tool {
    private static final Logger LOG = Logger.getLogger((String)FileTransferTool.class.getName());

    public FileTransferTool() {
        this.setFamily(4096);
        this.setId(272);
        this.setVersion(1);
    }

    public void sendFile(String sn, String file) {
        try {
            byte[] ck = new byte[8];
            new MsgCookie(this.getToolData().getBosconn(), ck, 18, null);
            this.sendFile(sn, file, 1, null, ck);
        }
        catch (IOException ioe) {
            LOG.error((Object)"IOException", (Throwable)ioe);
        }
    }

    public void getFile(String sn) {
        try {
            MsgCookie cookie = new MsgCookie(this.getToolData().getBosconn(), null, 18, null);
            this.sendFile(sn, null, 18, null, cookie.getCookie());
        }
        catch (IOException ioe) {
            LOG.error((Object)"IOException", (Throwable)ioe);
        }
    }

    private long getDirSize(String dir) {
        return 0L;
    }

    private int getFileCount(String dir) {
        return 1;
    }

    private void sendFile(String screenname, String filename, int subtype, String message, byte[] cookie) throws IOException {
        int type = 0;
        int fileCount = 0;
        long dirSize = 0L;
        boolean send = false;
        boolean get = false;
        boolean list = false;
        if (subtype == 2 || subtype == 1) {
            send = true;
        } else if (subtype == 17) {
            get = true;
        } else if (subtype == 18) {
            list = true;
        } else {
            throw new IllegalArgumentException();
        }
        if (screenname == null) {
            throw new NullPointerException();
        }
        if (send) {
            if (filename == null) {
                throw new NullPointerException();
            }
            File file = new File(filename);
            if (!file.canRead()) {
                throw new IOException("Cannot read file " + filename);
            }
            if (file.isDirectory()) {
                fileCount = this.getFileCount(filename);
                dirSize = this.getDirSize(filename);
                type = 2;
            } else {
                fileCount = 1;
                dirSize = file.length();
                type = 1;
            }
        } else if (get) {
            if (filename == null) {
                throw new NullPointerException();
            }
            fileCount = 0;
            dirSize = 0L;
            type = 17;
        } else if (list) {
            fileCount = 0;
            dirSize = 0L;
            type = 18;
        }
        FileTransfer ft = new FileTransfer(this.getSession());
        if (send) {
            ft.sendFileRequest(cookie, screenname, type, fileCount, (int)dirSize, filename, message);
        } else {
            ft.getFileRequest(cookie, screenname);
        }
    }

    public void shutdown(AIMSession sess) {
    }

    public void bosConnectionAvailable() {
    }
}

