/*
 * Decompiled with CFR 0.152.
 */
package org.walluck.oscar.tools;

import java.io.IOException;
import java.util.List;
import org.apache.log4j.Logger;
import org.walluck.oscar.AIMConnection;
import org.walluck.oscar.AIMFrame;
import org.walluck.oscar.AIMSession;
import org.walluck.oscar.client.Buddy;
import org.walluck.oscar.handlers.ICQHandler;
import org.walluck.oscar.handlers.SSIHandler;
import org.walluck.oscar.handlers.SSIListener;
import org.walluck.oscar.handlers.ServiceHandler;
import org.walluck.oscar.tools.BuddyListTool;
import org.walluck.oscar.tools.LocateTool;
import org.walluck.oscar.tools.Tool;

public class SSITool
extends Tool
implements SSIListener {
    private static final Logger LOG = Logger.getLogger((String)SSITool.class.getName());

    public SSITool() {
        this.setFamily(19);
        this.setId(272);
        this.setVersion(1849);
    }

    public void addPermit(AIMSession sess, String who) throws IOException {
        SSIHandler ssi = (SSIHandler)sess.getHandler(19);
        if (sess.getSSI().getReceivedData()) {
            ssi.addPermit(sess, who);
        }
    }

    public void addDeny(AIMSession sess, String who) throws IOException {
        SSIHandler ssi = (SSIHandler)sess.getHandler(19);
        if (sess.getSSI().getReceivedData()) {
            ssi.addDeny(sess, who);
        }
    }

    public void remPermit(AIMSession sess, String who) throws IOException {
        SSIHandler ssi = (SSIHandler)sess.getHandler(19);
        if (sess.getSSI().getReceivedData()) {
            ssi.delPermit(sess, who);
        }
    }

    public void remDeny(AIMSession sess, String who) throws IOException {
        SSIHandler ssi = (SSIHandler)sess.getHandler(19);
        if (sess.getSSI().getReceivedData()) {
            ssi.delDeny(sess, who);
        }
    }

    public void shutdown(AIMSession sess) {
    }

    public void bosConnectionAvailable() {
        AIMConnection bosconn = this.getToolData().getBosconn();
        bosconn.registerListener(19, 3, this);
        bosconn.registerListener(19, 6, this);
        bosconn.registerListener(19, 15, this);
    }

    public void parseAdd(AIMSession sess, AIMFrame frame) {
    }

    public void parseMod(AIMSession sess, AIMFrame frame) {
    }

    public void parseDel(AIMSession sess, AIMFrame frame) {
    }

    public void receiveAuthGrant(AIMSession sess, AIMFrame frame, String sn, String msg) {
    }

    public void receiveAuthRequest(AIMSession sess, AIMFrame frame, String sn, String msg) {
    }

    public void receiveAuthReply(AIMSession sess, AIMFrame frame, String sn, byte reply, String msg) {
    }

    public void parseRights(AIMSession sess, AIMFrame frame, short[] maxitems) {
        LOG.debug((Object)"ssi rights: ");
        for (int i = 0; i < maxitems.length; ++i) {
            LOG.debug((Object)("max type 0x" + Integer.toHexString(i) + "=" + maxitems[i]));
        }
        if (maxitems.length >= 0) {
            LOG.debug((Object)("maxbuddies=" + maxitems[0]));
        }
        if (maxitems.length >= 1) {
            LOG.debug((Object)("maxgroups=" + maxitems[1]));
        }
        if (maxitems.length >= 2) {
            LOG.debug((Object)("maxpermits=" + maxitems[2]));
        }
        if (maxitems.length >= 3) {
            LOG.debug((Object)("maxdenies=" + maxitems[3]));
        }
    }

    public void parseData(AIMSession sess, AIMFrame frame, int fmtVer, int numitems, List list, int timestamp) {
        LOG.debug((Object)"ssi: syncing local list and server list");
        try {
            SSIHandler ssi = (SSIHandler)sess.getHandler(19);
            ssi.cleanList(sess);
            Buddy[] buddies = null;
            if (list != null && !list.isEmpty()) {
                BuddyListTool blt = (BuddyListTool)this.getSession().getTool(3);
                buddies = blt.ssiSetBuddyList(list);
            }
            String infoString = "Visit the daim website at <a href=\"http://daim.dev.java.net/\">http://daim.dev.java.net/</a>.";
            LocateTool lt = (LocateTool)this.getSession().getTool(2);
            lt.setInfo("utf-8", infoString);
            ServiceHandler service = (ServiceHandler)sess.getHandler(1);
            service.setAvailableMsg(sess, "I'm using daim! Find out more at http://daim.dev.java.net/", null);
            service.setIdle(sess, 0);
            service.setSecureIM(sess);
            if (sess.isICQ()) {
                ICQHandler icq = (ICQHandler)sess.getHandler(21);
                icq.reqOfflineMsgs(sess);
                icq.metaSomething(sess);
                icq.reqXML(sess);
                if (buddies != null) {
                    int n = buddies.length;
                    for (int i = 0; i < n; ++i) {
                        icq.metaReqBasicInfo(sess, Integer.parseInt(buddies[i].getName()));
                    }
                } else {
                    LOG.debug((Object)"No buddylist provided!");
                }
            }
            ssi.enable(sess);
        }
        catch (IOException ioe) {
            LOG.error((Object)"IOException", (Throwable)ioe);
        }
    }

    public void parseAck(AIMSession sess, AIMFrame frame) {
    }

    public void parseDataUnchanged(AIMSession sess, AIMFrame frame) {
        this.parseData(sess, frame, 0, 0, null, 0);
    }

    public void parseAuthReq(AIMSession sess, AIMFrame frame, String sn, String reason) {
    }

    public void receiveAuthGranted(AIMSession sess, AIMFrame frame, String sn, byte reply, String msg) {
        LOG.debug((Object)("User " + sn + " has granted you authorization"));
    }

    public void receiveAdded(AIMSession sess, AIMFrame frame, String sn) {
        LOG.debug((Object)(sn + " has added you to their contact list"));
    }
}

