/*
 * Decompiled with CFR 0.152.
 */
package com.levelonelabs.aim;

import com.levelonelabs.aim.XMLizable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AIMBuddy
implements XMLizable {
    String name;
    transient boolean online;
    transient int warningAmount = 0;
    boolean banned;
    ArrayList messages = new ArrayList();
    HashMap roles = new HashMap();
    HashMap preferences = new HashMap();
    String group;

    public AIMBuddy(String name) {
        this(name, "TOC");
    }

    public AIMBuddy(String name, String group) {
        this.name = name;
        this.setGroup(group);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOnline(boolean online) {
        this.online = online;
    }

    public void setPreference(String pref, String val) {
        this.preferences.put(pref, val);
    }

    public String getName() {
        return this.name;
    }

    public boolean isOnline() {
        return this.online;
    }

    public String getPreference(String pref) {
        return (String)this.preferences.get(pref);
    }

    public HashMap getPreferences() {
        return this.preferences;
    }

    public void addRole(String role) {
        this.roles.put(role, role);
    }

    public ArrayList getMessages() {
        return this.messages;
    }

    public void addMessage(String message) {
        this.messages.add(message);
    }

    public void clearMessages() {
        this.messages.clear();
    }

    public boolean hasMessages() {
        return !this.messages.isEmpty();
    }

    public boolean hasRole(String role) {
        return this.roles.containsKey(role);
    }

    public boolean isBanned() {
        return this.banned;
    }

    public void setBanned(boolean banned) {
        this.banned = banned;
    }

    public void readState(Element fullStateElement) {
        int i;
        String group = fullStateElement.getAttribute("group");
        if (group == null || group.trim().equals("")) {
            group = "TOC";
        }
        this.setGroup(group);
        String ban = fullStateElement.getAttribute("isBanned");
        if (ban.equalsIgnoreCase("true")) {
            this.setBanned(true);
        } else {
            this.setBanned(false);
        }
        this.roles = new HashMap();
        NodeList list = fullStateElement.getElementsByTagName("role");
        for (i = 0; i < list.getLength(); ++i) {
            Element roleElem = (Element)list.item(i);
            String role = roleElem.getAttribute("name");
            this.addRole(role);
        }
        this.messages = new ArrayList();
        list = fullStateElement.getElementsByTagName("message");
        block1: for (i = 0; i < list.getLength(); ++i) {
            Element messElem = (Element)list.item(i);
            NodeList cdatas = messElem.getChildNodes();
            for (int j = 0; j < cdatas.getLength(); ++j) {
                Node node = cdatas.item(j);
                if (node.getNodeType() != 4) continue;
                String message = node.getNodeValue();
                this.addMessage(message);
                continue block1;
            }
        }
        this.preferences = new HashMap();
        list = fullStateElement.getElementsByTagName("preference");
        for (i = 0; i < list.getLength(); ++i) {
            Element prefElem = (Element)list.item(i);
            String pref = prefElem.getAttribute("name");
            String val = prefElem.getAttribute("value");
            this.setPreference(pref, val);
        }
    }

    public void writeState(Element emptyStateElement) {
        Document doc = emptyStateElement.getOwnerDocument();
        emptyStateElement.setAttribute("name", this.getName());
        emptyStateElement.setAttribute("group", this.getGroup());
        emptyStateElement.setAttribute("isBanned", Boolean.toString(this.isBanned()));
        Iterator roleit = this.roles.keySet().iterator();
        while (roleit.hasNext()) {
            String role = (String)roleit.next();
            Element roleElem = doc.createElement("role");
            roleElem.setAttribute("name", role);
            emptyStateElement.appendChild(roleElem);
        }
        Iterator prefs = this.preferences.keySet().iterator();
        while (prefs.hasNext()) {
            String pref = (String)prefs.next();
            Element prefElem = doc.createElement("preference");
            prefElem.setAttribute("name", pref);
            prefElem.setAttribute("value", (String)this.preferences.get(pref));
            emptyStateElement.appendChild(prefElem);
        }
        for (int i = 0; i < this.messages.size(); ++i) {
            String message = (String)this.messages.get(i);
            Element messElem = doc.createElement("message");
            CDATASection data = doc.createCDATASection(message);
            messElem.appendChild(data);
            emptyStateElement.appendChild(messElem);
        }
    }

    public int getWarningAmount() {
        return this.warningAmount;
    }

    public void setWarningAmount(int amount) {
        this.warningAmount = amount;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getGroup() {
        return this.group;
    }
}

