/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.integration.generic;

import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.zeroturnaround.javarebel.Resource;

public class RestrictedResource
implements Resource {
    private final AccessControlContext acc;
    private final Resource target;

    public static Resource newInstance(AccessControlContext acc, Resource target) {
        if (acc == null || target == null) {
            return null;
        }
        return new RestrictedResource(acc, target);
    }

    private RestrictedResource(AccessControlContext acc, Resource target) {
        this.acc = acc;
        this.target = target;
    }

    public Resource getTarget() {
        return this.target;
    }

    public byte[] getBytes() {
        return (byte[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return RestrictedResource.this.target.getBytes();
            }
        }, this.acc);
    }

    public long lastModified() {
        Long obj = (Long)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new Long(RestrictedResource.this.target.lastModified());
            }
        }, this.acc);
        return obj;
    }

    public URL toURL() {
        return (URL)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return RestrictedResource.this.target.toURL();
            }
        }, this.acc);
    }

    public String toString() {
        return "Privileged(" + AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return RestrictedResource.this.target.toString();
            }
        }, this.acc) + ")";
    }
}

