/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.integration.monitor;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.zeroturnaround.javarebel.Logger;
import org.zeroturnaround.javarebel.LoggerFactory;
import org.zeroturnaround.javarebel.integration.monitor.MonitoredResource;
import org.zeroturnaround.javarebel.integration.util.ResourceUtil;
import org.zeroturnaround.javarebel.support.ResourceUtils;

public class MonitoredResourceManager {
    private static final Logger log = LoggerFactory.getInstance();
    private static final ThreadLocal builderLocal = new ThreadLocal();
    private static final Map managersPerBuilder = Collections.synchronizedMap(new HashMap());
    private static final long MODIFIED_CHECK_MIN_INTERVAL = 1000L;
    private final Map monitoredConfs = Collections.synchronizedMap(new HashMap());
    private long lastCheck = System.currentTimeMillis();

    public static void beginConf(Object builder) {
        builderLocal.set(builder);
    }

    public static void endConf() {
        builderLocal.set(null);
    }

    public static Object getConf() {
        return builderLocal.get();
    }

    private static synchronized MonitoredResourceManager get(Object builder) {
        return (MonitoredResourceManager)managersPerBuilder.get(builder);
    }

    private static synchronized MonitoredResourceManager getOrCreate(Object builder) {
        MonitoredResourceManager manager = (MonitoredResourceManager)managersPerBuilder.get(builder);
        if (manager == null) {
            manager = new MonitoredResourceManager();
            managersPerBuilder.put(builder, manager);
        }
        return manager;
    }

    public static Set modified(Object builder) {
        MonitoredResourceManager manager = MonitoredResourceManager.get(builder);
        return manager == null ? Collections.EMPTY_SET : manager.modified();
    }

    private synchronized Set modified() {
        if (System.currentTimeMillis() < this.lastCheck + 1000L) {
            return Collections.EMPTY_SET;
        }
        HashSet<String> result = new HashSet<String>();
        Iterator it = this.monitoredConfs.values().iterator();
        while (it.hasNext()) {
            MonitoredResource mr = (MonitoredResource)it.next();
            if (!mr.modified()) continue;
            result.add(mr.toString());
        }
        this.lastCheck = System.currentTimeMillis();
        return result;
    }

    public static void registerConf(Class klass) {
        MonitoredResourceManager.registerConf(klass, MonitoredResourceManager.getConf());
    }

    public static void registerConf(ClassLoader classLoader, String className) {
        MonitoredResourceManager.registerConf(classLoader, className, MonitoredResourceManager.getConf());
    }

    public static void registerConf(URL url) {
        MonitoredResourceManager.registerConf(url, MonitoredResourceManager.getConf());
    }

    public static void registerConf(String url) {
        MonitoredResourceManager.registerConf(url, MonitoredResourceManager.getConf());
    }

    public static void registerConf(Class klass, Object builder) {
        MonitoredResourceManager.registerConf(klass.getClassLoader(), klass.getName(), builder);
    }

    public static void registerConf(ClassLoader classLoader, String className, Object builder) {
        if (classLoader != null) {
            MonitoredResourceManager.registerConf(classLoader.getResource(className.replace('.', '/') + ".class"), builder);
        }
    }

    public static void registerConf(String url, Object builder) {
        URL u;
        if (url == null) {
            return;
        }
        try {
            u = new URL(url);
        }
        catch (MalformedURLException e) {
            log.echoPrefix("Warning! Could not monitor configuration in '" + url + "'.");
            log.error((Throwable)e);
            return;
        }
        MonitoredResourceManager.registerConf(u, builder);
    }

    public static void registerConf(URL url, Object builder) {
        if (url == null) {
            return;
        }
        if (builder == null) {
            log.echoPrefix("Warning! Could not monitor configuration in '" + url + "'.");
            log.error((Throwable)new IllegalArgumentException("No builder provided"));
            return;
        }
        MonitoredResourceManager.getOrCreate(builder).register(url);
    }

    private synchronized void register(URL url) {
        if (!this.monitoredConfs.containsKey(url)) {
            if (ResourceUtils.isFileURL((URL)url)) {
                File file = ResourceUtils.getFile((URL)url);
                log.echoPrefix("Monitoring configuration in '" + file + "'.");
            } else {
                log.echoPrefix("Monitoring configuration in '" + url + "'.");
            }
        }
        this.monitoredConfs.put(url, new MonitoredResource(ResourceUtil.asResource(url)));
    }
}

