/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.integration.support;

import java.io.InputStream;
import java.net.URL;
import org.zeroturnaround.bundled.javassist.ByteArrayClassPath;
import org.zeroturnaround.bundled.javassist.ClassPath;
import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.bundled.javassist.NotFoundException;
import org.zeroturnaround.javarebel.AgentIntegration;
import org.zeroturnaround.javarebel.AgentIntegrationFactory;
import org.zeroturnaround.javarebel.ClassBytecodeProcessor;
import org.zeroturnaround.javarebel.Logger;
import org.zeroturnaround.javarebel.LoggerFactory;
import org.zeroturnaround.javarebel.integration.support.PublicAgentClassPath;
import org.zeroturnaround.javarebel.integration.support.RestrictedClassClassPath;
import org.zeroturnaround.javarebel.integration.support.RestrictedLoaderClassPath;

public abstract class JavassistClassBytecodeProcessor
implements ClassBytecodeProcessor {
    private static final AgentIntegration agent = AgentIntegrationFactory.getInstance();
    static final Logger log = LoggerFactory.getInstance();

    public final byte[] process(ClassLoader cl, String classname, byte[] bytecode) {
        try {
            classname = classname.replace('/', '.');
            ClassPool cp = new ClassPool();
            if (log.isTraceEnabled()) {
                cp.appendClassPath((ClassPath)new RebelClassPath());
            }
            cp.appendClassPath((ClassPath)new ByteArrayClassPath(classname, bytecode));
            if (agent.arePublicClassBytesCached()) {
                cp.appendClassPath(PublicAgentClassPath.getInstance());
            }
            cp.appendClassPath((ClassPath)new RestrictedClassClassPath());
            cp.appendClassPath((ClassPath)new RestrictedLoaderClassPath(cl));
            CtClass cc = cp.get(classname);
            cc.defrost();
            this.process(cp, cl, cc);
            return cc.toBytecode();
        }
        catch (Throwable e) {
            log.echoPrefix("Class '" + classname + "' could not be processed:");
            log.errorEcho(e);
            return bytecode;
        }
    }

    public abstract void process(ClassPool var1, ClassLoader var2, CtClass var3) throws Exception;

    private static class RebelClassPath
    implements ClassPath {
        private RebelClassPath() {
        }

        public URL find(String classname) {
            log.trace("Searching for Javassist resource " + classname);
            return null;
        }

        public InputStream openClassfile(String classname) throws NotFoundException {
            log.trace("Searching for Javassist class " + classname);
            throw new NotFoundException(classname);
        }

        public void close() {
        }
    }
}

