/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.integration.support;

import java.io.InputStream;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.zeroturnaround.bundled.javassist.ClassPath;

public class RestrictedClassClassPath
implements ClassPath {
    private AccessControlContext acc;
    private Class thisClass;

    public RestrictedClassClassPath(Class c) {
        this.thisClass = c;
        this.acc = AccessController.getContext();
    }

    RestrictedClassClassPath() {
        this(Object.class);
    }

    public InputStream openClassfile(String classname) {
        final String jarname = "/" + classname.replace('.', '/') + ".class";
        return (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return RestrictedClassClassPath.this.thisClass.getResourceAsStream(jarname);
            }
        }, this.acc);
    }

    public URL find(String classname) {
        final String jarname = "/" + classname.replace('.', '/') + ".class";
        return (URL)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return RestrictedClassClassPath.this.thisClass.getResource(jarname);
            }
        }, this.acc);
    }

    public void close() {
        this.thisClass = null;
        this.acc = null;
    }
}

