/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.integration.support;

import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.zeroturnaround.bundled.javassist.ClassPath;

public class RestrictedLoaderClassPath
implements ClassPath {
    private AccessControlContext acc;
    private WeakReference clref;

    public RestrictedLoaderClassPath(ClassLoader cl) {
        this.clref = new WeakReference<ClassLoader>(cl);
        this.acc = AccessController.getContext();
    }

    public String toString() {
        Object cl = null;
        if (this.clref != null) {
            cl = this.clref.get();
        }
        return cl == null ? "<null>" : cl.toString();
    }

    public InputStream openClassfile(String classname) {
        final String cname = classname.replace('.', '/') + ".class";
        final ClassLoader cl = (ClassLoader)this.clref.get();
        if (cl == null) {
            return null;
        }
        return (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return cl.getResourceAsStream(cname);
            }
        }, this.acc);
    }

    public URL find(String classname) {
        final String cname = classname.replace('.', '/') + ".class";
        final ClassLoader cl = (ClassLoader)this.clref.get();
        if (cl == null) {
            return null;
        }
        return (URL)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return cl.getResource(cname);
            }
        }, this.acc);
    }

    public void close() {
        this.clref = null;
        this.acc = null;
    }
}

