/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.integration.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.zeroturnaround.javarebel.integration.util.WeakUtil;

public abstract class ClassReflectionUtil {
    public static Set getClassHierarchy(Class klass) {
        return ClassReflectionUtil.getClassHierarchies(Collections.singleton(klass));
    }

    public static Set getClassHierarchies(Class[] classes) {
        return ClassReflectionUtil.getClassHierarchies(Arrays.asList(classes));
    }

    public static Set getClassHierarchies(Collection classes) {
        LinkedList stack = new LinkedList(classes);
        HashSet<Class> result = new HashSet<Class>();
        while (!stack.isEmpty()) {
            Class<?>[] interfaces;
            Class klass = (Class)stack.remove(0);
            if (klass == null) continue;
            result.add(klass);
            Class superClass = klass.getSuperclass();
            if (superClass != null && !result.contains(superClass)) {
                stack.add(superClass);
            }
            if ((interfaces = klass.getInterfaces()) == null) continue;
            for (int i = 0; i < interfaces.length; ++i) {
                Class<?> iface = interfaces[i];
                if (result.contains(iface)) continue;
                stack.add(iface);
            }
        }
        return result;
    }

    public static Set getInterfaces(Collection classes) {
        if (classes == null) {
            return null;
        }
        HashSet result = new HashSet();
        Iterator it = classes.iterator();
        while (it.hasNext()) {
            Class klass = (Class)it.next();
            if (klass == null) continue;
            result.addAll(Arrays.asList(klass.getInterfaces()));
        }
        return result;
    }

    public static List asWeakReferences(Collection classes) {
        return WeakUtil.createWeakReferenceList(classes);
    }
}

