/*
 * Decompiled with CFR 0.152.
 */
package jode.swingui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreePath;
import jode.bytecode.ClassInfo;
import jode.decompiler.Decompiler;
import jode.decompiler.ProgressListener;
import jode.swingui.HierarchyTreeModel;
import jode.swingui.Main;
import jode.swingui.PackagesTreeModel;

public class Main
implements ActionListener,
Runnable,
TreeSelectionListener {
    Decompiler decompiler = new Decompiler();
    JFrame frame;
    JTree classTree;
    JPanel statusLine;
    PackagesTreeModel packModel;
    HierarchyTreeModel hierModel;
    JTextArea sourcecodeArea;
    JTextArea errorArea;
    Thread decompileThread;
    String currentClassPath;
    String lastClassName;
    JProgressBar progressBar;
    boolean hierarchyTree;

    public void show() {
        this.frame.pack();
        this.frame.show();
    }

    public void fillContentPane(Container container) {
        this.statusLine = new JPanel();
        this.hierarchyTree = false;
        this.packModel = new PackagesTreeModel(this);
        this.hierModel = null;
        Font font = new Font("monospaced", 0, 12);
        this.classTree = new JTree(this.packModel);
        this.classTree.setRootVisible(false);
        DefaultTreeSelectionModel defaultTreeSelectionModel = new DefaultTreeSelectionModel();
        defaultTreeSelectionModel.setSelectionMode(1);
        this.classTree.setSelectionModel(defaultTreeSelectionModel);
        this.classTree.addTreeSelectionListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.classTree);
        this.sourcecodeArea = new JTextArea(20, 80);
        this.sourcecodeArea.setEditable(false);
        this.sourcecodeArea.setFont(font);
        JScrollPane jScrollPane2 = new JScrollPane(this.sourcecodeArea);
        this.errorArea = new JTextArea(3, 80);
        this.errorArea.setEditable(false);
        this.errorArea.setFont(font);
        JScrollPane jScrollPane3 = new JScrollPane(this.errorArea);
        JSplitPane jSplitPane = new JSplitPane(0, jScrollPane2, jScrollPane3);
        JSplitPane jSplitPane2 = new JSplitPane(1, jScrollPane, jSplitPane);
        container.setLayout(new BorderLayout());
        container.add((Component)jSplitPane2, "Center");
        container.add((Component)this.statusLine, "South");
        this.progressBar = new JProgressBar();
        this.statusLine.add(this.progressBar);
        jSplitPane.setDividerLocation(300);
        jSplitPane.setDividerSize(4);
        jSplitPane2.setDividerLocation(200);
        jSplitPane2.setDividerSize(4);
        Main main = this;
        if (main == null) {
            throw null;
        }
        this.decompiler.setErr(new PrintWriter((Writer)new BufferedWriter(main.new AreaWriter(this.errorArea)), true));
    }

    public synchronized void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (this.decompileThread != null) {
            return;
        }
        TreePath treePath = treeSelectionEvent.getNewLeadSelectionPath();
        if (treePath == null) {
            return;
        }
        Object object = treePath.getLastPathComponent();
        if (object != null) {
            if (this.hierarchyTree && this.hierModel.isValidClass(object)) {
                this.lastClassName = this.hierModel.getFullName(object);
            } else if (!this.hierarchyTree && this.packModel.isValidClass(object)) {
                this.lastClassName = this.packModel.getFullName(object);
            } else {
                return;
            }
            this.startDecompiler();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.classTree) {
            this.startDecompiler();
        }
    }

    public synchronized void startDecompiler() {
        if (this.decompileThread == null) {
            this.decompileThread = new Thread(this);
            this.decompileThread.setPriority(1);
            this.progressBar.setMinimum(0);
            this.progressBar.setMaximum(1000);
            this.progressBar.setString("decompiling");
            this.progressBar.setStringPainted(true);
            this.decompileThread.start();
        }
    }

    /*
     * Loose catch block
     */
    public void run() {
        this.errorArea.setText("");
        Main main = this;
        if (main == null) {
            throw null;
        }
        BufferedWriter bufferedWriter = new BufferedWriter(main.new AreaWriter(this.sourcecodeArea), 1024);
        Main main2 = this;
        if (main2 == null) {
            throw null;
        }
        ProgressListener progressListener = new ProgressListener(main2){
            private final /* synthetic */ Main this$0;

            public void updateProgress(double d, String string) {
                2 v0 = this;
                if (v0 == null) {
                    throw null;
                }
                SwingUtilities.invokeLater(new Runnable(v0, d, string){
                    private final /* synthetic */ 2 this$0;
                    private final /* synthetic */ double val$progress;
                    private final /* synthetic */ String val$detail;
                    private final /* synthetic */ Main this$1;

                    public void run() {
                        this.this$1.progressBar.setValue((int)(1000.0 * this.val$progress));
                        this.this$1.progressBar.setString(this.val$detail);
                    }
                    {
                        this.val$progress = d;
                        this.val$detail = string;
                        this.this$0 = var1_1;
                        this.this$1 = 2.access$0(this.this$0);
                        this.constructor$0(var1_1);
                    }

                    private final void constructor$0(2 var1_1) {
                    }
                });
            }

            static /* synthetic */ Main access$0(2 var0) {
                return var0.this$0;
            }
            {
                this.this$0 = main;
                this.constructor$0(main);
            }

            private final void constructor$0(Main main) {
            }
        };
        this.decompiler.decompile(this.lastClassName, bufferedWriter, progressListener);
        Object var4_3 = null;
        try {
            ((Writer)bufferedWriter).close();
        }
        catch (IOException object) {
            // empty catch block
        }
        object = this;
        synchronized (object) {
            this.decompileThread = null;
        }
        {
            catch (Throwable throwable) {
                try {
                    bufferedWriter.write("\nException while decompiling:");
                    PrintWriter printWriter = new PrintWriter(bufferedWriter);
                    throwable.printStackTrace(printWriter);
                    printWriter.flush();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                Object var4_4 = null;
                try {
                    ((Writer)bufferedWriter).close();
                }
                catch (IOException object) {
                    // empty catch block
                }
                object = this;
                synchronized (object) {
                    this.decompileThread = null;
                }
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            try {
                ((Writer)bufferedWriter).close();
            }
            catch (IOException object) {
                // empty catch block
            }
            object = this;
            synchronized (object) {
                this.decompileThread = null;
            }
            throw throwable;
        }
        Main main3 = this;
        if (main3 == null) {
            throw null;
        }
        SwingUtilities.invokeLater(new Runnable(main3){
            private final /* synthetic */ Main this$0;

            public void run() {
                this.this$0.progressBar.setValue(0);
                this.this$0.progressBar.setString("");
            }
            {
                this.this$0 = main;
                this.constructor$0(main);
            }

            private final void constructor$0(Main main) {
            }
        });
    }

    public void addMenu(JFrame jFrame) {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        JMenuItem jMenuItem = new JMenuItem("Garbage collect");
        Main main = this;
        if (main == null) {
            throw null;
        }
        jMenuItem.addActionListener(new ActionListener(main){
            private final /* synthetic */ Main this$0;

            public void actionPerformed(ActionEvent actionEvent) {
                System.gc();
                System.runFinalization();
            }
            {
                this.this$0 = main;
                this.constructor$0(main);
            }

            private final void constructor$0(Main main) {
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Exit");
        Main main2 = this;
        if (main2 == null) {
            throw null;
        }
        jMenuItem.addActionListener(new ActionListener(main2){
            private final /* synthetic */ Main this$0;

            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
            {
                this.this$0 = main;
                this.constructor$0(main);
            }

            private final void constructor$0(Main main) {
            }
        });
        jMenu.add(jMenuItem);
        jMenuBar.add(jMenu);
        jMenu = new JMenu("Options");
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem("Class hierarchy", this.hierarchyTree);
        Main main3 = this;
        if (main3 == null) {
            throw null;
        }
        jCheckBoxMenuItem.addActionListener(new ActionListener(main3, jCheckBoxMenuItem){
            private final /* synthetic */ Main this$0;
            private final /* synthetic */ JCheckBoxMenuItem val$hierItem;

            public void actionPerformed(ActionEvent actionEvent) {
                this.this$0.hierarchyTree = this.val$hierItem.isSelected();
                if (this.this$0.hierarchyTree && this.this$0.hierModel == null) {
                    this.this$0.hierModel = new HierarchyTreeModel(this.this$0, this.this$0.progressBar);
                    this.this$0.reselect();
                }
                this.this$0.classTree.setModel(this.this$0.hierarchyTree ? this.this$0.hierModel : this.this$0.packModel);
                if (this.this$0.lastClassName != null) {
                    TreePath treePath = this.this$0.hierarchyTree ? this.this$0.hierModel.getPath(this.this$0.lastClassName) : this.this$0.packModel.getPath(this.this$0.lastClassName);
                    this.this$0.classTree.setSelectionPath(treePath);
                    this.this$0.classTree.scrollPathToVisible(treePath);
                }
            }
            {
                this.val$hierItem = jCheckBoxMenuItem;
                this.this$0 = main;
                this.constructor$0(main);
            }

            private final void constructor$0(Main main) {
            }
        });
        jMenu.add(jCheckBoxMenuItem);
        jMenu.add(new JSeparator());
        jMenuItem = new JMenuItem("Set classpath...");
        Main main4 = this;
        if (main4 == null) {
            throw null;
        }
        jMenuItem.addActionListener(new ActionListener(main4){
            private final /* synthetic */ Main this$0;

            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)JOptionPane.showInputDialog(null, "New classpath:", null, 3, null, null, this.this$0.currentClassPath);
                if (string != null && !string.equals(this.this$0.currentClassPath)) {
                    this.this$0.setClassPath(string);
                }
            }
            {
                this.this$0 = main;
                this.constructor$0(main);
            }

            private final void constructor$0(Main main) {
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Reload classpath");
        Main main5 = this;
        if (main5 == null) {
            throw null;
        }
        jMenuItem.addActionListener(new ActionListener(main5){
            private final /* synthetic */ Main this$0;

            public void actionPerformed(ActionEvent actionEvent) {
                this.this$0.setClassPath(this.this$0.currentClassPath);
            }
            {
                this.this$0 = main;
                this.constructor$0(main);
            }

            private final void constructor$0(Main main) {
            }
        });
        jMenu.add(jMenuItem);
        jMenuBar.add(jMenu);
        jFrame.setJMenuBar(jMenuBar);
    }

    public void setClassPath(String string) {
        if (string == null || string.length() == 0) {
            string = ".";
        }
        this.currentClassPath = string;
        ClassInfo.setClassPath(string);
        this.decompiler.setClassPath(string);
        if (this.classTree != null) {
            this.classTree.clearSelection();
        }
        if (this.packModel != null) {
            this.packModel.rebuild();
        }
        if (this.hierModel != null && this.hierarchyTree) {
            this.hierModel.rebuild();
        } else {
            this.hierModel = null;
        }
    }

    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        this.reselect();
    }

    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        this.reselect();
    }

    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        this.reselect();
    }

    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        this.reselect();
    }

    public void reselect() {
        if (this.lastClassName != null) {
            TreePath treePath;
            TreePath treePath2 = treePath = this.hierarchyTree ? this.hierModel.getPath(this.lastClassName) : this.packModel.getPath(this.lastClassName);
            if (treePath != null) {
                this.classTree.setSelectionPath(treePath);
                this.classTree.scrollPathToVisible(treePath);
            }
        }
    }

    public static void usage() {
        System.err.println("Usage: java jode.swingui.Main [CLASSPATH]");
        System.err.println("The directories in CLASSPATH should be separated by ','.");
        System.err.println("If no CLASSPATH is given the virtual machine classpath is used.");
    }

    public static void main(String[] stringArray) {
        int n;
        String string = System.getProperty("java.class.path", "");
        string = string.replace(File.pathSeparatorChar, ',');
        String string2 = System.getProperty("sun.boot.class.path");
        if (string2 != null) {
            string = string + ',' + string2.replace(File.pathSeparatorChar, ',');
        }
        if ((n = 0) < stringArray.length) {
            if (stringArray[n].equals("--classpath") || stringArray[n].equals("--cp") || stringArray[n].equals("-c")) {
                string = stringArray[++n];
            } else {
                if (stringArray[n].startsWith("-")) {
                    if (!stringArray[n].equals("--help") && !stringArray[n].equals("-h")) {
                        System.err.println("Unknown option: " + stringArray[n]);
                    }
                    Main.usage();
                    return;
                }
                string = stringArray[n];
            }
            ++n;
        }
        if (n < stringArray.length) {
            System.err.println("Too many arguments.");
            Main.usage();
            return;
        }
        Main main = new Main(string);
        main.show();
    }

    public Main(String string) {
        this.setClassPath(string);
        this.frame = new JFrame("Jode (c) 1998-2001 Jochen Hoenicke <jochen@gnu.org>");
        this.fillContentPane(this.frame.getContentPane());
        this.addMenu(this.frame);
        this.frame.setDefaultCloseOperation(2);
        Main main = this;
        if (main == null) {
            throw null;
        }
        this.frame.addWindowListener(new WindowAdapter(main){
            private final /* synthetic */ Main this$0;

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
            {
                this.this$0 = main;
                this.constructor$0(main);
            }

            private final void constructor$0(Main main) {
            }
        });
    }

    public class AreaWriter
    extends Writer {
        boolean initialized = false;
        boolean lastCR = false;
        private JTextArea area;

        public void write(char[] cArray, int n, int n2) throws IOException {
            if (!this.initialized) {
                this.area.setText("");
                this.initialized = true;
            }
            String string = new String(cArray, n, n2);
            StringBuffer stringBuffer = new StringBuffer(n2);
            while (string != null && string.length() > 0) {
                int n3;
                if (this.lastCR && string.charAt(0) == '\n') {
                    string = string.substring(1);
                }
                if ((n3 = string.indexOf(13)) >= 0) {
                    stringBuffer.append(string.substring(0, n3));
                    stringBuffer.append("\n");
                    string = string.substring(n3 + 1);
                    this.lastCR = true;
                    continue;
                }
                stringBuffer.append(string);
                string = null;
            }
            this.area.append(stringBuffer.toString());
        }

        public void flush() {
        }

        public void close() {
        }

        public AreaWriter(JTextArea jTextArea) {
            this.area = jTextArea;
        }
    }
}

