/*
 * Decompiled with CFR 0.152.
 */
package jode.type;

import jode.AssertError;
import jode.GlobalOptions;
import jode.type.Type;

public class IntegerType
extends Type {
    public static final int IT_Z = 1;
    public static final int IT_I = 2;
    public static final int IT_C = 4;
    public static final int IT_S = 8;
    public static final int IT_B = 16;
    public static final int IT_cS = 32;
    public static final int IT_cB = 64;
    private static final int NUM_TYPES = 7;
    private static final int[] subTypes = new int[]{1, 30, 4, 24, 16, 96, 64};
    private static final int[] superTypes = new int[]{1, 2, 6, 10, 26, 46, 126};
    private static final Type[] simpleTypes = new Type[]{new IntegerType(1), new IntegerType(2), new IntegerType(4), new IntegerType(8), new IntegerType(16), new IntegerType(32), new IntegerType(64)};
    private static final String[] typeNames = new String[]{"Z", "I", "C", "S", "B", "s", "b"};
    int possTypes;
    int hintTypes;

    public Type getHint() {
        int n = this.possTypes & this.hintTypes;
        if (n == 0) {
            n = this.possTypes;
        }
        int n2 = 0;
        while ((n & 1) == 0) {
            n >>= 1;
            ++n2;
        }
        return simpleTypes[n2];
    }

    public Type getCanonic() {
        int n = this.possTypes;
        int n2 = 0;
        while ((n >>= 1) != 0) {
            ++n2;
        }
        return simpleTypes[n2];
    }

    private static int getSubTypes(int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < 7) {
            if ((1 << n3 & n) != 0) {
                n2 |= subTypes[n3];
            }
            ++n3;
        }
        return n2;
    }

    private static int getSuperTypes(int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < 7) {
            if ((1 << n3 & n) != 0) {
                n2 |= superTypes[n3];
            }
            ++n3;
        }
        return n2;
    }

    public Type getSubType() {
        return new IntegerType(IntegerType.getSubTypes(this.possTypes), IntegerType.getSubTypes(this.hintTypes));
    }

    public Type getSuperType() {
        return new IntegerType(IntegerType.getSuperTypes(this.possTypes), this.hintTypes);
    }

    public boolean isValidType() {
        return true;
    }

    public boolean isOfType(Type type) {
        return type.typecode == 107 && (((IntegerType)type).possTypes & this.possTypes) != 0;
    }

    public String getDefaultName() {
        switch (((IntegerType)this.getHint()).possTypes) {
            case 1: {
                return "bool";
            }
            case 4: {
                return "c";
            }
            case 2: 
            case 8: 
            case 16: {
                return "i";
            }
        }
        throw new AssertError("Local can't be of constant type!");
    }

    public Object getDefaultValue() {
        return new Integer(0);
    }

    public String getTypeSignature() {
        switch (((IntegerType)this.getHint()).possTypes) {
            case 1: {
                return "Z";
            }
            case 4: {
                return "C";
            }
            case 16: {
                return "B";
            }
            case 8: {
                return "S";
            }
        }
        return "I";
    }

    public Class getTypeClass() {
        switch (((IntegerType)this.getHint()).possTypes) {
            case 1: {
                return Boolean.TYPE;
            }
            case 4: {
                return Character.TYPE;
            }
            case 16: {
                return Byte.TYPE;
            }
            case 8: {
                return Short.TYPE;
            }
        }
        return Integer.TYPE;
    }

    public String toString() {
        if (this.possTypes == this.hintTypes) {
            switch (this.possTypes) {
                case 1: {
                    return "boolean";
                }
                case 4: {
                    return "char";
                }
                case 16: {
                    return "byte";
                }
                case 8: {
                    return "short";
                }
                case 2: {
                    return "int";
                }
            }
        }
        StringBuffer stringBuffer = new StringBuffer("{");
        int n = 0;
        while (n < 7) {
            if ((1 << n & this.possTypes) != 0) {
                stringBuffer.append(typeNames[n]);
            }
            ++n;
        }
        if (this.possTypes != this.hintTypes) {
            stringBuffer.append(":");
            n = 0;
            while (n < 7) {
                if ((1 << n & this.hintTypes) != 0) {
                    stringBuffer.append(typeNames[n]);
                }
                ++n;
            }
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public Type intersection(Type type) {
        Type type2;
        int n;
        if (type == tError) {
            return type;
        }
        if (type == tUnknown) {
            return this;
        }
        int n2 = 0;
        if (type.typecode != 107) {
            n = 0;
        } else {
            type2 = (IntegerType)type;
            n = this.possTypes & type2.possTypes;
            n2 = this.hintTypes & type2.hintTypes;
            if (n == this.possTypes && n2 == this.hintTypes) {
                return this;
            }
            if (n == type2.possTypes && n2 == type2.hintTypes) {
                return type2;
            }
        }
        Type type3 = type2 = n == 0 ? tError : new IntegerType(n, n2);
        if ((GlobalOptions.debuggingFlags & 4) != 0) {
            GlobalOptions.err.println("intersecting " + this + " and " + type + " to " + type2);
        }
        return type2;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof IntegerType) {
            IntegerType integerType = (IntegerType)object;
            return integerType.possTypes == this.possTypes && integerType.hintTypes == this.hintTypes;
        }
        return false;
    }

    public IntegerType(int n) {
        this(n, n);
    }

    public IntegerType(int n, int n2) {
        super(107);
        this.possTypes = n;
        this.hintTypes = n2;
    }
}

