/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.woenvironment.env;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;

public class Environment {
    private final String NEXT_ROOT = "NEXT_ROOT";
    private final String NEXT_LOCAL_ROOT = "NEXT_LOCAL_ROOT";
    private final String NEXT_SYSTEM_ROOT = "NEXT_SYSTEM_ROOT";
    private Properties envVars;

    protected Environment() {
    }

    public Properties getEnvVars() {
        if (this.envVars != null) {
            return this.envVars;
        }
        Process process = null;
        BufferedReader bufferedReader = null;
        String string = null;
        try {
            process = Environment.osProcess();
        }
        catch (InvocationTargetException invocationTargetException) {
            System.out.println("getEnvVars -> unable to load environment variables" + invocationTargetException);
        }
        this.envVars = new Properties();
        if (process == null) {
            return this.envVars;
        }
        bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        try {
            while ((string = bufferedReader.readLine()) != null) {
                int n = string.indexOf(61);
                String string2 = string.substring(0, n);
                String string3 = string.substring(n + 1);
                this.envVars.setProperty(string2, string3);
            }
        }
        catch (IOException iOException) {
            System.out.println("getEnvVars -> unable to load environment variables" + iOException);
        }
        process.destroy();
        return this.envVars;
    }

    private static Process osProcess() throws InvocationTargetException {
        Process process = null;
        Runtime runtime = null;
        String string = null;
        try {
            runtime = Runtime.getRuntime();
            string = System.getProperty("os.name").toLowerCase();
            process = string.indexOf("windows 9") > -1 ? runtime.exec("command.com /c set") : (string.indexOf("nt") > -1 || string.indexOf("windows 200") > -1 ? runtime.exec("cmd.exe /c set") : runtime.exec("env"));
            return process;
        }
        catch (IOException iOException) {
            throw new InvocationTargetException(iOException);
        }
    }

    public String userHome() {
        if (System.getProperty("user.home") != null) {
            return System.getProperty("user.home");
        }
        if (this.getEnvVars().getProperty("USERPROFILE") != null) {
            return this.getEnvVars().getProperty("USERPROFILE");
        }
        System.out.println("userHome -> no user home found");
        return null;
    }

    public String getNEXT_LOCAL_ROOT() {
        return "NEXT_LOCAL_ROOT";
    }

    public String getNEXT_ROOT() {
        return "NEXT_ROOT";
    }

    public String getNEXT_SYSTEM_ROOT() {
        return "NEXT_SYSTEM_ROOT";
    }
}

