/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.woenvironment.env;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.objectstyle.woenvironment.util.FileStringScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WOVariables {
    public static final String USER_ROOT = "wo.user.root";
    public static final String USER_FRAMEWORKS = "wo.user.frameworks";
    public static final String LOCAL_ROOT = "wo.local.root";
    public static final String LOCAL_FRAMEWORKS = "wo.local.frameworks";
    public static final String SYSTEM_ROOT = "wo.system.root";
    public static final String SYSTEM_FRAMEWORKS = "wo.system.frameworks";
    public static final String NETWORK_ROOT = "wo.network.root";
    public static final String NETWORK_FRAMEWORKS = "wo.network.frameworks";
    public static final String EXTERNAL_BUILD_ROOT = "wo.external.root";
    public static final String EXTERNAL_BUILD_FRAMEWORKS = "wo.external.frameworks";
    public static final String APPS_ROOT = "wo.apps.root";
    public static final String API_ROOT_KEY = "wo.api.root";
    public static final String BOOTSTRAP_JAR_KEY = "wo.bootstrapjar";
    public static final String WEBOBJECTS_EXTENSIONS = "wo.extensions";
    public static final String WOLIPS_PROPERTIES = "wolips.properties";
    private static Map<File, CachedProperties> _cachedProperties = new HashMap<File, CachedProperties>();
    private Properties _wolipsProperties;
    private File _wolipsPropertiesFile;

    public WOVariables(WOVariables wOVariables, Map<Object, Object> map) {
        this.init(wOVariables, map);
    }

    public WOVariables(Map<Object, Object> map) {
        this.init(null, map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void init(WOVariables wOVariables, Map<Object, Object> map) {
        if (wOVariables == null) {
            this._wolipsProperties = new Properties();
            Object object2 = map != null ? (String)map.get(WOLIPS_PROPERTIES) : System.getProperty(WOLIPS_PROPERTIES);
            if (object2 == null) {
                object2 = System.getenv(WOLIPS_PROPERTIES);
            }
            if (object2 == null || !new File((String)object2).isAbsolute()) {
                if (object2 == null) {
                    void var4_6;
                    Object object = null;
                    if (map != null) {
                        String string = (String)map.get("wolips.environment");
                    }
                    object2 = var4_6 != null ? "wolips." + (String)var4_6 + ".properties" : WOLIPS_PROPERTIES;
                }
                this._wolipsPropertiesFile = WOVariables.isWindows() ? new File(System.getenv("APPDATA") + "\\WOLips\\" + (String)object2) : new File(this.userHomeFolder(), "Library/Application Support/WOLips/" + (String)object2);
            } else {
                this._wolipsPropertiesFile = new File((String)object2);
            }
            if (this.isValidWOlipsPropertiesFile()) {
                void var4_9;
                Map<File, CachedProperties> map2 = _cachedProperties;
                synchronized (map2) {
                    CachedProperties cachedProperties = _cachedProperties.get(this._wolipsPropertiesFile);
                    if (cachedProperties == null) {
                        CachedProperties cachedProperties2 = new CachedProperties(this._wolipsPropertiesFile);
                        _cachedProperties.put(this._wolipsPropertiesFile, cachedProperties2);
                    }
                }
                var4_9.reloadIfNecessary();
                this._wolipsProperties = new Properties();
                this._wolipsProperties.putAll((Map<?, ?>)var4_9.properties());
            } else if (this._wolipsProperties == null || this._wolipsProperties.isEmpty()) {
                this.createDefaultProperties();
            }
        } else {
            this._wolipsProperties = new Properties();
            this._wolipsProperties.putAll((Map<?, ?>)wOVariables._wolipsProperties);
        }
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String)) continue;
                this._wolipsProperties.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createDefaultProperties() {
        block12: {
            this._wolipsProperties = new Properties();
            String string = System.getenv("NEXT_ROOT");
            String string2 = System.getProperty("user.home");
            if (string2 == null) {
                string2 = ".";
            }
            if (WOVariables.isWindows()) {
                this._wolipsProperties.setProperty(API_ROOT_KEY, "/Developer/ADC%20Reference%20Library/documentation/WebObjects/Reference/API/");
                this._wolipsProperties.setProperty(APPS_ROOT, string + "\\Applications");
                this._wolipsProperties.setProperty(BOOTSTRAP_JAR_KEY, string + "\\Library\\Application\\wotaskd.woa\\WOBootstrap.jar");
                this._wolipsProperties.setProperty(LOCAL_ROOT, string + "\\Local");
                this._wolipsProperties.setProperty(LOCAL_FRAMEWORKS, string + "\\Local\\Library\\Frameworks");
                this._wolipsProperties.setProperty(SYSTEM_ROOT, string);
                this._wolipsProperties.setProperty(SYSTEM_FRAMEWORKS, string + "\\Library\\Frameworks");
                this._wolipsProperties.setProperty(NETWORK_ROOT, string + "\\Network");
                this._wolipsProperties.setProperty(NETWORK_FRAMEWORKS, string + "\\Network\\Library\\Frameworks");
                this._wolipsProperties.setProperty(USER_ROOT, string2);
                this._wolipsProperties.setProperty(USER_FRAMEWORKS, string2 + "\\Library\\Frameworks");
                this._wolipsProperties.setProperty(WEBOBJECTS_EXTENSIONS, string + "\\Extensions");
            } else {
                this._wolipsProperties.setProperty(API_ROOT_KEY, "/Developer/Documentation/DocSets/com.apple.ADC_Reference_Library.WebObjectsReference.docset/Contents/Resources/Documents/documentation/InternetWeb/Reference/WO542Reference");
                this._wolipsProperties.setProperty(APPS_ROOT, "/Library/WebObjects/Applications");
                this._wolipsProperties.setProperty(BOOTSTRAP_JAR_KEY, "/System/Library/WebObjects/JavaApplications/wotaskd.woa/WOBootstrap.jar");
                this._wolipsProperties.setProperty(LOCAL_ROOT, "/");
                this._wolipsProperties.setProperty(LOCAL_FRAMEWORKS, "/Library/Frameworks");
                this._wolipsProperties.setProperty(SYSTEM_ROOT, "/System");
                this._wolipsProperties.setProperty(SYSTEM_FRAMEWORKS, "/System/Library/Frameworks");
                this._wolipsProperties.setProperty(NETWORK_ROOT, "/Network");
                this._wolipsProperties.setProperty(NETWORK_FRAMEWORKS, "/Network/Library/Frameworks");
                this._wolipsProperties.setProperty(USER_ROOT, string2);
                this._wolipsProperties.setProperty(USER_FRAMEWORKS, string2 + "/Library/Frameworks");
                this._wolipsProperties.setProperty(WEBOBJECTS_EXTENSIONS, "/Library/WebObjects/Extensions");
            }
            try {
                File file = this._wolipsPropertiesFile.getParentFile();
                if (!file.exists()) {
                    file.mkdirs();
                }
                if (!file.canWrite()) break block12;
                FileOutputStream fileOutputStream = new FileOutputStream(this._wolipsPropertiesFile);
                try {
                    this._wolipsProperties.store(fileOutputStream, null);
                }
                finally {
                    fileOutputStream.close();
                }
                Map<File, CachedProperties> map = _cachedProperties;
                synchronized (map) {
                    _cachedProperties.remove(this._wolipsPropertiesFile);
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException("Failed to write " + this._wolipsPropertiesFile + ".", iOException);
            }
        }
    }

    public boolean isValidWOlipsPropertiesFile() {
        return this._wolipsPropertiesFile != null && this._wolipsPropertiesFile.exists() && !this._wolipsPropertiesFile.isDirectory();
    }

    public File wolipsPropertiesFile() {
        return this._wolipsPropertiesFile;
    }

    public String externalBuildRoot() {
        return this._wolipsProperties.getProperty(EXTERNAL_BUILD_ROOT);
    }

    public String externalBuildFrameworkPath() {
        String string;
        String string2 = this._wolipsProperties.getProperty(EXTERNAL_BUILD_FRAMEWORKS);
        if (string2 == null && (string = this.externalBuildRoot()) != null) {
            string2 = new File(new File(string, "Library"), "Frameworks").toString();
        }
        return string2;
    }

    public String localRoot() {
        return this._wolipsProperties.getProperty(LOCAL_ROOT);
    }

    public String localFrameworkPath() {
        String string;
        String string2 = this._wolipsProperties.getProperty(LOCAL_FRAMEWORKS);
        if (string2 == null && (string = this.localRoot()) != null) {
            string2 = new File(new File(string, "Library"), "Frameworks").toString();
        }
        return string2;
    }

    public String systemRoot() {
        return this._wolipsProperties.getProperty(SYSTEM_ROOT);
    }

    public String systemFrameworkPath() {
        String string;
        String string2 = this._wolipsProperties.getProperty(SYSTEM_FRAMEWORKS);
        if (string2 == null && (string = this.systemRoot()) != null) {
            string2 = new File(new File(string, "Library"), "Frameworks").toString();
        }
        return string2;
    }

    public String networkRoot() {
        return this._wolipsProperties.getProperty(NETWORK_ROOT);
    }

    public String networkFrameworkPath() {
        String string;
        String string2 = this._wolipsProperties.getProperty(NETWORK_FRAMEWORKS);
        if (string2 == null && (string = this.networkRoot()) != null) {
            string2 = new File(new File(string, "Library"), "Frameworks").toString();
        }
        return string2;
    }

    public String appsRoot() {
        return this._wolipsProperties.getProperty(APPS_ROOT);
    }

    public String boostrapJar() {
        return this._wolipsProperties.getProperty(BOOTSTRAP_JAR_KEY);
    }

    public String referenceApi() {
        return this._wolipsProperties.getProperty(API_ROOT_KEY);
    }

    public String userHomeFolder() {
        String string = System.getProperty("user.home");
        if (string == null) {
            string = System.getenv("USERPROFILE");
        }
        if (string == null) {
            System.out.println("WOVariables.userHome: No user home directory found.");
        }
        return string;
    }

    public String userRoot() {
        return this._wolipsProperties.getProperty(USER_ROOT);
    }

    public String userFrameworkPath() {
        return this._wolipsProperties.getProperty(USER_FRAMEWORKS);
    }

    public static String woProjectFileName() {
        return "PB.project";
    }

    public static String webServerResourcesDirName() {
        return "WebServerResources";
    }

    public String encodePathForFile(File file) {
        return this.encodePath(file.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String encodePath(String string) {
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        try {
            boolean bl;
            string4 = this.localRoot();
            string2 = this.userRoot();
            string3 = this.systemRoot();
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            if (string4 != null) {
                n = string4.length();
            }
            if (string2 != null) {
                n2 = string2.length();
            }
            if (string3 != null) {
                n3 = string3.length();
            }
            string5 = this.convertWindowsPath(string);
            if (string4 != null && string5.startsWith(string4)) {
                bl = false;
                if (n < n2 && string5.startsWith(string2)) {
                    bl = true;
                }
                if (n < n3 && string5.startsWith(string3)) {
                    bl = true;
                }
                if (!bl) {
                    if (n == 1) {
                        String string6 = "LOCALROOT" + string5;
                        return string6;
                    }
                    String string7 = "LOCALROOT" + string5.substring(n);
                    return string7;
                }
            }
            if (string2 != null && string5.startsWith(string2)) {
                bl = false;
                if (n2 < n3 && string5.startsWith(string3)) {
                    bl = true;
                }
                if (!bl) {
                    String string8 = "HOMEROOT" + string5.substring(n2);
                    return string8;
                }
            }
            if (string3 != null && string5.startsWith(string3)) {
                String string9 = "WOROOT" + string5.substring(n3);
                return string9;
            }
            String string10 = string5;
            return string10;
        }
        catch (Exception exception) {
            System.out.println("Exception occurred during encoding of the path " + exception);
        }
        finally {
            string4 = null;
            string2 = null;
            string3 = null;
            string5 = null;
        }
        return null;
    }

    private String convertWindowsPath(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        return FileStringScanner.replace(string, "\\", "/");
    }

    public String getProperty(String string) {
        return this._wolipsProperties != null ? this._wolipsProperties.getProperty(string) : null;
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().contains("windows");
    }

    public static class CachedProperties {
        private File _propertiesFile;
        private long _lastLoaded;
        private Properties _properties;

        public CachedProperties(File file) {
            this._propertiesFile = file;
            this._properties = new Properties();
        }

        public void reloadIfNecessary() {
            long l;
            if (this._propertiesFile.exists() && this._lastLoaded != (l = this._propertiesFile.lastModified())) {
                this.reload();
                this._lastLoaded = l;
            }
        }

        public Properties properties() {
            return this._properties;
        }

        public void reload() {
            try {
                this._properties = new Properties();
                this._properties.load(new FileInputStream(this._propertiesFile));
            }
            catch (IOException iOException) {
                throw new RuntimeException("Failed to load " + this._propertiesFile + ".", iOException);
            }
        }
    }
}

