/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.woenvironment.frameworks;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.objectstyle.woenvironment.frameworks.Framework;
import org.objectstyle.woenvironment.frameworks.FrameworkLibrary;
import org.objectstyle.woenvironment.frameworks.IFramework;
import org.objectstyle.woenvironment.frameworks.Root;
import org.objectstyle.woenvironment.util.Parser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFolderFramework
extends Framework {
    private File frameworkFolder;
    private List<FrameworkLibrary> libraries;
    private File javaFolder;

    public AbstractFolderFramework(Root root, File file) {
        super(root, AbstractFolderFramework.frameworkNameForFolder(file));
        this.frameworkFolder = file;
        this.reloadLibraries();
    }

    public File getFrameworkFolder() {
        return this.frameworkFolder;
    }

    public Map<String, Object> getInfoPlist() {
        Map map;
        File file = new File(this.frameworkFolder, "Resources/Info.plist");
        if (file.exists()) {
            try {
                Parser parser = new Parser(file);
                Object object = parser.propertyList();
                if (object instanceof Map) {
                    map = (Map)object;
                }
                if (object instanceof String) {
                    map = null;
                }
                map = null;
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new RuntimeException("Failed to load info.plist for " + this.getName() + ".", fileNotFoundException);
            }
        } else {
            map = null;
        }
        return map;
    }

    protected void guessJars(File file, List<File> list) {
        File[] fileArray = file.listFiles();
        if (fileArray != null && fileArray.length > 0) {
            for (File file2 : fileArray) {
                if (file2.isDirectory()) {
                    this.guessJars(file2, list);
                    continue;
                }
                String string = file2.getName();
                if (!string.toLowerCase().endsWith(".jar") && !string.toLowerCase().endsWith(".zip") || this.isSourceJar(string)) continue;
                list.add(file2);
            }
        }
    }

    public synchronized void reloadLibraries() {
        Object object;
        File file;
        this.libraries = new LinkedList<FrameworkLibrary>();
        LinkedList<File> linkedList = new LinkedList<File>();
        boolean bl = true;
        this.javaFolder = new File(this.frameworkFolder, "Resources/Java");
        Map<String, Object> map = this.getInfoPlist();
        if (map != null) {
            List object4;
            String string2 = (String)map.get("NSJavaRoot");
            if (string2 != null) {
                this.javaFolder = new File(this.frameworkFolder, string2);
            }
            if ((object4 = (List)map.get("NSJavaPath")) != null) {
                for (String string : object4) {
                    file = new File(this.javaFolder, string);
                    object = file.getName();
                    if (!file.exists() || this.isSourceJar((String)object)) continue;
                    linkedList.add(file);
                }
                bl = false;
            }
        }
        if (bl && this.javaFolder.exists()) {
            this.guessJars(this.javaFolder, linkedList);
        }
        for (File file2 : linkedList) {
            String string;
            String string2 = file2.getName();
            string = this.getSourceJarNameForJarNamed(string2);
            file = new File(file2.getParentFile(), string);
            if (!file.exists()) {
                file = file2;
            }
            object = new FrameworkLibrary(file2, file, null, null, null);
            this.libraries.add((FrameworkLibrary)object);
        }
    }

    protected String getSourceJarNameForJarNamed(String string) {
        String string2 = string.equalsIgnoreCase(this.getName() + ".jar") ? "src.jar" : string.replaceFirst("\\.jar", "-src.jar");
        return string2;
    }

    protected boolean isSourceJar(String string) {
        boolean bl = false;
        if (string.equals("src.jar") || string.endsWith("-src.jar")) {
            bl = true;
        }
        return bl;
    }

    @Override
    public List<FrameworkLibrary> getFrameworkLibraries() {
        return this.libraries;
    }

    @Override
    public IFramework resolveFramework() {
        return this;
    }

    @Override
    public boolean isResolved() {
        return true;
    }

    @Override
    public String toString() {
        return "[Framework: name = " + this.getName() + "; folder = " + this.getFrameworkFolder() + "]";
    }

    public static String frameworkNameForFolder(File file) {
        String string = file.getName();
        string = string.substring(0, string.lastIndexOf(".framework"));
        return string;
    }
}

