/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.woenvironment.frameworks;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.objectstyle.woenvironment.frameworks.IFramework;
import org.objectstyle.woenvironment.frameworks.Root;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FrameworkModel<T extends IFramework> {
    private List<Root<T>> roots;

    protected abstract List<Root<T>> createRoots();

    public synchronized List<Root<T>> getRoots() {
        if (this.roots == null) {
            this.roots = this.createRoots();
        }
        return this.roots;
    }

    public synchronized Set<T> getAllFrameworks() {
        HashMap<String, IFramework> hashMap = new HashMap<String, IFramework>();
        for (Root<T> root : this.getRoots()) {
            for (IFramework iFramework : root.getFrameworks()) {
                String string = iFramework.getName();
                if (hashMap.containsKey(string)) continue;
                hashMap.put(string, iFramework);
            }
        }
        return new HashSet(hashMap.values());
    }

    public synchronized void refreshRoots() {
        this.roots = null;
        this.getRoots();
    }

    public T getFrameworkWithName(String string) {
        for (Root<T> root : this.getRoots()) {
            T t = root.getFrameworkWithName(string);
            if (t == null) continue;
            return t;
        }
        return null;
    }

    public Root<T> getRootWithShortName(String string) {
        for (Root<T> root : this.getRoots()) {
            if (!string.equals(root.getShortName())) continue;
            return root;
        }
        return null;
    }
}

