/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.woenvironment.plist;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectstyle.woenvironment.plist.ParserDataStructureFactory;
import org.objectstyle.woenvironment.plist.PropertyListParserException;
import org.objectstyle.woenvironment.plist.SimpleParserDataStructureFactory;

public class WOLPropertyListSerialization {
    private WOLPropertyListSerialization() {
        throw new IllegalStateException("Can't instantiate an instance of class " + this.getClass().getName());
    }

    public static String stringFromPropertyList(Object object) throws PropertyListParserException {
        return _Utilities.stringFromPropertyList(object);
    }

    public static Object propertyListFromString(String string) throws IOException, PropertyListParserException {
        return WOLPropertyListSerialization.propertyListFromString(string, new SimpleParserDataStructureFactory());
    }

    public static Object propertyListFromString(String string, ParserDataStructureFactory parserDataStructureFactory) throws PropertyListParserException {
        return _Utilities.propertyListFromString(string, parserDataStructureFactory);
    }

    public static Object propertyListWithPathURL(URL uRL, ParserDataStructureFactory parserDataStructureFactory) throws IOException, PropertyListParserException {
        String string = WOLPropertyListSerialization.stringFromURL(uRL);
        return WOLPropertyListSerialization.propertyListFromString(string, parserDataStructureFactory);
    }

    public static Object propertyListWithContentsOfInputStream(InputStream inputStream, ParserDataStructureFactory parserDataStructureFactory) throws IOException, PropertyListParserException {
        String string = WOLPropertyListSerialization.stringFromInputStream(inputStream);
        return WOLPropertyListSerialization.propertyListFromString(string, parserDataStructureFactory);
    }

    public static Object propertyListWithContentsOfFile(String string, ParserDataStructureFactory parserDataStructureFactory) throws IOException, PropertyListParserException {
        return _Utilities.propertyListWithContentsOfFile(string, parserDataStructureFactory);
    }

    public static String stringFromFile(File file) throws IOException {
        return new String(WOLPropertyListSerialization.bytesFromFile(file));
    }

    public static String stringFromFile(File file, String string) throws IOException {
        if (string == null) {
            return new String(WOLPropertyListSerialization.bytesFromFile(file));
        }
        return new String(WOLPropertyListSerialization.bytesFromFile(file), string);
    }

    public static byte[] bytesFromFile(File file) throws IOException {
        return WOLPropertyListSerialization.bytesFromFile(file, (int)file.length());
    }

    public static byte[] bytesFromFile(File file, int n) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; i += fileInputStream.read(byArray, i, n - i)) {
        }
        fileInputStream.close();
        return byArray;
    }

    public static byte[] bytesFromInputStream(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new IOException("null input stream");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = -1;
        byte[] byArray = new byte[51200];
        while ((n = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static String stringFromInputStream(InputStream inputStream) throws IOException {
        return new String(WOLPropertyListSerialization.bytesFromInputStream(inputStream));
    }

    public static String stringFromInputStream(InputStream inputStream, String string) throws IOException {
        return new String(WOLPropertyListSerialization.bytesFromInputStream(inputStream), string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String stringFromURL(URL uRL) throws IOException {
        InputStream inputStream = uRL.openStream();
        try {
            String string = WOLPropertyListSerialization.stringFromInputStream(inputStream);
            return string;
        }
        finally {
            inputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String stringFromURL(URL uRL, String string) throws IOException {
        InputStream inputStream = uRL.openStream();
        try {
            String string2 = WOLPropertyListSerialization.stringFromInputStream(inputStream, string);
            return string2;
        }
        finally {
            inputStream.close();
        }
    }

    public static Object propertyListFromFile(File file) throws IOException, PropertyListParserException {
        return WOLPropertyListSerialization.propertyListWithPathURL(file.toURL(), new SimpleParserDataStructureFactory());
    }

    public static Object propertyListFromFile(File file, ParserDataStructureFactory parserDataStructureFactory) throws IOException, PropertyListParserException {
        return WOLPropertyListSerialization.propertyListWithPathURL(file.toURL(), parserDataStructureFactory);
    }

    public static Object propertyListFromURL(URL uRL, ParserDataStructureFactory parserDataStructureFactory) throws IOException, PropertyListParserException {
        return WOLPropertyListSerialization.propertyListWithPathURL(uRL, parserDataStructureFactory);
    }

    public static Object propertyListFromStream(InputStream inputStream) throws IOException, PropertyListParserException {
        return WOLPropertyListSerialization.propertyListWithContentsOfInputStream(inputStream, new SimpleParserDataStructureFactory());
    }

    public static Object propertyListFromStream(InputStream inputStream, ParserDataStructureFactory parserDataStructureFactory) throws IOException, PropertyListParserException {
        return WOLPropertyListSerialization.propertyListWithContentsOfInputStream(inputStream, parserDataStructureFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void propertyListToFile(String string, File file, Object object) throws PropertyListParserException, IOException {
        block9: {
            BufferedWriter bufferedWriter = null;
            try {
                String string2 = WOLPropertyListSerialization.stringFromPropertyList(object);
                if (string2 == null) break block9;
                try {
                    Object object2 = WOLPropertyListSerialization.propertyListFromFile(file);
                    Object object3 = WOLPropertyListSerialization.propertyListFromString(string2, new SimpleParserDataStructureFactory());
                    if (object2.equals(object3)) {
                        return;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), Charset.forName("UTF-8")));
                bufferedWriter.write(string2);
                if (string2.length() > 0 && string2.charAt(string2.length() - 1) != '\n') {
                    bufferedWriter.write(10);
                }
            }
            finally {
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void propertyListToStream(OutputStream outputStream, Object object) throws PropertyListParserException, IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
        try {
            String string = WOLPropertyListSerialization.stringFromPropertyList(object);
            if (string != null) {
                bufferedWriter.write(string);
            }
        }
        finally {
            bufferedWriter.close();
        }
    }

    public static class EMMutableData {
        private ByteArrayOutputStream _stream;

        public EMMutableData(int n) {
            this._stream = new ByteArrayOutputStream(n);
        }

        public EMMutableData(ByteArrayOutputStream byteArrayOutputStream) {
            this._stream = byteArrayOutputStream;
        }

        public byte[] bytes() {
            return this._stream.toByteArray();
        }

        public EMMutableData clone() {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                byteArrayOutputStream.write(this.bytes());
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            return new EMMutableData(byteArrayOutputStream);
        }

        public void appendByte(byte by) {
            this._stream.write(by);
        }

        public boolean isEqualToData(EMMutableData eMMutableData) {
            boolean bl;
            if (eMMutableData == this) {
                bl = true;
            } else {
                byte[] byArray;
                byte[] byArray2 = this.bytes();
                if (byArray2.length != (byArray = eMMutableData.bytes()).length) {
                    bl = false;
                } else {
                    bl = true;
                    for (int i = 0; bl && i < byArray2.length; ++i) {
                        bl = byArray2[i] == byArray[i];
                    }
                }
            }
            return bl;
        }
    }

    public static class _Utilities {
        public static final String ROOT = "root";
        private int _lineNumber;
        private int _startOfLineCharIndex;
        private static int _savedIndex;
        private static int _savedLineNumber;
        private static int _savedStartOfLineCharIndex;
        private static final int[] NSToPrecompUnicodeTable;

        private void _saveIndexes(int n, int n2, int n3) {
            _savedIndex = n;
            _savedLineNumber = n2;
            _savedStartOfLineCharIndex = n3;
        }

        private String _savedIndexesAsString() {
            return "line number: " + _savedLineNumber + ", column: " + (_savedIndex - _savedStartOfLineCharIndex);
        }

        public static String stringFromPropertyList(Object object) throws PropertyListParserException {
            if (object == null) {
                return null;
            }
            StringBuffer stringBuffer = new StringBuffer(128);
            _Utilities._appendObjectToStringBuffer(object, stringBuffer, 0);
            return stringBuffer.toString();
        }

        public static Object propertyListWithContentsOfFile(String string, ParserDataStructureFactory parserDataStructureFactory) throws IOException, PropertyListParserException {
            String string2 = WOLPropertyListSerialization.stringFromFile(new File(string));
            return _Utilities.propertyListFromString(string2, parserDataStructureFactory);
        }

        public static Object propertyListFromString(String string, ParserDataStructureFactory parserDataStructureFactory) throws PropertyListParserException {
            return new _Utilities()._propertyListFromString(string, parserDataStructureFactory);
        }

        private Object _propertyListFromString(String string, ParserDataStructureFactory parserDataStructureFactory) throws PropertyListParserException {
            this._startOfLineCharIndex = 0;
            this._lineNumber = 0;
            if (string == null) {
                return null;
            }
            char[] cArray = string.toCharArray();
            Object[] objectArray = new Object[1];
            this._lineNumber = 1;
            this._startOfLineCharIndex = 0;
            objectArray[0] = null;
            int n = 0;
            n = this._readObjectIntoObjectReference(cArray, n, objectArray, ROOT, parserDataStructureFactory);
            if ((n = this._skipWhitespaceAndComments(cArray, n)) != -1) {
                throw new PropertyListParserException("The property list contained an object, but it appears to be truncated (line number: " + this._lineNumber + ", column: " + (n - this._startOfLineCharIndex) + ").");
            }
            return objectArray[0];
        }

        private static void _appendObjectToStringBuffer(Object object, StringBuffer stringBuffer, int n) throws PropertyListParserException {
            if (object instanceof String) {
                _Utilities._appendStringToStringBuffer((String)object, stringBuffer, n);
            } else if (object instanceof StringBuffer) {
                _Utilities._appendStringToStringBuffer(((StringBuffer)object).toString(), stringBuffer, n);
            } else if (object instanceof EMMutableData) {
                _Utilities._appendDataToStringBuffer((EMMutableData)object, stringBuffer, n);
            } else if (object instanceof List) {
                _Utilities._appendCollectionToStringBuffer((List)object, stringBuffer, n);
            } else if (object instanceof Set) {
                _Utilities._appendCollectionToStringBuffer((Set)object, stringBuffer, n);
            } else if (object instanceof Map) {
                _Utilities._appendDictionaryToStringBuffer((Map)object, stringBuffer, n);
            } else if (object instanceof Boolean) {
                String string = (Boolean)object != false ? "true" : "false";
                _Utilities._appendStringToStringBuffer(string, stringBuffer, n);
            } else {
                _Utilities._appendStringToStringBuffer(object.toString(), stringBuffer, n);
            }
        }

        protected static String escapeString(String string) {
            char[] cArray = string.toCharArray();
            int n = cArray.length;
            StringBuffer stringBuffer = new StringBuffer(n + 3);
            for (int i = 0; i < cArray.length; ++i) {
                if (cArray[i] < '\u0080') {
                    if (cArray[i] == '\n') {
                        stringBuffer.append("\\n");
                        continue;
                    }
                    if (cArray[i] == '\r') {
                        stringBuffer.append("\\r");
                        continue;
                    }
                    if (cArray[i] == '\t') {
                        stringBuffer.append("\\t");
                        continue;
                    }
                    if (cArray[i] == '\"') {
                        stringBuffer.append("\\\"");
                        continue;
                    }
                    if (cArray[i] == '\\') {
                        stringBuffer.append("\\\\");
                        continue;
                    }
                    if (cArray[i] == '\f') {
                        stringBuffer.append("\\f");
                        continue;
                    }
                    if (cArray[i] == '\b') {
                        stringBuffer.append("\\b");
                        continue;
                    }
                    if (cArray[i] == '\u0007') {
                        stringBuffer.append("\\a");
                        continue;
                    }
                    if (cArray[i] == '\u000b') {
                        stringBuffer.append("\\v");
                        continue;
                    }
                    stringBuffer.append(cArray[i]);
                    continue;
                }
                char c = cArray[i];
                byte by = (byte)(c & 0xF);
                c = (char)(c >> 4);
                byte by2 = (byte)(c & 0xF);
                c = (char)(c >> 4);
                byte by3 = (byte)(c & 0xF);
                c = (char)(c >> 4);
                byte by4 = (byte)(c & 0xF);
                c = (char)(c >> 4);
                stringBuffer.append("\\U");
                stringBuffer.append(_Utilities._hexDigitForNibble(by4));
                stringBuffer.append(_Utilities._hexDigitForNibble(by3));
                stringBuffer.append(_Utilities._hexDigitForNibble(by2));
                stringBuffer.append(_Utilities._hexDigitForNibble(by));
            }
            return stringBuffer.toString();
        }

        private static void _appendStringToStringBuffer(String string, StringBuffer stringBuffer, int n) {
            boolean bl = false;
            char[] cArray = string.toCharArray();
            int n2 = cArray.length;
            if (n2 == 0) {
                bl = true;
            }
            for (int i = 0; !bl && i < n2; ++i) {
                char c = cArray[i];
                if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') continue;
                bl = true;
            }
            String string2 = _Utilities.escapeString(string);
            if (bl) {
                stringBuffer.append('\"');
                stringBuffer.append(string2);
                stringBuffer.append('\"');
            } else {
                stringBuffer.append(string2);
            }
        }

        private static void _appendDataToStringBuffer(EMMutableData eMMutableData, StringBuffer stringBuffer, int n) {
            stringBuffer.append('<');
            byte[] byArray = eMMutableData.bytes();
            for (int i = 0; i < byArray.length; ++i) {
                byte by = byArray[i];
                byte by2 = (byte)(by & 0xF);
                by = (byte)(by >> 4);
                byte by3 = (byte)(by & 0xF);
                stringBuffer.append(_Utilities._hexDigitForNibble(by3));
                stringBuffer.append(_Utilities._hexDigitForNibble(by2));
            }
            stringBuffer.append('>');
        }

        private static void _appendCollectionToStringBuffer(Collection collection, StringBuffer stringBuffer, int n) throws PropertyListParserException {
            stringBuffer.append('(');
            if (!collection.isEmpty()) {
                int n2 = stringBuffer.length();
                StringBuffer stringBuffer2 = new StringBuffer(78);
                Iterator iterator = collection.iterator();
                int n3 = 0;
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (e != null) {
                        if (n3 > 0) {
                            stringBuffer.append(", ");
                        }
                        stringBuffer.append('\n');
                        _Utilities._appendIndentationToStringBuffer(stringBuffer, n + 1);
                        int n4 = stringBuffer.length();
                        _Utilities._appendObjectToStringBuffer(e, stringBuffer, n + 1);
                        int n5 = stringBuffer.length();
                        if (stringBuffer2 != null && stringBuffer2.length() + (n5 - n4) < 79) {
                            if (n3 > 0) {
                                stringBuffer2.append(", ");
                            }
                            stringBuffer2.append(stringBuffer.substring(n4, n5));
                        } else {
                            stringBuffer2 = null;
                        }
                    }
                    ++n3;
                }
                if (stringBuffer2 != null && stringBuffer2.length() < 78) {
                    stringBuffer.setLength(n2);
                    stringBuffer.append(stringBuffer2);
                } else {
                    stringBuffer.append('\n');
                    _Utilities._appendIndentationToStringBuffer(stringBuffer, n);
                }
            }
            stringBuffer.append(')');
        }

        private static void _appendDictionaryToStringBuffer(Map map, StringBuffer stringBuffer, int n) throws PropertyListParserException {
            stringBuffer.append('{');
            if (!map.isEmpty()) {
                Iterator iterator;
                int n2 = stringBuffer.length();
                StringBuffer stringBuffer2 = new StringBuffer(78);
                Set set = map.keySet();
                ArrayList arrayList = new ArrayList(set);
                try {
                    Collections.sort(arrayList);
                    iterator = arrayList.iterator();
                }
                catch (Exception exception) {
                    iterator = set.iterator();
                }
                while (iterator.hasNext()) {
                    Object v;
                    Object object = iterator.next();
                    if (object == null) {
                        throw new PropertyListParserException("Property list generation failed while attempting to write hashtable. Non-String key found in Hashtable. Property list dictionaries must have String's as keys.  The attempkey was '" + object + "'.");
                    }
                    if (!(object instanceof String)) {
                        object = object.toString();
                    }
                    if ((v = map.get(object)) == null) continue;
                    stringBuffer.append('\n');
                    _Utilities._appendIndentationToStringBuffer(stringBuffer, n + 1);
                    int n3 = stringBuffer.length();
                    _Utilities._appendStringToStringBuffer((String)object, stringBuffer, n + 1);
                    int n4 = stringBuffer.length();
                    stringBuffer.append(" = ");
                    int n5 = stringBuffer.length();
                    _Utilities._appendObjectToStringBuffer(v, stringBuffer, n + 1);
                    int n6 = stringBuffer.length();
                    stringBuffer.append("; ");
                    if (stringBuffer2 != null && stringBuffer2.length() + (n4 - n3) + (n6 - n5) < 79) {
                        stringBuffer2.append(stringBuffer.substring(n3, n4));
                        stringBuffer2.append(" = ");
                        stringBuffer2.append(stringBuffer.substring(n5, n6));
                        stringBuffer2.append("; ");
                        continue;
                    }
                    stringBuffer2 = null;
                }
                if (stringBuffer2 != null && stringBuffer2.length() < 78) {
                    stringBuffer.setLength(n2);
                    stringBuffer.append(stringBuffer2);
                } else {
                    stringBuffer.append('\n');
                    _Utilities._appendIndentationToStringBuffer(stringBuffer, n);
                }
            }
            stringBuffer.append('}');
        }

        private static void _appendIndentationToStringBuffer(StringBuffer stringBuffer, int n) {
            for (int i = 0; i < n; ++i) {
                stringBuffer.append("    ");
            }
        }

        private static final char _hexDigitForNibble(byte by) {
            char c = '\u0000';
            if (by >= 0 && by <= 9) {
                c = (char)(48 + (char)by);
            } else if (by >= 10 && by <= 15) {
                c = (char)(97 + (char)(by - 10));
            }
            return c;
        }

        private int _readObjectIntoObjectReference(char[] cArray, int n, Object[] objectArray, String string, ParserDataStructureFactory parserDataStructureFactory) {
            if ((n = this._skipWhitespaceAndComments(cArray, n)) == -1 || n >= cArray.length) {
                objectArray[0] = null;
            } else if (cArray[n] == '\"') {
                StringBuffer stringBuffer = new StringBuffer(64);
                n = this._readQuotedStringIntoStringBuffer(cArray, n, stringBuffer);
                objectArray[0] = stringBuffer.toString();
            } else if (cArray[n] == '<') {
                EMMutableData eMMutableData = new EMMutableData(this._lengthOfData(cArray, n));
                n = this._readDataContentsIntoData(cArray, n, eMMutableData);
                objectArray[0] = eMMutableData;
            } else if (cArray[n] == '(') {
                Collection<Object> collection = parserDataStructureFactory.createCollection(string);
                n = this._readArrayContentsIntoArray(cArray, n, collection, string, parserDataStructureFactory);
                objectArray[0] = collection;
            } else if (cArray[n] == '{') {
                Map<Object, Object> map = parserDataStructureFactory.createMap(string);
                n = this._readDictionaryContentsIntoDictionary(cArray, n, map, string, parserDataStructureFactory);
                objectArray[0] = map;
            } else {
                StringBuffer stringBuffer = new StringBuffer(64);
                n = this._readUnquotedStringIntoStringBuffer(cArray, n, stringBuffer);
                objectArray[0] = stringBuffer.toString();
            }
            return n < cArray.length ? n : -1;
        }

        private int _readUnquotedStringIntoStringBuffer(char[] cArray, int n, StringBuffer stringBuffer) {
            int n2 = n;
            stringBuffer.setLength(0);
            while (n < cArray.length && (cArray[n] >= 'a' && cArray[n] <= 'z' || cArray[n] >= 'A' && cArray[n] <= 'Z' || cArray[n] >= '0' && cArray[n] <= '9' || cArray[n] == '_' || cArray[n] == '$' || cArray[n] == ':' || cArray[n] == '.' || cArray[n] == '/')) {
                ++n;
            }
            if (n2 >= n) {
                throw new IllegalArgumentException("Property list parsing failed while attempting to read unquoted string. No allowable characters were found. At line number: " + this._lineNumber + ", column: " + (n - this._startOfLineCharIndex) + ".");
            }
            stringBuffer.append(cArray, n2, n - n2);
            return n < cArray.length ? n : -1;
        }

        private int _readQuotedStringIntoStringBuffer(char[] cArray, int n, StringBuffer stringBuffer) {
            this._saveIndexes(n, this._lineNumber, this._startOfLineCharIndex);
            int n2 = ++n;
            while (n < cArray.length && cArray[n] != '\"') {
                if (cArray[n] == '\\') {
                    int n3;
                    int n4;
                    int n5;
                    if (n2 < n) {
                        stringBuffer.append(cArray, n2, n - n2);
                    }
                    if (++n >= cArray.length) {
                        throw new IllegalArgumentException("Property list parsing failed while attempting to read quoted string. Input exhausted before closing quote was found. Opening quote was at " + this._savedIndexesAsString() + ".");
                    }
                    if (cArray[n] == 'n') {
                        stringBuffer.append('\n');
                    } else if (cArray[n] == 'r') {
                        stringBuffer.append('\r');
                        ++n;
                    } else if (cArray[n] == 't') {
                        stringBuffer.append('\t');
                        ++n;
                    } else if (cArray[n] == 'f') {
                        stringBuffer.append('\f');
                        ++n;
                    } else if (cArray[n] == 'b') {
                        stringBuffer.append('\b');
                        ++n;
                    } else if (cArray[n] == 'a') {
                        stringBuffer.append('\u0007');
                        ++n;
                    } else if (cArray[n] == 'v') {
                        stringBuffer.append('\u000b');
                        ++n;
                    } else if (cArray[n] == 'u' || cArray[n] == 'U') {
                        if (n + 4 >= cArray.length) {
                            throw new IllegalArgumentException("Property list parsing failed while attempting to read quoted string. Input exhausted before escape sequence was completed. Opening quote was at " + this._savedIndexesAsString() + ".");
                        }
                        if (!(_Utilities._isHexDigit(cArray[++n]) && _Utilities._isHexDigit(cArray[n + 1]) && _Utilities._isHexDigit(cArray[n + 2]) && _Utilities._isHexDigit(cArray[n + 3]))) {
                            throw new IllegalArgumentException("Property list parsing failed while attempting to read quoted string. Improperly formed \\U type escape sequence. At line number: " + this._lineNumber + ", column: " + (n - this._startOfLineCharIndex) + ".");
                        }
                        n5 = _Utilities._nibbleForHexDigit(cArray[n]);
                        n4 = _Utilities._nibbleForHexDigit(cArray[n + 1]);
                        byte by = _Utilities._nibbleForHexDigit(cArray[n + 2]);
                        n3 = _Utilities._nibbleForHexDigit(cArray[n + 3]);
                        stringBuffer.append((char)((n5 << 12) + (n4 << 8) + (by << 4) + n3));
                        n += 4;
                    } else if (cArray[n] >= '0' && cArray[n] <= '7') {
                        n5 = 0;
                        n4 = 1;
                        int[] nArray = new int[3];
                        nArray[0] = cArray[n] - 48;
                        ++n;
                        while (n4 < 3 && n < cArray.length && cArray[n] >= '0' && cArray[n] <= '7') {
                            nArray[n4++] = cArray[n] - 48;
                            ++n;
                        }
                        if (n4 == 3 && nArray[0] > 3) {
                            throw new IllegalArgumentException("Property list parsing failed while attempting to read quoted string. Octal escape sequence too large (bigger than octal 377). At line number: " + this._lineNumber + ", column: " + (n - this._startOfLineCharIndex) + ".");
                        }
                        for (n3 = 0; n3 < n4; ++n3) {
                            n5 *= 8;
                            n5 += nArray[n3];
                        }
                        stringBuffer.append(_Utilities._nsToUnicode(n5));
                    } else {
                        stringBuffer.append(cArray[n]);
                        if (cArray[n] == '\n') {
                            ++this._lineNumber;
                            this._startOfLineCharIndex = n + 1;
                        }
                        ++n;
                    }
                    n2 = ++n;
                    continue;
                }
                if (cArray[n] == '\n') {
                    ++this._lineNumber;
                    this._startOfLineCharIndex = n + 1;
                }
                ++n;
            }
            if (n2 < n) {
                stringBuffer.append(cArray, n2, n - n2);
            }
            if (n >= cArray.length) {
                throw new IllegalArgumentException("Property list parsing failed while attempting to read quoted string. Input exhausted before closing quote was found. Opening quote was at " + this._savedIndexesAsString() + ".");
            }
            return ++n < cArray.length ? n : -1;
        }

        private int _lengthOfData(char[] cArray, int n) {
            int n2 = 0;
            boolean bl = false;
            ++n;
            while (n < cArray.length && ((bl = _Utilities._isHexDigit(cArray[n])) || _Utilities._isWhitespace(cArray[n]))) {
                if (bl) {
                    ++n2;
                }
                ++n;
            }
            if (n >= cArray.length) {
                throw new IllegalArgumentException("Property list parsing failed while attempting to read data. Input exhausted before data was terminated with '>'. At line number: " + this._lineNumber + ", column: " + (n - this._startOfLineCharIndex) + ".");
            }
            if (cArray[n] != '>') {
                throw new IllegalArgumentException("Property list parsing failed while attempting to read data. Illegal character encountered in data: '" + cArray[n] + "'. At line number: " + this._lineNumber + ", column: " + (n - this._startOfLineCharIndex) + ".");
            }
            if (n2 % 2 != 0) {
                throw new IllegalArgumentException("Property list parsing failed while attempting to read data. An odd number of half-bytes were specified. At line number: " + this._lineNumber + ", column: " + (n - this._startOfLineCharIndex) + ".");
            }
            return n2 / 2;
        }

        private int _readDataContentsIntoData(char[] cArray, int n, EMMutableData eMMutableData) {
            ++n;
            while (cArray[n] != '>' && cArray[n = this._skipWhitespaceAndComments(cArray, n)] != '>') {
                byte by = _Utilities._nibbleForHexDigit(cArray[n]);
                ++n;
                n = this._skipWhitespaceAndComments(cArray, n);
                byte by2 = _Utilities._nibbleForHexDigit(cArray[n]);
                ++n;
                eMMutableData.appendByte((byte)((by << 4) + by2));
            }
            return ++n < cArray.length ? n : -1;
        }

        private int _readArrayContentsIntoArray(char[] cArray, int n, Collection collection, String string, ParserDataStructureFactory parserDataStructureFactory) {
            Object[] objectArray = new Object[1];
            ++n;
            collection.clear();
            n = this._skipWhitespaceAndComments(cArray, n);
            while (n != -1 && cArray[n] != ')') {
                if (collection.size() > 0) {
                    if (cArray[n] != ',') {
                        throw new IllegalArgumentException("Property list parsing failed while attempting to read array. No comma found between array elements. At line number: " + this._lineNumber + ", column: " + (n - this._startOfLineCharIndex) + ".");
                    }
                    ++n;
                    if ((n = this._skipWhitespaceAndComments(cArray, n)) == -1) {
                        throw new IllegalArgumentException("Property list parsing failed while attempting to read array. Input exhausted before end of array was found. At line number: " + this._lineNumber + ", column: " + (n - this._startOfLineCharIndex) + ".");
                    }
                }
                if (cArray[n] == ')') continue;
                objectArray[0] = null;
                n = this._readObjectIntoObjectReference(cArray, n, objectArray, string, parserDataStructureFactory);
                if (objectArray[0] == null) {
                    throw new IllegalArgumentException("Property list parsing failed while attempting to read array. Failed to read content object. At line number: " + this._lineNumber + ", column: " + (n - this._startOfLineCharIndex) + ".");
                }
                n = this._skipWhitespaceAndComments(cArray, n);
                collection.add(objectArray[0]);
            }
            if (n == -1) {
                throw new IllegalArgumentException("Property list parsing failed while attempting to read array. Input exhausted before end of array was found. At line number: " + this._lineNumber + ", column: " + (n - this._startOfLineCharIndex) + ".");
            }
            return ++n < cArray.length ? n : -1;
        }

        private int _readDictionaryContentsIntoDictionary(char[] cArray, int n, Map map, String string, ParserDataStructureFactory parserDataStructureFactory) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = new Object[1];
            ++n;
            if (map.size() != 0) {
                Iterator iterator = map.keySet().iterator();
                while (iterator.hasNext()) {
                    map.remove(iterator.next());
                }
            }
            n = this._skipWhitespaceAndComments(cArray, n);
            while (n != -1 && cArray[n] != '}') {
                n = this._readObjectIntoObjectReference(cArray, n, objectArray, string, parserDataStructureFactory);
                if (objectArray[0] == null || !(objectArray[0] instanceof String)) {
                    throw new IllegalArgumentException("Property list parsing failed while attempting to read dictionary. Failed to read key or key is not a String. At line number: " + this._lineNumber + ", column: " + (n - this._startOfLineCharIndex) + ".");
                }
                if ((n = this._skipWhitespaceAndComments(cArray, n)) == -1 || cArray[n] != '=') {
                    throw new IllegalArgumentException("Property list parsing failed while attempting to read dictionary. Read key " + objectArray[0] + " with no value. At line number: " + this._lineNumber + ", column: " + (n - this._startOfLineCharIndex) + ".");
                }
                ++n;
                if ((n = this._skipWhitespaceAndComments(cArray, n)) == -1) {
                    throw new IllegalArgumentException("Property list parsing failed while attempting to read dictionary. Read key " + objectArray[0] + " with no value. At line number: " + this._lineNumber + ", column: " + (n - this._startOfLineCharIndex) + ".");
                }
                n = this._readObjectIntoObjectReference(cArray, n, objectArray2, string + "." + objectArray[0], parserDataStructureFactory);
                if (objectArray2[0] == null) {
                    throw new IllegalArgumentException("Property list parsing failed while attempting to read dictionary. Failed to read value. At line number: " + this._lineNumber + ", column: " + (n - this._startOfLineCharIndex) + ".");
                }
                if ((n = this._skipWhitespaceAndComments(cArray, n)) == -1 || cArray[n] != ';') {
                    throw new IllegalArgumentException("Property list parsing failed while attempting to read dictionary. Read key and value with no terminating semicolon. At line number: " + this._lineNumber + ", column: " + (n - this._startOfLineCharIndex) + ".");
                }
                ++n;
                n = this._skipWhitespaceAndComments(cArray, n);
                map.put(objectArray[0], objectArray2[0]);
            }
            if (n >= cArray.length) {
                throw new IllegalArgumentException("Property list parsing failed while attempting to read dictionary. Exhausted input before end of dictionary was found. At line number: " + this._lineNumber + ", column: " + (n - this._startOfLineCharIndex) + ".");
            }
            return ++n < cArray.length ? n : -1;
        }

        private int _skipWhitespaceAndComments(char[] cArray, int n) {
            int n2 = this._checkForWhitespaceOrComment(cArray, n);
            while (n2 != 1) {
                switch (n2) {
                    case 2: {
                        n = this._processWhitespace(cArray, n);
                        break;
                    }
                    case 3: {
                        n = this._processSingleLineComment(cArray, n);
                        break;
                    }
                    case 4: {
                        n = this._processMultiLineComment(cArray, n);
                    }
                }
                n2 = this._checkForWhitespaceOrComment(cArray, n);
            }
            return n < cArray.length ? n : -1;
        }

        private int _processWhitespace(char[] cArray, int n) {
            while (n < cArray.length && _Utilities._isWhitespace(cArray[n])) {
                if (cArray[n] == '\n') {
                    ++this._lineNumber;
                    this._startOfLineCharIndex = n + 1;
                }
                ++n;
            }
            return n < cArray.length ? n : -1;
        }

        private int _processSingleLineComment(char[] cArray, int n) {
            n += 2;
            while (n < cArray.length && cArray[n] != '\n') {
                ++n;
            }
            return n < cArray.length ? n : -1;
        }

        private int _processMultiLineComment(char[] cArray, int n) {
            this._saveIndexes(n, this._lineNumber, this._startOfLineCharIndex);
            n += 2;
            while (n + 1 < cArray.length && (cArray[n] != '*' || cArray[n + 1] != '/')) {
                if (cArray[n] == '/' && cArray[n + 1] == '*') {
                    throw new IllegalArgumentException("Property list parsing does not support embedded multi line comments.The first /* was at " + this._savedIndexesAsString() + ". A second /* was found at line " + this._lineNumber + ", column: " + (n - this._startOfLineCharIndex) + ".");
                }
                if (cArray[n] == '\n') {
                    ++this._lineNumber;
                    this._startOfLineCharIndex = n + 1;
                }
                ++n;
            }
            if (n + 1 >= cArray.length || cArray[n] != '*' || cArray[n + 1] != '/') {
                throw new IllegalArgumentException("Property list parsing failed while attempting to find closing */ to comment that began at " + this._savedIndexesAsString() + ".");
            }
            return (n += 2) < cArray.length ? n : -1;
        }

        private int _checkForWhitespaceOrComment(char[] cArray, int n) {
            if (n == -1 || n >= cArray.length) {
                return 1;
            }
            if (_Utilities._isWhitespace(cArray[n])) {
                return 2;
            }
            if (n + 1 < cArray.length) {
                if (cArray[n] == '/' && cArray[n + 1] == '/') {
                    return 3;
                }
                if (cArray[n] == '/' && cArray[n + 1] == '*') {
                    return 4;
                }
            }
            return 1;
        }

        private static final byte _nibbleForHexDigit(char c) {
            byte by = 0;
            if (c >= '0' && c <= '9') {
                by = (byte)(c - 48);
            } else if (c >= 'a' && c <= 'f') {
                by = (byte)(c - 97 + 10);
            } else if (c >= 'A' && c <= 'F') {
                by = (byte)(c - 65 + 10);
            } else {
                throw new IllegalArgumentException("Non-hex digit passed to _nibbleForHexDigit()");
            }
            return by;
        }

        private static final boolean _isHexDigit(char c) {
            return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
        }

        private static final boolean _isWhitespace(char c) {
            return c < '!' && (c == ' ' || c == '\t' || c == '\n' || c == '\r' || c == '\f');
        }

        private static char _nsToUnicode(int n) {
            return n >= 128 ? (char)NSToPrecompUnicodeTable[n - 128] : (char)n;
        }

        private _Utilities() {
        }

        static {
            NSToPrecompUnicodeTable = new int[]{160, 192, 193, 194, 195, 196, 197, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 217, 218, 219, 220, 221, 222, 181, 215, 247, 169, 161, 162, 163, 8260, 165, 402, 167, 164, 8217, 8220, 171, 8249, 8250, 64257, 64258, 174, 8211, 8224, 8225, 183, 166, 182, 8226, 8218, 8222, 8221, 187, 8230, 8240, 172, 191, 185, 715, 180, 710, 732, 175, 728, 729, 168, 178, 730, 184, 179, 733, 731, 711, 8212, 177, 188, 189, 190, 224, 225, 226, 227, 228, 229, 231, 232, 233, 234, 235, 236, 198, 237, 170, 238, 239, 240, 241, 321, 216, 338, 186, 242, 243, 244, 245, 246, 230, 249, 250, 251, 305, 252, 253, 322, 248, 339, 223, 254, 255, 65533, 65533};
        }
    }
}

