/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.woproject.ant;

import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.FileScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.PropertyHelper;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.PatternSet;
import org.objectstyle.woenvironment.env.WOVariables;
import org.objectstyle.woenvironment.frameworks.ExternalFolderFramework;
import org.objectstyle.woenvironment.frameworks.ExternalFolderRoot;
import org.objectstyle.woenvironment.frameworks.ExternalFrameworkModel;
import org.objectstyle.woenvironment.frameworks.FrameworkLibrary;
import org.objectstyle.woenvironment.frameworks.IFramework;
import org.objectstyle.woenvironment.frameworks.Root;
import org.objectstyle.woproject.ant.AntDependency;
import org.objectstyle.woproject.ant.AntDependencyOrdering;
import org.objectstyle.woproject.ant.FileUtil;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrameworkSet
extends FileSet {
    private Root<IFramework> root;
    private ExternalFrameworkModel frameworkModel;
    private boolean eclipse;
    private boolean embed;
    private boolean hasBundles;
    private boolean frameworkIncludesCreated;
    private File deploymentDir;
    private String ifCondition = "";

    public void setEclipse(boolean bl) {
        this.eclipse = bl;
    }

    public boolean getEclipse() {
        return this.eclipse;
    }

    public void setFrameworkModel(ExternalFrameworkModel externalFrameworkModel) {
        this.frameworkModel = externalFrameworkModel;
    }

    public ExternalFrameworkModel getFrameworkModel() {
        if (this.frameworkModel == null) {
            this.frameworkModel = new ExternalFrameworkModel(this.getProject().getProperties());
        }
        return this.frameworkModel;
    }

    public void setDeploymentDir(File file) {
        this.deploymentDir = file;
    }

    public void setBundles(String string) {
        String[] stringArray = string.split("/");
        PatternSet patternSet = this.createPatternSet();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (string2.trim().length() <= 0) continue;
            this.hasBundles = true;
            string2 = string2 + ".framework";
            patternSet.createInclude().setName(string2);
        }
    }

    protected File getDeployedFile(File file) {
        File file2 = file;
        if (this.deploymentDir != null && !this.getEmbed()) {
            String string = file.getPath();
            String string2 = this.deploymentDir.getPath();
            String string3 = string.replaceFirst("(.*?)(/\\w+\\.framework/)", string2 + "$2");
            file2 = new File(string3);
        }
        return file2;
    }

    protected void setFrameworkRoot(ExternalFolderRoot externalFolderRoot) {
        this.root = externalFolderRoot;
    }

    protected Root<IFramework> getFrameworkRoot() {
        if (this.root == null) {
            ExternalFrameworkModel externalFrameworkModel = this.getFrameworkModel();
            try {
                this.root = externalFrameworkModel.getRootForFolder(this.getDir());
            }
            catch (IOException iOException) {
                throw new BuildException("There was no matching framework root found for the folder '" + this.getDir() + "'.  The known framework roots are " + externalFrameworkModel.getRoots() + ".", (Throwable)iOException);
            }
        }
        return this.root;
    }

    public void setRoot(String string) throws BuildException {
        ExternalFrameworkModel externalFrameworkModel = this.getFrameworkModel();
        this.root = externalFrameworkModel.getRootWithShortName(string);
        if (this.root == null) {
            throw new BuildException("There is no root named '" + string + "' in " + externalFrameworkModel.getRoots() + ".");
        }
        File file = ((ExternalFolderRoot)this.root).getFrameworksFolder();
        this.setDir(file);
    }

    protected List<ExternalFolderFramework> getEclipseFrameworks() {
        try {
            LinkedList<ExternalFolderFramework> linkedList = new LinkedList<ExternalFolderFramework>();
            List<Node> list = FileUtil.getClasspathEntriesOfKind(this.getProject().getBaseDir(), "con");
            for (Node node : list) {
                Node node2 = node.getAttributes().getNamedItem("path");
                String string = node2.getTextContent();
                if (string == null || !string.startsWith("WOFramework/")) continue;
                int n = string.indexOf("/");
                String string2 = string.substring(n + 1);
                Object t = this.frameworkModel.getFrameworkWithName(string2);
                if (t == null) {
                    throw new BuildException("The framework name '" + string2 + "' does not exist.");
                }
                if (!(t instanceof ExternalFolderFramework) || t.getRoot() != this.root) continue;
                ExternalFolderFramework externalFolderFramework = (ExternalFolderFramework)t;
                linkedList.add(externalFolderFramework);
            }
            return linkedList;
        }
        catch (BuildException buildException) {
            throw buildException;
        }
        catch (Throwable throwable) {
            throw new BuildException("Failed to process eclipse frameworks: " + throwable.getMessage(), throwable);
        }
    }

    public synchronized void setupDirectoryScanner(FileScanner fileScanner, Project project) {
        if (this.eclipse && !this.frameworkIncludesCreated) {
            try {
                List<ExternalFolderFramework> list = this.getEclipseFrameworks();
                for (ExternalFolderFramework externalFolderFramework : list) {
                    PatternSet.NameEntry nameEntry = this.createInclude();
                    nameEntry.setName(externalFolderFramework.getFrameworkFolder().getName());
                }
                if (list.isEmpty()) {
                    PatternSet.NameEntry nameEntry = this.createInclude();
                }
                this.frameworkIncludesCreated = true;
            }
            catch (Throwable throwable) {
                throw new BuildException("Failed to process eclipse frameworks: " + throwable.getMessage(), throwable);
            }
        }
        super.setupDirectoryScanner(fileScanner, project);
    }

    public void setEmbed(boolean bl) {
        this.embed = bl;
    }

    public boolean getEmbed() {
        if (this.isReference() && this.getProject() != null) {
            return ((FrameworkSet)this.getRef(this.getProject())).getEmbed();
        }
        return this.embed;
    }

    public void setIf(String string) {
        this.ifCondition = string == null ? "" : string;
    }

    protected Path getJarsPath() {
        Object object;
        List<ExternalFolderFramework> list;
        Path path = new Path(this.getProject());
        if (this.getEclipse()) {
            list = this.getEclipseFrameworks();
        } else {
            String[] stringArray;
            list = new LinkedList<ExternalFolderFramework>();
            for (String string : stringArray = this.getDirectoryScanner(this.getProject()).getIncludedDirectories()) {
                object = ExternalFolderFramework.frameworkNameForFolder(new File(string));
                if (object != null) {
                    Object object2;
                    if (this.getDir() == null) {
                        object2 = this.getFrameworkModel().getFrameworkWithName((String)object);
                        if (!(object2 instanceof ExternalFolderFramework)) continue;
                        list.add((ExternalFolderFramework)object2);
                        continue;
                    }
                    object2 = new ExternalFolderFramework(this.getFrameworkRoot(), new File(this.getDir(), string));
                    list.add((ExternalFolderFramework)object2);
                    continue;
                }
                System.out.println("FrameworkSet.getJarsPath: ILLEGAL FRAMEWORK NAMED " + (String)object);
            }
        }
        for (ExternalFolderFramework externalFolderFramework : list) {
            if (!externalFolderFramework.getRoot().equals(this.getFrameworkRoot())) continue;
            for (FrameworkLibrary frameworkLibrary : externalFolderFramework.getFrameworkLibraries()) {
                File file = frameworkLibrary.getLibraryFile();
                object = this.getDeployedFile(file);
                path.setLocation((File)object);
            }
        }
        return path;
    }

    public static Path jarsPathForFrameworkSets(Project project, List<FrameworkSet> list, WOVariables wOVariables) {
        Object object;
        FrameworkSet frameworkSet2;
        LinkedList<AntDependency> linkedList = new LinkedList<AntDependency>();
        for (FrameworkSet frameworkSet2 : list) {
            object = frameworkSet2.getJarsPath();
            for (String string : object.list()) {
                linkedList.add(new AntDependency(frameworkSet2, string, wOVariables));
            }
        }
        List list2 = new AntDependencyOrdering().orderDependencies(linkedList);
        frameworkSet2 = new Path(project);
        object = list2.iterator();
        while (object.hasNext()) {
            AntDependency antDependency = (AntDependency)object.next();
            String string = antDependency.getJarPath();
            frameworkSet2.append(new Path(project, string));
        }
        return frameworkSet2;
    }

    public static String jarsPathForFrameworkSets(Project project, String string, List<FrameworkSet> list, WOVariables wOVariables) {
        LinkedList<AntDependency> linkedList = new LinkedList<AntDependency>();
        for (FrameworkSet object22 : list) {
            Path path = object22.getJarsPath();
            for (Object object2 : path.list()) {
                linkedList.add(new AntDependency(object22, (String)object2, wOVariables));
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        List list2 = new AntDependencyOrdering().orderDependencies(linkedList);
        for (Object object : list2) {
            Object object2;
            String string2 = ((AntDependency)object).getJarPath();
            String string3 = wOVariables.encodePath(string2);
            object2 = ((AntDependency)object).getFrameworkSet();
            if (((FrameworkSet)((Object)object2)).getEmbed()) {
                String string4 = object2.getDir(project).getAbsolutePath();
                string4 = wOVariables.encodePath(string4);
                string3 = super.hasBundles() ? string3.replaceFirst(".*?(\\w+.framework)", "APPROOT/" + string + "/$1") : string3.replaceFirst(string4, "APPROOT/" + string);
            }
            stringBuffer.append(string3).append(System.getProperty("line.separator"));
        }
        return stringBuffer.toString();
    }

    private boolean hasBundles() {
        return this.hasBundles;
    }

    public DirectoryScanner getDirectoryScanner(Project project) {
        if (this.getDir() == null || !this.getDir().exists()) {
            DirectoryScanner directoryScanner = new DirectoryScanner(){

                public synchronized String[] getIncludedDirectories() {
                    return new String[0];
                }

                public synchronized int getIncludedDirsCount() {
                    return 0;
                }

                public synchronized String[] getIncludedFiles() {
                    return new String[0];
                }

                public synchronized int getIncludedFilesCount() {
                    return 0;
                }
            };
            return directoryScanner;
        }
        return super.getDirectoryScanner(project);
    }

    private static String replaceProperties(Project project, String string, Hashtable hashtable) throws BuildException {
        PropertyHelper propertyHelper = PropertyHelper.getPropertyHelper((Project)project);
        return propertyHelper.replaceProperties(null, string, hashtable);
    }

    private boolean testIfCondition() {
        if ("".equals(this.ifCondition)) {
            return true;
        }
        String string = FrameworkSet.replaceProperties(this.getProject(), this.ifCondition, this.getProject().getProperties());
        return this.getProject().getProperty(string) != null;
    }

    public String toString() {
        return "[FrameworkSet: root = " + this.getDir() + "]";
    }
}

