/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.woproject.ant;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.FileSet;
import org.objectstyle.woproject.ant.FrameworkFormat;
import org.objectstyle.woproject.ant.WOTask;

public class WOFramework
extends WOTask {
    protected String eoAdaptorClassName;

    public void addLib(FileSet fileSet) {
        this.lib.addElement(fileSet);
    }

    public void execute() throws BuildException {
        this.validateAttributes();
        this.log("Installing " + this.name + " in " + this.destDir);
        this.createDirectories();
        if (this.hasClasses()) {
            this.jarClasses();
        }
        if (this.hasSources()) {
            this.jarSources();
        }
        if (this.hasLib()) {
            this.copyLibs();
        }
        if (this.hasResources()) {
            this.copyResources();
        }
        if (this.hasWs()) {
            this.copyWsresources();
        }
        new FrameworkFormat(this).processTemplates();
    }

    protected File taskDir() {
        return this.getProject().resolveFile(this.destDir + File.separator + this.name + ".framework");
    }

    protected File resourcesDir() {
        return new File(this.taskDir(), "Resources");
    }

    protected File wsresourcesDir() {
        return new File(this.taskDir(), "WebServerResources");
    }

    protected File wsresourcesDestDir() {
        File file = new File(this.webServerDir(), "WebObjects");
        File file2 = new File(file, "Frameworks");
        File file3 = new File(file2, this.name + ".framework");
        return new File(file3, "WebServerResources");
    }

    protected void cleanUp() {
        this.classes.clear();
        this.lib.clear();
        this.resources.clear();
        this.wsresources.clear();
        this.sources.clear();
    }

    public String getEOAdaptorClassName() {
        return this.eoAdaptorClassName;
    }

    public void setEOAdaptorClassName(String string) {
        this.eoAdaptorClassName = string;
    }
}

