/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.impl.fourstate;

import org.krysalis.barcode4j.BarcodeDimension;
import org.krysalis.barcode4j.HumanReadablePlacement;
import org.krysalis.barcode4j.TextAlignment;
import org.krysalis.barcode4j.impl.fourstate.AbstractFourStateBean;
import org.krysalis.barcode4j.impl.fourstate.FourStateLogicHandler;
import org.krysalis.barcode4j.impl.fourstate.USPSIntelligentMailLogicImpl;
import org.krysalis.barcode4j.output.Canvas;
import org.krysalis.barcode4j.output.CanvasProvider;
import org.krysalis.barcode4j.tools.UnitConv;

public class USPSIntelligentMailBean
extends AbstractFourStateBean {
    static final double DEFAULT_MODULE_WIDTH_INCH = 0.02;
    static final double DEFAULT_INTERCHAR_GAP_WIDTH_INCH = 0.025;
    static final double DEFAULT_HORZ_QUIET_ZONE_INCH = 0.125;
    static final double DEFAULT_VERT_QUIET_ZONE_INCH = 0.028;
    static final double DEFAULT_TRACK_HEIGHT_INCH = 0.05;
    static final double DEFAULT_ASCENDER_HEIGHT_INCH = 0.05;
    private Double quietZoneVertical;

    public USPSIntelligentMailBean() {
        this.setMsgPosition(HumanReadablePlacement.HRP_NONE);
        this.setModuleWidth(UnitConv.in2mm(0.02));
        this.setIntercharGapWidth(UnitConv.in2mm(0.025));
        this.setQuietZone(UnitConv.in2mm(0.125));
        this.setVerticalQuietZone(UnitConv.in2mm(0.028));
        this.setTrackHeight(UnitConv.in2mm(0.05));
        this.setAscenderHeight(UnitConv.in2mm(0.05));
    }

    public double getVerticalQuietZone() {
        if (this.quietZoneVertical != null) {
            return this.quietZoneVertical;
        }
        return this.getQuietZone();
    }

    public void setVerticalQuietZone(double height) {
        this.quietZoneVertical = new Double(height);
    }

    public void generateBarcode(CanvasProvider canvas, String msg) {
        if (msg == null || msg.length() == 0) {
            throw new NullPointerException("Parameter msg must not be empty");
        }
        FourStateLogicHandler handler = new FourStateLogicHandler(this, new Canvas(canvas));
        handler.setTextAlignment(TextAlignment.TA_LEFT);
        USPSIntelligentMailLogicImpl impl = new USPSIntelligentMailLogicImpl();
        impl.generateBarcodeLogic(handler, msg);
    }

    public BarcodeDimension calcDimensions(String msg) {
        int barCount = 65;
        double width = 65.0 * this.getModuleWidth() + 64.0 * this.getIntercharGapWidth();
        double qzh = this.hasQuietZone() ? this.getQuietZone() : 0.0;
        double qzv = this.hasQuietZone() ? this.getVerticalQuietZone() : 0.0;
        return new BarcodeDimension(width, this.getHeight(), width + 2.0 * qzh, this.getHeight() + 2.0 * qzv, qzh, qzv);
    }

    public void verifySettings() {
        if (this.getBarHeight() < UnitConv.in2mm(0.125)) {
            throw new IllegalArgumentException("Resulting bar height is smaller than 0.125in!");
        }
        if (this.getBarHeight() > UnitConv.in2mm(0.165)) {
            throw new IllegalArgumentException("Resulting bar height is larger than 0.165in!");
        }
        if (this.getModuleWidth() < UnitConv.in2mm(0.015)) {
            throw new IllegalArgumentException("Module width is smaller than 0.015in!");
        }
        if (this.getModuleWidth() > UnitConv.in2mm(0.025)) {
            throw new IllegalArgumentException("Module width is larger than 0.025in!");
        }
        if (this.getIntercharGapWidth() < UnitConv.in2mm(0.012)) {
            throw new IllegalArgumentException("Space between bars is smaller than 0.012in!");
        }
        if (this.getIntercharGapWidth() > UnitConv.in2mm(0.04)) {
            throw new IllegalArgumentException("Space between bars is larger than 0.040in!");
        }
        double pitch = UnitConv.mm2in(this.getModuleWidth() + this.getIntercharGapWidth());
        double barsPerInch = 1.0 / pitch;
        if (barsPerInch < 20.0) {
            throw new IllegalArgumentException("Resulting barcode pitch is smaller than 20 bars per inch!");
        }
        if (barsPerInch > 24.0) {
            throw new IllegalArgumentException("Resulting barcode pitch is larger than 24 bars per inch");
        }
    }
}

