/*
 * Decompiled with CFR 0.152.
 */
package javassist.gluonj.pc;

import javassist.gluonj.Pointcut;
import javassist.gluonj.WeaveException;
import javassist.gluonj.embedded.ClassPool;
import javassist.gluonj.embedded.CtBehavior;
import javassist.gluonj.embedded.CtClass;
import javassist.gluonj.embedded.CtMethod;
import javassist.gluonj.embedded.Modifier;
import javassist.gluonj.embedded.expr.Expr;
import javassist.gluonj.embedded.expr.FieldAccess;
import javassist.gluonj.embedded.expr.MethodCall;
import javassist.gluonj.util.SimplePcNode;
import javassist.gluonj.weave.NamePattern;
import javassist.gluonj.weave.Residue;

public class RefinePc
extends SimplePcNode {
    private String adviceName;
    private NamePattern clazz;
    private NamePattern member;
    private String desc;
    private int kind;
    private String clientType;
    public static final int CALL = 0;
    public static final int GET = 1;
    public static final int SET = 2;

    public static Pointcut make(RefinePc pc) {
        return Pct2.make(pc);
    }

    public RefinePc(String name, NamePattern c, NamePattern m, String d, int k, boolean withClient, CtMethod cm) throws WeaveException {
        this.adviceName = name;
        this.clazz = c;
        this.member = m;
        this.desc = d;
        this.kind = k;
        this.clientType = null;
        if (withClient) {
            this.withClientAdvice(d, cm);
        }
    }

    private void withClientAdvice(String descriptor, CtMethod cm) throws WeaveException {
        int i;
        if (descriptor.startsWith("(L") && (i = descriptor.indexOf(59)) > 0) {
            this.desc = "(" + descriptor.substring(i + 1);
            this.clientType = descriptor.substring(2, i).replace('/', '.');
            return;
        }
        throw new WeaveException("bad 1st parameter for @Client: " + cm.getLongName());
    }

    public String toString() {
        String s = "refine(" + this.clazz + ", " + this.member + ", ";
        if (this.kind == 0) {
            return s + this.desc + ")";
        }
        return s + (this.kind == 1 ? "get)" : "set)");
    }

    public String getAdvice() {
        return this.adviceName;
    }

    public boolean match(MethodCall mc, Residue[] residue) throws WeaveException {
        String methodName;
        String methodClassName;
        if (this.kind != 0) {
            return false;
        }
        CtClass enclosingClass = mc.getEnclosingClass();
        ClassPool cp = enclosingClass.getClassPool();
        if (this.desc.equals(mc.getSignature()) && this.clazz.match(methodClassName = mc.getClassName(), cp) && this.member.matchMember(methodName = mc.getMethodName(), cp) && this.matchClientType(mc)) {
            if (enclosingClass.getName().equals(methodClassName)) {
                CtBehavior w = mc.where();
                if (mc.where().getName().startsWith(methodName + "_") && this.desc.equals(w.getSignature())) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private boolean matchClientType(Expr expr) {
        if (this.clientType == null) {
            return true;
        }
        CtBehavior w = expr.where();
        return !Modifier.isStatic(w.getModifiers()) && w.getDeclaringClass().getName().equals(this.clientType);
    }

    public boolean match(FieldAccess fa, Residue[] residue) throws WeaveException {
        String fieldName;
        if (this.kind == 0) {
            return false;
        }
        if (fa.isReader() != (this.kind == 1)) {
            return false;
        }
        CtClass enclosingClass = fa.getEnclosingClass();
        ClassPool cp = enclosingClass.getClassPool();
        String fieldClassName = fa.getClassName();
        if (this.clazz.match(fieldClassName, cp) && this.member.matchMember(fieldName = fa.getFieldName(), cp) && this.matchClientType(fa)) {
            return !enclosingClass.getName().equals(fieldClassName) || !fa.where().getName().startsWith(fieldName + "_");
        }
        return false;
    }

    static class Pct2
    extends Pointcut {
        public Pct2() {
            super(null);
        }

        public static Pointcut make(RefinePc pc) {
            Pct2 pct = new Pct2();
            pct.setTree(pc);
            return pct;
        }
    }
}

