/*
 * Decompiled with CFR 0.152.
 */
package javassist.gluonj.weave;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.TreeMap;
import javassist.gluonj.After;
import javassist.gluonj.Around;
import javassist.gluonj.Aspect;
import javassist.gluonj.Before;
import javassist.gluonj.Glue;
import javassist.gluonj.Include;
import javassist.gluonj.Pointcut;
import javassist.gluonj.Refine;
import javassist.gluonj.WeaveException;
import javassist.gluonj.embedded.ClassPool;
import javassist.gluonj.embedded.CtClass;
import javassist.gluonj.embedded.CtField;
import javassist.gluonj.embedded.Modifier;
import javassist.gluonj.embedded.NotFoundException;
import javassist.gluonj.weave.Advice;
import javassist.gluonj.weave.Gluon;
import javassist.gluonj.weave.Weaver;

public class GluonMaker {
    public Gluon make(String className, ClassPool cp, ClassLoader cloader, Gluon root) throws NotFoundException, WeaveException {
        Gluon glue = new Gluon(className, cp);
        if (root == null) {
            root = glue;
        }
        CtClass clazz = this.getCtClass(cp, className);
        this.readOtherGlues(root, clazz, cloader);
        if (Gluon.stackTrace) {
            Weaver.logging("Aspect: " + className);
        }
        this.readRefine(glue, clazz);
        this.readPointcut(glue, clazz, cloader);
        return glue;
    }

    public CtClass getCtClass(ClassPool cp, String name) throws NotFoundException {
        while (true) {
            try {
                return cp.get(name);
            }
            catch (NotFoundException e) {
                int i = name.lastIndexOf(46);
                if (i < 0) {
                    throw e;
                }
                char[] str = name.toCharArray();
                str[i] = 36;
                name = new String(str);
                continue;
            }
            break;
        }
    }

    protected void readOtherGlues(Gluon root, CtClass clazz, ClassLoader cloader) throws NotFoundException, WeaveException {
        CtClass superClass = clazz.getSuperclass();
        if (superClass != null && !root.isIncluded(superClass.getName()) && GluonMaker.isGlue(superClass)) {
            root.include(this.make(superClass.getName(), clazz.getClassPool(), cloader, root));
        }
        TreeMap<String, String> children = new TreeMap<String, String>();
        CtField[] fields = clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            CtField f = fields[i];
            Object[] annoList = f.getAvailableAnnotations();
            for (int j = 0; j < annoList.length; ++j) {
                Object anno = annoList[j];
                if (!(anno instanceof Include)) continue;
                children.put(f.getName(), f.getType().getName());
            }
        }
        for (String glueName : children.values()) {
            if (root.isIncluded(glueName)) continue;
            root.include(this.make(glueName, clazz.getClassPool(), cloader, root));
        }
    }

    protected void readRefine(Gluon glue, CtClass clazz) throws NotFoundException, WeaveException {
        CtClass[] nested = clazz.getNestedClasses();
        for (int i = 0; i < nested.length; ++i) {
            CtClass cc = nested[i];
            Object[] anno = cc.getAvailableAnnotations();
            boolean notRefiner = true;
            for (int j = 0; j < anno.length; ++j) {
                if (!(anno[j] instanceof Refine)) continue;
                if (!Modifier.isStatic(cc.getModifiers())) {
                    throw new WeaveException("a refine class must be static.");
                }
                glue.refine(cc, anno);
                notRefiner = false;
                break;
            }
            if (!notRefiner) continue;
            glue.addHelper(cc.getName());
        }
    }

    public static boolean isRefine(CtClass clazz) {
        Object[] anno = clazz.getAvailableAnnotations();
        for (int j = 0; j < anno.length; ++j) {
            if (!(anno[j] instanceof Refine)) continue;
            return true;
        }
        return false;
    }

    public static boolean isGlue(CtClass clazz) {
        Object[] anno = clazz.getAvailableAnnotations();
        for (int j = 0; j < anno.length; ++j) {
            if (!(anno[j] instanceof Glue) && !(anno[j] instanceof Aspect)) continue;
            return true;
        }
        return false;
    }

    protected void readPointcut(Gluon glue, CtClass clazz, ClassLoader cloader) throws WeaveException, NotFoundException {
        Object obj = null;
        try {
            Class<?> gclass;
            try {
                String name = clazz.getName();
                gclass = cloader == null ? Class.forName(name) : cloader.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                gclass = clazz.toClass();
                clazz.defrost();
            }
            Constructor<?> cons = gclass.getDeclaredConstructor(new Class[0]);
            cons.setAccessible(true);
            obj = cons.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new WeaveException("cannot instantiate " + clazz.getName(), e);
        }
        CtField[] fields = clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            this.addOneAdvice(glue, clazz, obj, fields[i]);
        }
    }

    protected void addOneAdvice(Gluon glue, CtClass clazz, Object obj, CtField f) throws WeaveException, NotFoundException {
        Object[] annoList = f.getAvailableAnnotations();
        for (int j = 0; j < annoList.length; ++j) {
            Object anno = annoList[j];
            this.addOneAdvice(glue, clazz, obj, f, anno);
        }
    }

    protected Advice addOneAdvice(Gluon glue, CtClass clazz, Object obj, CtField f, Object anno) throws WeaveException, NotFoundException {
        String fieldName = f.getName();
        if (anno instanceof Before) {
            return glue.addAdvice(1, this.getPointcut(obj, fieldName), ((Before)anno).value());
        }
        if (anno instanceof After) {
            return glue.addAdvice(2, this.getPointcut(obj, fieldName), ((After)anno).value());
        }
        if (anno instanceof Around) {
            return glue.addAdvice(3, this.getPointcut(obj, fieldName), ((Around)anno).value());
        }
        if (!(anno instanceof Include)) {
            if (anno instanceof Refine) {
                glue.refine(clazz.getClassPool().get(f.getType().getName()), null);
            } else {
                return this.unknownAdvice(glue, this.getPointcut(obj, fieldName), anno);
            }
        }
        return null;
    }

    protected Advice unknownAdvice(Gluon g, Pointcut pc, Object annotation) throws WeaveException {
        throw new WeaveException("unknown advice");
    }

    protected Pointcut getPointcut(Object obj, String name) throws WeaveException {
        try {
            Field f = obj.getClass().getDeclaredField(name);
            f.setAccessible(true);
            try {
                return (Pointcut)f.get(obj);
            }
            catch (ClassCastException e) {
                throw new WeaveException("not Pointcut type" + f);
            }
        }
        catch (Exception e) {
            throw new WeaveException(e);
        }
    }
}

