/*
 * Decompiled with CFR 0.152.
 */
package javassist.gluonj.weave;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import javassist.gluonj.WeaveException;
import javassist.gluonj.weave.Gluon;
import javassist.gluonj.weave.Weaver;

public class HotSwapper {
    public static void premain(String args, Instrumentation inst) throws WeaveException {
        if ((args = HotSwapper.parseArgs(args)) == null || args.length() < 1) {
            HotSwapper.fatalError("no glue specified");
        }
        inst.addTransformer(new Transformer(args));
    }

    private static String parseArgs(String args) {
        if (args == null) {
            return null;
        }
        int end = args.indexOf(44);
        if (end >= 0) {
            String orig = args;
            args = args.substring(0, end);
            Gluon.stackTrace = orig.substring(end).equals(",debug");
        }
        return args.replace('/', '.');
    }

    private static void fatalError(String msg) {
        System.err.println("GluonJ Fatal Error: " + msg);
        System.err.println("** exit **");
        System.exit(1);
    }

    public static class Transformer
    implements ClassFileTransformer {
        private String glueName;
        private Weaver weaver;
        private boolean stop;

        public Transformer(String glue) {
            this.glueName = glue;
            this.weaver = null;
            this.stop = false;
        }

        public byte[] transform(ClassLoader loader, String className, Class classBeingRedefined, ProtectionDomain domain, byte[] classfile) throws IllegalClassFormatException {
            if (this.stop) {
                return null;
            }
            if (this.weaver == null) {
                if (Weaver.isNonTransformable(className.replace('/', '.'))) {
                    return null;
                }
                try {
                    this.weaver = new Weaver(this.glueName, loader, true);
                }
                catch (Throwable t) {
                    this.stop = true;
                    this.showError("cannot read a glue: " + this.glueName, t);
                    return null;
                }
            }
            try {
                return this.weaver.transform(className, classfile);
            }
            catch (Throwable t) {
                String msg = "cannot transform a class: " + className.replace('/', '.');
                this.showError(msg, t);
                return null;
            }
        }

        private void showError(String msg, Throwable e) {
            System.err.println("GluonJ Error: " + msg);
            System.err.println("  by " + e);
            if (Gluon.stackTrace) {
                e.printStackTrace(System.err);
            }
        }
    }
}

