/*
 * Decompiled with CFR 0.152.
 */
package javassist.gluonj.weave;

import javassist.gluonj.WeaveException;
import javassist.gluonj.embedded.expr.Expr;
import javassist.gluonj.pc.AndPc;
import javassist.gluonj.pc.CallPc;
import javassist.gluonj.pc.CflowPc;
import javassist.gluonj.pc.GetPc;
import javassist.gluonj.pc.IfPc;
import javassist.gluonj.pc.NotPc;
import javassist.gluonj.pc.OrPc;
import javassist.gluonj.pc.PointcutVisitor;
import javassist.gluonj.pc.SetPc;
import javassist.gluonj.pc.WithinPc;
import javassist.gluonj.plugin.MetaTag;
import javassist.gluonj.util.SimplePcNode;
import javassist.gluonj.weave.Residue;

public abstract class Matcher
implements PointcutVisitor {
    protected boolean result = false;
    protected Residue residue = null;

    public boolean getResult() {
        return this.result;
    }

    public Residue getResidue() {
        return this.residue;
    }

    public abstract Expr getJoinPoint();

    public void visit(AndPc node) throws WeaveException {
        this.residue = null;
        node.first().accept(this);
        if (this.result) {
            AndPc right = node.rest();
            if (right == null) {
                return;
            }
            Residue left = this.residue;
            this.residue = null;
            right.accept(this);
            if (this.result) {
                this.residue = Residue.and(left, this.residue);
                return;
            }
        }
        this.residue = null;
    }

    public void visit(OrPc node) throws WeaveException {
        this.residue = null;
        node.first().accept(this);
        boolean left = this.result;
        Residue leftR = this.residue;
        if (left && leftR == null) {
            return;
        }
        OrPc right = node.rest();
        if (right == null) {
            return;
        }
        this.residue = null;
        right.accept(this);
        if (!left && !this.result) {
            this.residue = null;
            return;
        }
        this.residue = Residue.or(leftR, this.residue);
        this.result = true;
    }

    public void visit(NotPc node) throws WeaveException {
        this.residue = null;
        node.getExpr().accept(this);
        if (this.result) {
            if (this.residue == null) {
                this.result = false;
            } else {
                this.residue = Residue.not(this.residue);
            }
        } else {
            this.result = true;
        }
    }

    public void visit(IfPc pc) throws WeaveException {
        this.residue = new Residue(pc.getExpr());
        this.result = true;
    }

    public void visit(CflowPc pc) throws WeaveException {
        this.residue = new Residue(pc.getExpr());
        this.result = true;
    }

    public void visit(WithinPc pc) throws WeaveException {
        this.result = false;
    }

    public void visit(CallPc pc) throws WeaveException {
        this.result = false;
    }

    public void visit(GetPc pc) throws WeaveException {
        this.result = false;
    }

    public void visit(SetPc pc) throws WeaveException {
        this.result = false;
    }

    public void visit(SimplePcNode pc) throws WeaveException {
        this.result = false;
    }

    public void visit(MetaTag.AnnotatePc pc) throws WeaveException {
        this.result = false;
    }
}

