/*
 * Decompiled with CFR 0.152.
 */
package javassist.gluonj.weave;

import javassist.gluonj.embedded.CannotCompileException;
import javassist.gluonj.embedded.CtMethod;
import javassist.gluonj.embedded.expr.Expr;
import javassist.gluonj.embedded.expr.ExprEditor;
import javassist.gluonj.embedded.expr.FieldAccess;
import javassist.gluonj.embedded.expr.MethodCall;
import javassist.gluonj.weave.Advice;
import javassist.gluonj.weave.AdviceWeaver;
import javassist.gluonj.weave.Gluon;
import javassist.gluonj.weave.Hook;

public class RefineAdvice
extends Advice {
    private String srcMethodName;
    private boolean isSet;
    private String adviceName;
    private boolean wildcard;
    private String methodName;
    private String paramList;

    public RefineAdvice(CtMethod src, boolean isSet, String adviceName, boolean wildcard, boolean withClient) {
        super(3);
        this.srcMethodName = Gluon.stackTrace ? src.getLongName() : null;
        this.isSet = isSet;
        this.adviceName = adviceName;
        this.wildcard = wildcard;
        this.methodName = null;
        this.paramList = withClient ? "(this,$$);}" : "($$);}";
    }

    public String getBody(Expr expr, Advice proceed) throws CannotCompileException {
        String method;
        method = proceed != null && (method = proceed.getMethodName()) != null ? method + "_" + this.adviceName : (this.wildcard ? this.getMemberName(expr) + "_" + this.adviceName : this.adviceName);
        this.methodName = method;
        if (this.isSet) {
            return "{ $0." + method + this.paramList;
        }
        return "{ $_ = $0." + method + this.paramList;
    }

    private String getMemberName(Expr expr) throws CannotCompileException {
        if (expr instanceof MethodCall) {
            return ((MethodCall)expr).getMethodName();
        }
        if (expr instanceof FieldAccess) {
            return ((FieldAccess)expr).getFieldName();
        }
        throw new CannotCompileException("bad expression: " + expr.where().toString());
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getMessage() {
        return "@Refine " + (this.srcMethodName == null ? this.adviceName : this.srcMethodName);
    }

    public String toString() {
        String method = this.wildcard ? "*_" + this.adviceName : this.adviceName;
        if (this.isSet) {
            return "{ $0." + method + this.paramList;
        }
        return "{ $_ = $0." + method + this.paramList;
    }

    public ExprEditor makeEditor(Hook.Iterator iterator, Expr expr) {
        if (expr instanceof MethodCall) {
            return new MethodCallEditor(iterator, (MethodCall)expr);
        }
        if (expr instanceof FieldAccess) {
            return new FieldAccessEditor(iterator, (FieldAccess)expr);
        }
        return null;
    }

    static class FieldAccessEditor
    extends ExprEditor {
        private Hook.Iterator advices;
        private Hook.Iterator allAdvices;
        private String className;
        private String fieldName;
        private String descriptor;

        public FieldAccessEditor(Hook.Iterator it, FieldAccess access) {
            this.advices = it;
            this.allAdvices = it.copy();
            this.className = access.getClassName();
            this.fieldName = access.getFieldName();
            this.descriptor = access.getSignature();
        }

        public void edit(MethodCall call) throws CannotCompileException {
            Advice adv;
            String cname = call.getClassName();
            String mname = call.getMethodName();
            Hook.Iterator it = this.allAdvices;
            Advice next = this.advices.lookAhead().getAdvice();
            it.first();
            while (it.hasNext() && (adv = ((Hook)it.next()).getAdvice()) != next) {
                if (!cname.equals(this.className) || !mname.equals(adv.getMethodName())) continue;
                AdviceWeaver.insertHook(this.advices.copy(), call, adv);
            }
        }

        public void edit(FieldAccess access) throws CannotCompileException {
            if (access.getClassName().equals(this.className) && access.getFieldName().equals(this.fieldName) && access.getSignature().equals(this.descriptor)) {
                AdviceWeaver.insertHook(this.advices.copy(), access, null);
            }
        }
    }

    static class MethodCallEditor
    extends ExprEditor {
        private Hook.Iterator advices;
        private Hook.Iterator allAdvices;
        private String className;
        private String methodName;
        private String descriptor;

        public MethodCallEditor(Hook.Iterator it, MethodCall call) {
            this.advices = it;
            this.allAdvices = it.copy();
            this.className = call.getClassName();
            this.methodName = call.getMethodName();
            this.descriptor = call.getSignature();
        }

        public void edit(MethodCall call) throws CannotCompileException {
            String cname = call.getClassName();
            String mname = call.getMethodName();
            String desc = call.getSignature();
            if (cname.equals(this.className) && mname.equals(this.methodName) && desc.equals(this.descriptor)) {
                AdviceWeaver.insertHook(this.advices.copy(), call, null);
            } else {
                Advice adv;
                Hook.Iterator it = this.allAdvices;
                Advice next = this.advices.lookAhead().getAdvice();
                it.first();
                while (it.hasNext() && (adv = ((Hook)it.next()).getAdvice()) != next) {
                    if (!cname.equals(this.className) || !mname.equals(adv.getMethodName())) continue;
                    AdviceWeaver.insertHook(this.advices.copy(), call, adv);
                }
            }
        }
    }
}

