/*
 * Decompiled with CFR 0.152.
 */
package javassist.gluonj.weave;

import java.util.ArrayList;
import java.util.HashMap;
import javassist.gluonj.WeaveException;
import javassist.gluonj.embedded.CannotCompileException;
import javassist.gluonj.embedded.CtClass;
import javassist.gluonj.embedded.CtField;
import javassist.gluonj.embedded.CtMember;
import javassist.gluonj.embedded.CtMethod;
import javassist.gluonj.embedded.NotFoundException;
import javassist.gluonj.weave.RefineWeaver;
import javassist.gluonj.weave.Refiner;

class RefineParam {
    HashMap targetMethods;
    CtMethod[] refineMethods;
    Object[][] annotations;
    ArrayList addedMethods;
    private HashMap superOfMethods;
    private HashMap superOfFields;
    RefineWeaver.CodeConverter2 refinerConv;
    HashMap otherAdvices;

    RefineParam(CtClass target, Refiner refiner, HashMap soFields) throws WeaveException, NotFoundException, CannotCompileException {
        HashMap hash = new HashMap();
        RefineParam.readMethods(target.getSuperclass().getMethods(), hash);
        RefineParam.readMethods(target.getDeclaredMethods(), hash);
        this.readParentMethods(refiner.parent, hash);
        this.targetMethods = hash;
        CtClass refinerClass = refiner.body;
        this.refineMethods = refinerClass.getDeclaredMethods();
        int len = this.refineMethods.length;
        this.annotations = new Object[len][];
        this.addedMethods = new ArrayList(len);
        this.superOfMethods = new HashMap();
        this.superOfFields = soFields;
        this.refinerConv = new RefineWeaver.CodeConverter2();
        this.otherAdvices = new HashMap();
    }

    private static void readMethods(CtMethod[] tMethods, HashMap hash) {
        for (CtMethod m : tMethods) {
            hash.put(m, new RefineWeaver.MethodDef(m));
        }
    }

    private void readParentMethods(Refiner r, HashMap hash) throws WeaveException, NotFoundException, CannotCompileException {
        if (r != null) {
            this.readParentMethods(r.parent, hash);
            CtMethod[] mths = r.body.getDeclaredMethods();
            for (int i = 0; i < mths.length; ++i) {
                CtMethod m = mths[i];
                RefineWeaver.MethodDef def = (RefineWeaver.MethodDef)hash.get(m);
                if (def == null) continue;
                def.overrider = m;
            }
        }
    }

    public void addMethod(CtMethod m) {
        this.addedMethods.add(m);
    }

    public Object putSuperOf(String overriderName, CtMethod superOf) {
        return this.superOfMethods.put(overriderName + ":" + superOf.getSignature(), superOf);
    }

    public CtMethod getSuperOf(CtMethod overrider) {
        return (CtMethod)this.superOfMethods.get(overrider.getName() + ":" + overrider.getSignature());
    }

    public CtMethod getSuperOf(CtMethod overrider, String descriptor) {
        return (CtMethod)this.superOfMethods.get(overrider.getName() + ":" + descriptor);
    }

    public static void putSuperOf(HashMap hash, String adviceName, CtField superOf) {
        hash.put(adviceName + ":" + superOf.getSignature(), superOf);
    }

    public CtField getSuperOf(String adviceName, CtField target) {
        return (CtField)this.superOfFields.get(adviceName + ":" + target.getSignature());
    }

    public AdviceBody getOtherAdvice(CtMember target) {
        return this.getOtherAdvice(target.getName(), target.getSignature());
    }

    public AdviceBody getOtherAdvice(String targetMethodName, String targetSignature) {
        String key = targetMethodName + ":" + targetSignature;
        return (AdviceBody)this.otherAdvices.get(key);
    }

    public void putOtherAdvice(CtMethod src, CtMember target, String adviceName, CtMethod adviceMethod, boolean withClient) {
        this.putOtherAdvice(src, target.getName(), target.getSignature(), adviceName, adviceMethod, withClient);
    }

    public void putOtherAdvice(CtMethod src, String targetMethodName, String targetSignature, String adviceName, CtMethod adviceMethod, boolean withClient) {
        String key = targetMethodName + ":" + targetSignature;
        AdviceBody value = (AdviceBody)this.otherAdvices.get(key);
        AdviceBody last = new AdviceBody(src, adviceName, adviceMethod, withClient);
        if (value == null) {
            this.otherAdvices.put(key, last);
        } else {
            value.append(last);
        }
    }

    public static class AdviceBodyList {
        AdviceBody newList = null;
        AdviceBody tail = null;

        AdviceBodyList() {
        }

        void append(AdviceBody a) {
            if (this.newList == null) {
                this.newList = this.tail = a;
            } else {
                this.tail.next = a;
                this.tail = a;
            }
        }

        void concat(AdviceBody head) {
            if (head != null && this.newList != null) {
                head.append(this.newList);
            }
        }
    }

    static class AdviceBody {
        AdviceBody next = null;
        CtMethod srcMethod;
        String name;
        CtMethod method;
        boolean withClient;

        AdviceBody(CtMethod src, String adviceName, CtMethod m, boolean client) {
            this.srcMethod = src;
            this.name = adviceName;
            this.method = m;
            this.withClient = client;
        }

        void append(AdviceBody last) {
            AdviceBody cur = this;
            while (cur.next != null) {
                cur = cur.next;
            }
            cur.next = last;
        }
    }
}

