/*
 * Decompiled with CFR 0.152.
 */
package javassist.gluonj.weave;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashMap;
import javassist.gluonj.WeaveException;
import javassist.gluonj.embedded.ClassPool;
import javassist.gluonj.embedded.CtClass;
import javassist.gluonj.embedded.CtMethod;
import javassist.gluonj.embedded.NotFoundException;
import javassist.gluonj.weave.NamePattern;

public class Refiner {
    public CtClass body;
    public String glueName;
    public boolean privileged;
    private NamePattern targetClass;
    public CtClass realTarget;
    public Refiner parent;
    private HashMap advices;
    private byte[] backup;

    public Refiner(CtClass refine, String glue, boolean privilege, String target) throws WeaveException {
        this.body = refine;
        this.glueName = glue;
        this.privileged = privilege;
        this.targetClass = target == null ? null : new NamePattern(target);
        this.advices = null;
        this.backup = null;
        this.realTarget = null;
        this.parent = null;
    }

    public boolean hasArgument() {
        return this.targetClass != null;
    }

    public String getTargetName() {
        if (this.targetClass != null && this.targetClass.isSingleMatch()) {
            return this.targetClass.getPattern();
        }
        return null;
    }

    public String getTargetPattern() {
        return this.targetClass.getPattern();
    }

    public void setAdvices(HashMap hash) {
        this.advices = hash;
    }

    public String getAdviceName(CtMethod m) {
        String key = Refiner.getAdviceKey(m);
        if (this.advices == null) {
            return null;
        }
        return (String)this.advices.get(key);
    }

    public static String getAdviceKey(CtMethod cm) {
        return cm.getName() + ":" + cm.getSignature();
    }

    public boolean matchArg(String className, ClassPool cp) {
        return this.targetClass != null && this.targetClass.match(className, cp);
    }

    public void saveBackup(byte[] b) {
        this.backup = b;
    }

    public void revert() throws WeaveException {
        ClassPool cp = this.body.getClassPool();
        String name = this.body.getName();
        this.body.detach();
        try {
            this.body = this.backup == null ? cp.get(name) : cp.makeClass(new ByteArrayInputStream(this.backup));
        }
        catch (NotFoundException e) {
            throw new WeaveException("lost a class file: " + name);
        }
        catch (IOException e) {
            throw new WeaveException("broken class file: " + name);
        }
    }
}

