/*
 * Decompiled with CFR 0.152.
 */
package javassist.gluonj.weave;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javassist.gluonj.WeaveException;
import javassist.gluonj.embedded.CannotCompileException;
import javassist.gluonj.embedded.ClassMap;
import javassist.gluonj.embedded.ClassPath;
import javassist.gluonj.embedded.ClassPool;
import javassist.gluonj.embedded.CtClass;
import javassist.gluonj.embedded.LoaderClassPath;
import javassist.gluonj.embedded.NotFoundException;
import javassist.gluonj.weave.AdviceWeaver;
import javassist.gluonj.weave.Gluon;
import javassist.gluonj.weave.GluonMaker;
import javassist.gluonj.weave.Inspector;
import javassist.gluonj.weave.RefineWeaver;
import javassist.gluonj.weave.Refiner;

public class Weaver {
    protected ClassPool srcPool;
    protected ClassPool refinedPool;
    protected RefineWeaver refineWeaver;
    protected AdviceWeaver adviceWeaver;
    protected Gluon glue;
    protected HashMap refineTargets;
    protected ArrayList regexRefiners;
    protected ClassMap refinerNames;
    public static final String CLASSPATH_PROPERTY = "javassist.gluonj.classpath";

    public static void logging(String msg) {
        System.err.print("(GluonJ) ");
        System.err.println(msg);
    }

    public Weaver(String glueName, ClassLoader loader, boolean useClasspath) throws WeaveException {
        this(glueName, Weaver.makeClassPool(loader, useClasspath), loader);
    }

    private static ClassPool makeClassPool(ClassLoader loader, boolean useClasspath) {
        String pathlist;
        ClassPool cp = new ClassPool(true);
        if (loader != null) {
            cp.insertClassPath(new LoaderClassPath(loader));
        }
        if ((pathlist = System.getProperty(CLASSPATH_PROPERTY)) != null) {
            try {
                cp.appendPathList(pathlist);
            }
            catch (NotFoundException e) {
                Weaver.logging("not found a jar file in javassist.gluonj.classpath: " + e.getMessage());
            }
        }
        return cp;
    }

    public Weaver(String glueName, ClassPool cp, ClassLoader loader) throws WeaveException {
        this.srcPool = cp;
        this.refinedPool = this.makePool();
        Gluon g = Gluon.make(glueName, cp, loader);
        this.initWeavers();
        this.glue = g;
        this.refineTargets = new HashMap();
        this.refinerNames = this.loadRefines(g);
    }

    public ClassPool getSource() {
        return this.srcPool;
    }

    public ClassPool getRefined() {
        return this.refinedPool;
    }

    protected void initWeavers() {
        this.refineWeaver = new RefineWeaver();
        this.adviceWeaver = new AdviceWeaver();
    }

    private ClassMap loadRefines(Gluon glue) throws WeaveException {
        ClassMap map = new ClassMap();
        HashMap<CtClass, Refiner> refiners = new HashMap<CtClass, Refiner>();
        ArrayList<Refiner> regexRefiners = new ArrayList<Refiner>();
        ClassPool pool = glue.getPool();
        Iterator iterator = glue.getRefiners();
        while (iterator.hasNext()) {
            String targetName;
            Refiner r = (Refiner)iterator.next();
            CtClass target = this.getRefineTarget(r);
            if (target == null) {
                this.addRegexRefine(r, pool);
                regexRefiners.add(r);
                targetName = r.getTargetPattern();
            } else {
                if (GluonMaker.isRefine(target)) {
                    Refiner parent = (Refiner)refiners.get(target);
                    if (parent == null) {
                        throw new WeaveException(target.getName() + " must be declared before " + r.body.getName());
                    }
                    r.parent = parent;
                    target = parent.realTarget;
                }
                targetName = target.getName();
                this.addRefine(targetName, r, regexRefiners, pool);
                String thisName = r.body.getName();
                map.put(thisName, targetName);
                r.realTarget = target;
                refiners.put(r.body, r);
            }
            this.refineWeaver.prepare(targetName, r, glue);
        }
        this.regexRefiners = regexRefiners;
        return map.isEmpty() ? null : map;
    }

    private CtClass getRefineTarget(Refiner ref) throws WeaveException {
        if (ref.hasArgument()) {
            try {
                String target = ref.getTargetName();
                if (target == null) {
                    return null;
                }
                return ref.body.getClassPool().get(target);
            }
            catch (NotFoundException e) {
                throw new WeaveException(e.getMessage());
            }
        }
        return this.refineWeaver.getTarget(ref.body);
    }

    private void addRefine(String target, Refiner refine, ArrayList regexRefiners, ClassPool pool) {
        LinkedList<Refiner> entry = this.findRefiners0(target);
        if (entry == null) {
            entry = new LinkedList<Refiner>();
            for (Refiner r : regexRefiners) {
                if (!r.matchArg(target, pool)) continue;
                entry.addLast(r);
            }
        }
        entry.addLast(refine);
        this.refineTargets.put(target, entry);
    }

    private void addRegexRefine(Refiner refine, ClassPool cp) {
        for (Map.Entry entry : this.refineTargets.entrySet()) {
            if (!refine.matchArg((String)entry.getKey(), cp)) continue;
            LinkedList value = (LinkedList)entry.getValue();
            value.addLast(refine);
        }
    }

    private LinkedList findRefiners0(String targetName) {
        String name;
        Object refines = this.refineTargets.get(targetName);
        if (refines == null && (name = targetName.replace('$', '.')) != targetName) {
            refines = this.refineTargets.get(name);
            targetName = name;
        }
        return (LinkedList)refines;
    }

    private LinkedList findRefiners(String targetName, ClassPool cp) {
        LinkedList<Refiner> list = this.findRefiners0(targetName);
        if (list == null) {
            for (Refiner r : this.regexRefiners) {
                if (!r.matchArg(targetName, cp)) continue;
                if (list == null) {
                    list = new LinkedList<Refiner>();
                }
                list.addLast(r);
            }
        }
        return list;
    }

    public Gluon getGlue() {
        return this.glue;
    }

    public CtClass transform(String className) throws WeaveException, NotFoundException {
        try {
            CtClass clazz = !Weaver.isNonTransformable(className) ? this.weaveAdvices(className) : this.srcPool.get(className);
            return clazz;
        }
        catch (CannotCompileException cce) {
            throw new WeaveException("cannot transform a class file: " + Weaver.toClassName(className), cce);
        }
    }

    public byte[] transform(String className, byte[] classFile) throws WeaveException {
        if (Weaver.isNonTransformable(className = Weaver.toClassName(className))) {
            return null;
        }
        try {
            CtClass original = this.srcPool.makeClass(new ByteArrayInputStream(classFile), false);
            className = original.getName();
            CtClass clazz = this.weaveAdvices(className);
            return clazz.toBytecode();
        }
        catch (IOException ie) {
            throw new WeaveException("cannot read a class file: " + className, ie);
        }
        catch (CannotCompileException cce) {
            throw new WeaveException("cannot transform a class file: " + className, cce);
        }
    }

    protected static boolean isNonTransformable(String className) {
        return className.startsWith("java.") || className.startsWith("javax.") || className.startsWith("com.sun.") || className.startsWith("sun.") || className.startsWith("sunw.");
    }

    private static String toClassName(String jvmName) {
        return jvmName.replace('/', '.');
    }

    protected CtClass weaveAdvices(String targetName) throws WeaveException, CannotCompileException {
        CtClass target;
        try {
            target = this.refinedPool.get(targetName);
        }
        catch (NotFoundException ne) {
            throw new WeaveException("cannot find: " + targetName);
        }
        try {
            if (!target.isFrozen()) {
                this.adviceWeaver.weave(target, this.glue);
                if (this.glue.isHelper(target.getName())) {
                    target.replaceClassName(this.refinerNames);
                }
            }
            return target;
        }
        catch (WeaveException e) {
            e.setWhere("While transforming " + targetName);
            throw e;
        }
    }

    protected void refineClass(CtClass target) throws WeaveException, CannotCompileException, NotFoundException {
        block3: {
            try {
                CtClass sup = target.getSuperclass();
                if (sup != null && !Weaver.isNonTransformable(sup.getName()) && !sup.isFrozen()) {
                    this.refineClass(sup);
                    sup.freeze();
                }
            }
            catch (NotFoundException e) {
                if (!Gluon.stackTrace) break block3;
                Weaver.logging("[warning] cannot find a class file: " + e.getMessage());
            }
        }
        this.refineClass0(target);
    }

    protected void refineClass0(CtClass target) throws WeaveException, CannotCompileException, NotFoundException {
        ClassMap names = this.refinerNames;
        this.runInspectors(target);
        LinkedList refiners = this.findRefiners(target.getName(), target.getClassPool());
        if (refiners == null) {
            return;
        }
        for (Refiner refiner : refiners) {
            this.refineWeaver.weave(target, refiner, names);
        }
    }

    protected void runInspectors(CtClass clazz) throws WeaveException {
        List inspectors = this.glue.getInspectors();
        if (inspectors == null) {
            return;
        }
        for (Inspector inspector : inspectors) {
            inspector.inspect(clazz);
        }
    }

    private ClassPool makePool() {
        ClassPool cp = new ClassPool();
        ClassPath path = new ClassPath(){

            public void close() {
            }

            public URL find(String classname) {
                URL url = Weaver.this.srcPool.find(classname);
                if (url == null) {
                    try {
                        Weaver.this.srcPool.get(classname);
                        url = new URL("file:memory");
                    }
                    catch (NotFoundException e) {
                        return null;
                    }
                    catch (MalformedURLException e) {
                        return null;
                    }
                }
                return url;
            }

            public InputStream openClassfile(String classname) throws NotFoundException {
                CtClass cc = Weaver.this.srcPool.get(classname);
                Exception err = null;
                try {
                    if (!Weaver.isNonTransformable(classname) && !cc.isFrozen()) {
                        Weaver.this.refineClass(cc);
                    }
                    byte[] file = cc.toBytecode();
                    return new ByteArrayInputStream(file);
                }
                catch (IOException ie) {
                    err = ie;
                }
                catch (CannotCompileException cce) {
                    err = cce;
                }
                catch (WeaveException we) {
                    err = we;
                }
                throw new NotFoundException(classname, err);
            }
        };
        cp.appendClassPath(path);
        return cp;
    }
}

