/*
 * Decompiled with CFR 0.152.
 */
package javassist.gluonj.weave;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javassist.gluonj.WeaveException;
import javassist.gluonj.embedded.CannotCompileException;
import javassist.gluonj.embedded.ClassMap;
import javassist.gluonj.embedded.ClassPool;
import javassist.gluonj.embedded.CtClass;
import javassist.gluonj.embedded.NotFoundException;
import javassist.gluonj.weave.AdviceWeaver;
import javassist.gluonj.weave.Gluon;
import javassist.gluonj.weave.Inspector;
import javassist.gluonj.weave.RefineWeaver;
import javassist.gluonj.weave.Refiner;

public class WeaverCore {
    private Gluon glue;
    protected ClassPool pool;
    protected RefineWeaver refineWeaver;
    protected AdviceWeaver adviceWeaver;
    protected HashMap refineTargets;
    protected ClassMap refinerNames;

    public WeaverCore(Gluon g) throws WeaveException {
        this.glue = g;
        this.pool = g.getPool();
        this.refineTargets = new HashMap();
        this.initWeavers();
        this.refinerNames = this.loadRefines();
    }

    protected void initWeavers() {
        this.refineWeaver = new RefineWeaver();
        this.adviceWeaver = new AdviceWeaver();
    }

    private ClassMap loadRefines() throws WeaveException {
        ClassMap map = new ClassMap();
        Iterator iterator = this.glue.getRefiners();
        while (iterator.hasNext()) {
            Refiner r = (Refiner)iterator.next();
            CtClass target = this.refineWeaver.getTarget(r.body);
            String targetName = target.getName();
            this.addRefine(targetName, r);
            map.put(r.body.getName(), targetName);
        }
        return map.isEmpty() ? null : map;
    }

    private void addRefine(String target, Refiner refine) {
        LinkedList<Refiner> entry = this.findRefiners(target, false);
        if (entry == null) {
            entry = new LinkedList<Refiner>();
        }
        entry.addLast(refine);
        this.refineTargets.put(target, entry);
    }

    private LinkedList findRefiners(String targetName, boolean delete) {
        String name;
        Object refines = this.refineTargets.get(targetName);
        if (refines == null && (name = targetName.replace('$', '.')) != targetName) {
            refines = this.refineTargets.get(name);
            targetName = name;
        }
        if (delete && refines != null) {
            this.refineTargets.remove(targetName);
        }
        return (LinkedList)refines;
    }

    protected ClassPool getClassPool() {
        return this.glue.getPool();
    }

    protected Gluon getGlue() {
        return this.glue;
    }

    public boolean transform(String targetName) throws WeaveException {
        return this.transform(targetName, true);
    }

    public boolean transform(String targetName, boolean inspect) throws WeaveException {
        try {
            return this.transform(targetName, this.findRefiners(targetName, true), inspect);
        }
        catch (WeaveException e) {
            e.setWhere("While transforming " + targetName);
            throw e;
        }
    }

    public void done() throws WeaveException {
        if (this.refineTargets.size() == 0) {
            return;
        }
        Iterator it = this.refineTargets.entrySet().iterator();
        StringBuffer sbuf = new StringBuffer("some refine classes were not used: ");
        boolean first = true;
        while (it.hasNext()) {
            LinkedList list = (LinkedList)it.next().getValue();
            Iterator it2 = list.iterator();
            while (it2.hasNext()) {
                if (first) {
                    first = false;
                } else {
                    sbuf.append(", ");
                }
                Refiner r = (Refiner)it2.next();
                sbuf.append(r.body.getName());
            }
        }
        throw new WeaveException(sbuf.toString());
    }

    protected boolean transform(String targetName, LinkedList refines, boolean inspect) throws WeaveException {
        try {
            CtClass target = this.pool.get(targetName);
            if (inspect) {
                this.runInspectors(target, this.glue.getInspectors());
            }
            boolean modify = this.refineClass(this.refineWeaver, target, refines);
            boolean modify2 = this.weaveAdvices(target);
            boolean result = modify || modify2;
            this.save(target, result);
            return result;
        }
        catch (IOException ioe) {
            throw new WeaveException(ioe);
        }
        catch (CannotCompileException cce) {
            throw new WeaveException(cce);
        }
        catch (NotFoundException nfe) {
            throw new WeaveException(nfe);
        }
    }

    protected void runInspectors(CtClass clazz, List inspectors) throws WeaveException {
        if (inspectors == null) {
            return;
        }
        for (Inspector inspector : inspectors) {
            inspector.inspect(clazz);
        }
    }

    protected boolean refineClass(RefineWeaver rw, CtClass target, LinkedList refines) throws WeaveException, NotFoundException, CannotCompileException {
        if (refines == null) {
            return false;
        }
        boolean modified = false;
        for (Refiner refiner : refines) {
            CtClass refinerClass = refiner.body;
            rw.weave(target, refiner, this.refinerNames);
            refinerClass.detach();
            modified = true;
        }
        return modified;
    }

    protected boolean weaveAdvices(CtClass target) throws WeaveException, CannotCompileException {
        boolean result = this.adviceWeaver.weave(target, this.glue);
        if (this.glue.isHelper(target.getName())) {
            target.replaceClassName(this.refinerNames);
            result = result ? true : target.isModified();
        }
        return result;
    }

    protected void save(CtClass clazz, boolean modify) throws CannotCompileException, IOException {
    }
}

