package er.restexample.server;
// Generated by the WOLips Templateengine Plug-in at 04.03.2009 23:02:26

import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;

import er.directtorest.ERD2RestDelegate;
import er.extensions.appserver.ERXApplication;
import er.extensions.eof.ERXEC;
import er.rest.entityDelegates.ERXDefaultRestDelegate;
import er.rest.entityDelegates.ERXRestContext;
import er.rest.entityDelegates.ERXRestRequestHandler;
import er.rest.entityDelegates.ERXXmlRestResponseWriter;
import er.rest.entityDelegates.IERXRestAuthenticationDelegate;
import er.rest.format.ERXXmlRestParser;

public class Application extends ERXApplication {
    public static void main(String argv[]) {
        ERXApplication.main(argv, Application.class);
    }

    public static class DataCreator {

        EOEditingContext ec;

        NSMutableArray<ServerUser> users = new NSMutableArray<ServerUser>();

        NSMutableArray<ServerForum> forums = new NSMutableArray<ServerForum>();

        NSMutableArray<ServerTopic> topics = new NSMutableArray<ServerTopic>();

        public void run(EOEditingContext value) {
            ec = value;
            createUsers();
            createForums();
        }

        private void createTopics(ServerForum forum) {
            for (int i = 0; i < 10; i++) {
                ServerTopic object = ServerTopic.createServerTopic(ec, "Topic-" + i, forum, users.objectAtIndex(i));
                topics.addObject(object);
                for(int j = 0; j < users.count(); j++) {
                    if(j % 5 == 0) {
                        ServerUser user = users.objectAtIndex(j);
                        createPost(user, object);
                    }
                }
            }
        }

        private void createPost(ServerUser user, ServerTopic topic) {
            ServerPost object = ServerPost.createServerPost(ec, topic.forum(), topic, user);
            object.setTitle("Post-" + user.hashCode() + "-" + topic.hashCode());
        }

        private void createForums() {
            for (int i = 0; i < 10; i++) {
                ServerForum object = ServerForum.createServerForum(ec, "Forum-" + i);
                forums.addObject(object);
                createTopics(object);
            }
        }

        private void createUsers() {
            for (int i = 0; i < 10; i++) {
                ServerUser object = ServerUser.createServerUser(ec, "User-" + i);
                users.addObject(object);
            }
        }
    }

    public Application() {
        NSLog.out.appendln("Welcome to " + this.name() + " !");
        EOEditingContext ec = ERXEC.newEditingContext();
        new DataCreator().run(ec);
        ec.saveChanges();
        
        ERXDefaultRestDelegate restDelegate = new ERD2RestDelegate();

        IERXRestAuthenticationDelegate authenticationDelegate = new IERXRestAuthenticationDelegate() {

            public boolean authenticate(ERXRestContext context) {
                return context.context().hasSession() && ((Session)context.context().session()).isLoggedIn() || true;
            }
            
        };
        //registerRequestHandler(new ERXRestRequestHandler(authenticationDelegate, restDelegate, new ERXJSONRestResponseWriter(), new ERXXmlRestRequestParser()), "json");
        //registerRequestHandler(new ERXRestRequestHandler(authenticationDelegate, restDelegate, new ERXXmlRestResponseWriter(), new ERXXmlRestRequestParser()), "rest");
        registerRequestHandler(new ERXRestRequestHandler(authenticationDelegate, restDelegate, new ERXXmlRestResponseWriter(), new ERXXmlRestParser()), "rest");

    }
}