package er.openid;

// Generated by the WOLips Templateengine Plug-in at Apr 22, 2007 9:09:53 AM

import java.util.Iterator;
import java.util.Map;

import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSMutableDictionary;

/**
 * EROFormRedirectionPage represents a page which automatically fills out a form and redirects to
 * the OpenID Provider (OP). This page is OpenID 2.0 compatible in that by using a form it allows
 * data longer than 255 characters (in contrast to putting all of the arguments in the URL as it
 * was done in OpenID 1.0.
 * 
 * @author mschrag
 */
public class EROFormRedirectionPage extends WOComponent implements IEROFormRedirectionPage {
  private String _redirectionUrl;
  private NSMutableDictionary _formParams;
  public Object repetitionFormKey;

  public EROFormRedirectionPage(WOContext context) {
    super(context);
    _formParams = new NSMutableDictionary();
  }

  public void setParameters(Map parameters) {
    Iterator parametersEnum = parameters.keySet().iterator();
    while (parametersEnum.hasNext()) {
      String formValueKey = (String)parametersEnum.next();
      String formValue = (String)parameters.get(formValueKey);
      _formParams.setObjectForKey(formValue, formValueKey);
      EROpenIDManager.log.debug(formValueKey + " => " + formValue);
    }
  }

  public NSArray repetitionFormList() {
    return _formParams.allKeys();
  }

  public String formValue() {
    return (String)_formParams.objectForKey(repetitionFormKey);
  }

  public void setRedirectionUrl(String redirectionUrl) {
    _redirectionUrl = redirectionUrl;
  }

  public String redirectionUrl() {
    return _redirectionUrl;
  }
}
