/*
 * Copyright (c) 2007 Design Maximum - http://www.designmaximum.com
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * 
 */

package er.selenium.filters;

import java.util.Formatter;

import org.apache.log4j.Logger;

import com.webobjects.foundation.NSMutableArray;

import er.selenium.SeleniumTest;
import er.selenium.SeleniumTest.Element;

public class SeleniumOverrideOpenTestFilter extends SeleniumTestFilterHelper implements SeleniumTestFilter {
	private static final Logger log = Logger.getLogger(SeleniumOverrideOpenTestFilter.class);
	private static final String TEMP_VAR_PREFIX = "__overrideOpenTmp";
	
	protected String _openPrefix;
	
	public SeleniumOverrideOpenTestFilter(String openPrefix) {
		_openPrefix = openPrefix;
	}
	
	protected int processOpenCommand(SeleniumTest.Command command, NSMutableArray<SeleniumTest.Element> elements, int index) {
		String target = command.getTarget().trim();
		if (target.startsWith("javascript") || target.matches(".*\\$\\{.*\\}.*")) {
			/* Arbitrary substitutions are possible - we should insert javascript expression */
			String varName = TEMP_VAR_PREFIX + index;
			Formatter fmt = new Formatter();
			fmt.format("javascript{if (storedVars['%1$s'].trim().startsWith('http://') || storedVars['%1$s'].trim().startsWith('https://')) {storedVars['%1$s']} else {'%2$s' + storedVars['%1$s']}}", varName, _openPrefix);
			SeleniumTest.Command newOpenCommand = new SeleniumTest.Command(command.getName(), fmt.toString(), command.getValue());
			command.setName("storeExpression");
			command.setValue(varName);
			elements.insertObjectAtIndex(newOpenCommand, index + 1);
			return 1;
		} else {
			/* Simple typed-in immutable url */
			if (!(target.startsWith("http://") || target.startsWith("https://"))) {
				command.setTarget(_openPrefix + target);
			}
			return 0;
		}
	}
	
	// @Override
	protected void processTestElements(NSMutableArray<Element> elements) {
		int i = 0;
		while (i < elements.count()) {
			if (elements.get(i) instanceof SeleniumTest.Command) {
				SeleniumTest.Command command = (SeleniumTest.Command)elements.get(i);
				if (command.getName().startsWith("open")) {
					i += processOpenCommand(command, elements, i);
				}
			}
			++i;
		}
	}
}