/*
 * Decompiled with CFR 0.152.
 */
package er.woinstaller;

import java.io.File;
import java.io.IOException;

public class WebObjectsInstallation {
    private static final String osName = System.getProperty("os.name");
    private File _destinationFolder;
    private File _localLibrariesFolder;
    private File _systemLibrariesFolder;

    public static boolean isOSX() {
        return osName.toLowerCase().indexOf("os x") != -1;
    }

    public static boolean isWindows() {
        return osName.toLowerCase().indexOf("windows") != -1;
    }

    public WebObjectsInstallation(File file) throws IOException {
        this._destinationFolder = file;
        this._localLibrariesFolder = new File(this._destinationFolder, "Library");
        this._systemLibrariesFolder = new File(new File(this._destinationFolder, "System"), "Library");
        if (!WebObjectsInstallation.isOSX()) {
            this.renameFolders();
        }
    }

    public File getLocalLibrariesFolder() {
        return this._localLibrariesFolder;
    }

    public File getSystemLibrariesFolder() {
        return this._systemLibrariesFolder;
    }

    public void renameFolders() throws IOException {
        File file = new File(this._destinationFolder, "Local");
        if (file.exists()) {
            throw new IOException("The folder '" + file + "' already exists.");
        }
        if (!file.mkdirs()) {
            throw new IOException("Failed to create the directory '" + file + "'.");
        }
        File file2 = new File(file, "Library");
        if (!this._localLibrariesFolder.renameTo(file2)) {
            throw new IOException("Failed to move '" + this._localLibrariesFolder + "' to '" + file2 + "'.");
        }
        this._localLibrariesFolder = file2;
        File file3 = new File(this._destinationFolder, "Library");
        if (file3.exists()) {
            throw new IOException("The folder '" + file3 + "' already exists.");
        }
        if (!this._systemLibrariesFolder.renameTo(file3)) {
            throw new IOException("Failed to move '" + this._systemLibrariesFolder + "' to '" + file3 + "'.");
        }
        this._systemLibrariesFolder = file3;
        if (!this._systemLibrariesFolder.getParentFile().delete()) {
            throw new IOException("Failed to delete '" + this._systemLibrariesFolder.getParentFile() + ".");
        }
        System.out.println("Done");
    }
}

