/*
 * Decompiled with CFR 0.152.
 */
package er.woinstaller;

import er.woinstaller.WebObjectsInstallation;
import er.woinstaller.archiver.CPIO;
import er.woinstaller.archiver.XarFile;
import er.woinstaller.io.BlockEntry;
import er.woinstaller.io.MultiBlockInputStream;
import er.woinstaller.ui.IWOInstallerProgressMonitor;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;

public abstract class WebObjectsInstaller {
    private static URI WO533_URI;
    private static URI WO533DEV_URI;
    private static URI WO543_URI;
    private static URI WO543DEV_URI;
    protected List<BlockEntry> blockList = new ArrayList<BlockEntry>();
    protected long fileLength;
    protected long rawLength;
    protected URI woDmgUri;
    protected int woVersion;

    public static WebObjectsInstaller newInstaller(String string) {
        WebObjectsInstaller webObjectsInstaller;
        if ("5.3.3".equals(string)) {
            webObjectsInstaller = WebObjectsInstaller.wo533Installer();
        } else if ("5.4.3".equals(string)) {
            webObjectsInstaller = WebObjectsInstaller.wo543Installer();
        } else if ("dev53".equals(string)) {
            webObjectsInstaller = WebObjectsInstaller.wo533Installer();
            webObjectsInstaller.woDmgUri = WO533DEV_URI;
        } else if ("dev54".equals(string)) {
            webObjectsInstaller = WebObjectsInstaller.wo543Installer();
            webObjectsInstaller.woDmgUri = WO543DEV_URI;
        } else {
            throw new IllegalArgumentException("Unknown WebObjects version '" + string + "'.");
        }
        return webObjectsInstaller;
    }

    private static WebObjectsInstaller wo533Installer() {
        return new WebObjectsInstaller(){
            {
                BlockEntry blockEntry = new BlockEntry();
                blockEntry.offset = 11608064L;
                blockEntry.length = 29672581L;
                this.blockList.add(blockEntry);
                this.rawLength = 51252394L;
                this.woVersion = 53;
                this.fileLength = 42321716L;
                this.woDmgUri = WO533_URI;
            }
        };
    }

    private static WebObjectsInstaller wo543Installer() {
        return new WebObjectsInstaller(){
            {
                BlockEntry blockEntry = new BlockEntry();
                blockEntry.offset = 58556928L;
                blockEntry.length = 107601091L;
                this.blockList.add(blockEntry);
                this.rawLength = 153786259L;
                this.woVersion = 54;
                this.fileLength = 166167249L;
                this.woDmgUri = WO543_URI;
            }
        };
    }

    public WebObjectsInstallation installToFolder(File file, IWOInstallerProgressMonitor iWOInstallerProgressMonitor) throws IOException, InterruptedException {
        if (file.exists()) {
            if (!file.canWrite()) {
                throw new IOException("You do not have permission to write to the folder '" + file + "'.");
            }
        } else if (!file.mkdirs()) {
            throw new IOException("Failed to create the directory '" + file + "'.");
        }
        CPIO cPIO = new CPIO(this.getInputStream(iWOInstallerProgressMonitor));
        cPIO.setLength(this.getLength());
        cPIO.extractTo(file, !WebObjectsInstallation.isWindows(), iWOInstallerProgressMonitor);
        WebObjectsInstallation webObjectsInstallation = new WebObjectsInstallation(file);
        iWOInstallerProgressMonitor.done();
        return webObjectsInstallation;
    }

    protected InputStream getInputStream(IWOInstallerProgressMonitor iWOInstallerProgressMonitor) throws IOException {
        InputStream inputStream;
        File file = null;
        BufferedInputStream bufferedInputStream = null;
        if ("file".equals(this.woDmgUri.getScheme())) {
            file = new File(this.woDmgUri);
            if (!file.exists()) {
                throw new IllegalStateException("The file " + file.getName() + " was not found");
            }
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        } else {
            bufferedInputStream = new BufferedInputStream(this.urlToInputStream(this.woDmgUri.toURL()));
        }
        if (this.woVersion == 53) {
            inputStream = new MultiBlockInputStream(bufferedInputStream, this.blockList);
        } else {
            MultiBlockInputStream multiBlockInputStream = new MultiBlockInputStream(bufferedInputStream, this.blockList);
            XarFile xarFile = new XarFile(multiBlockInputStream);
            inputStream = xarFile.getInputStream("Payload");
        }
        return new GZIPInputStream(inputStream);
    }

    private InputStream urlToInputStream(URL uRL) {
        HttpURLConnection httpURLConnection = null;
        try {
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setConnectTimeout(15000);
            httpURLConnection.setReadTimeout(15000);
            httpURLConnection.connect();
            int n = httpURLConnection.getResponseCode();
            if (n < 400 && n > 299) {
                String string = httpURLConnection.getHeaderField("Location");
                try {
                    URL uRL2 = new URL(string);
                    return this.urlToInputStream(uRL2);
                }
                catch (MalformedURLException malformedURLException) {
                    URL uRL3 = new URL(uRL.getProtocol() + "://" + uRL.getHost() + string);
                    return this.urlToInputStream(uRL3);
                }
            }
            return httpURLConnection.getInputStream();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    protected long getLength() {
        return this.rawLength;
    }

    static {
        try {
            WO533_URI = new URI("https://download.info.apple.com/Apple_Support_Area/Apple_Software_Updates/Mac_OS_X/downloads/061-2998.20070215.33woU/WebObjects5.3.3Update.dmg");
            WO543_URI = new URI("https://download.info.apple.com/Apple_Support_Area/Apple_Software_Updates/Mac_OS_X/downloads/061-4634.20080915.3ijd0/WebObjects543.dmg");
            WO533DEV_URI = new File("WebObjects533.dmg").toURI();
            WO543DEV_URI = new File("WebObjects543.dmg").toURI();
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
        }
    }
}

