/*
 * Decompiled with CFR 0.152.
 */
package er.woinstaller.archiver;

import er.woinstaller.io.BoundedInputStream;
import er.woinstaller.io.FileUtilities;
import er.woinstaller.ui.IWOInstallerProgressMonitor;
import er.woinstaller.ui.NullProgressMonitor;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;

public class CPIO {
    public static final int S_IFDIR = 16384;
    public static final int S_IFREG = 32768;
    public static final int S_IFLNK = 40960;
    private File _cpioFile;
    InputStream paxStream;
    long fileLength = 0L;

    public CPIO(File file) throws FileNotFoundException {
        this(new BufferedInputStream(new FileInputStream(file)));
        this._cpioFile = file;
        this.fileLength = this._cpioFile.length();
    }

    public CPIO(InputStream inputStream) {
        this.paxStream = inputStream;
    }

    public void setLength(long l) {
        this.fileLength = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extractTo(File file, boolean bl, IWOInstallerProgressMonitor iWOInstallerProgressMonitor) throws IOException, InterruptedException {
        Object object;
        iWOInstallerProgressMonitor.beginTask("Extracting WebObjects ...", this.fileLength);
        long l = 0L;
        LinkedList<Link> linkedList = new LinkedList<Link>();
        try {
            byte[] byArray = new byte[6];
            object = new byte[11];
            boolean bl2 = false;
            do {
                String string;
                if (!"070707".equals(string = this.readString(this.paxStream, byArray))) {
                    throw new IOException("Expected magic '070707' but got '" + string + "' (next = " + this.readString(this.paxStream, new byte[50]) + ").");
                }
                String string2 = this.readString(this.paxStream, byArray);
                String string3 = this.readString(this.paxStream, byArray);
                String string4 = this.readString(this.paxStream, byArray);
                String string5 = this.readString(this.paxStream, byArray);
                String string6 = this.readString(this.paxStream, byArray);
                String string7 = this.readString(this.paxStream, byArray);
                String string8 = this.readString(this.paxStream, byArray);
                String string9 = this.readString(this.paxStream, (byte[])object);
                String string10 = this.readString(this.paxStream, byArray);
                String string11 = this.readString(this.paxStream, (byte[])object);
                int n = Integer.parseInt(string10, 8);
                String string12 = this.readString(this.paxStream, new byte[n]);
                int n2 = Integer.parseInt(string11, 8);
                if ("TRAILER!!!".equals(string12)) {
                    bl2 = true;
                } else {
                    Object object2;
                    File file2 = this.toFile(file, string12);
                    int n3 = Integer.parseInt(string4, 8);
                    if ((n3 & 0x4000) == 16384) {
                        if (!".".equals(string12)) {
                            if (file2.exists()) {
                                throw new IOException("The directory '" + file2 + "' already exists.");
                            }
                            if (!file2.mkdirs()) {
                                throw new IOException("Failed to create directory '" + file2 + "'.");
                            }
                        }
                        this.skipFully(this.paxStream, n2);
                    } else if ((n3 & 0xA000) == 40960) {
                        String string13 = this.readString(this.paxStream, new byte[n2]);
                        object2 = new File(string13);
                        if (!bl) {
                            object2 = this.toFile(file2.getParentFile(), string13);
                        }
                        linkedList.add(new Link((File)object2, file2));
                    } else if ((n3 & 0x8000) == 32768) {
                        if (file2.exists()) {
                            throw new IOException("The file '" + file2 + "' already exists.");
                        }
                        BoundedInputStream boundedInputStream = new BoundedInputStream(this.paxStream, 0L, n2);
                        object2 = new FileOutputStream(file2);
                        FileUtilities.writeInputStreamToOutputStream(boundedInputStream, (OutputStream)object2, n2, new NullProgressMonitor());
                    } else {
                        throw new IOException("Unknown mode " + string4 + " for " + string12 + ".");
                    }
                    int n4 = 70 + n + n2;
                    iWOInstallerProgressMonitor.worked(l += (long)n4);
                }
                if (!iWOInstallerProgressMonitor.isCanceled()) continue;
                throw new IOException("Operation canceled.");
            } while (!bl2);
        }
        finally {
            this.paxStream.close();
        }
        iWOInstallerProgressMonitor.done();
        iWOInstallerProgressMonitor.beginTask("Linking WebObjects ...", linkedList.size());
        Collections.sort(linkedList, new LinkNameLengthComparator());
        int n = 0;
        object = linkedList.iterator();
        while (object.hasNext()) {
            Link link = (Link)object.next();
            link.create(bl);
            iWOInstallerProgressMonitor.worked(n++);
        }
    }

    protected File toFile(File file, String string) {
        String string2 = string.replaceFirst("^\\./", "");
        File file2 = new File(string2 = string2.replace("/", File.separator));
        if (!file2.isAbsolute()) {
            file2 = new File(file, string2);
        }
        return file2;
    }

    protected String readString(InputStream inputStream, byte[] byArray) throws IOException {
        int n;
        this.readFully(inputStream, byArray);
        for (n = byArray.length - 1; n >= 0 && byArray[n] == 0; --n) {
        }
        return new String(byArray, 0, n + 1);
    }

    protected byte[] readFully(InputStream inputStream, byte[] byArray) throws IOException {
        return this.readFully(inputStream, byArray, 0, byArray.length);
    }

    protected byte[] readFully(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        int n3;
        for (int i = 0; i < n2; i += n3) {
            n3 = inputStream.read(byArray, n + i, n2 - i);
            if (n3 != -1) continue;
            throw new IOException("Stream ended before " + n2 + " bytes (read " + i + ")");
        }
        return byArray;
    }

    protected void skipFully(InputStream inputStream, long l) throws IOException {
        for (long i = l; i > 0L; i -= inputStream.skip(i)) {
        }
    }

    protected static class LinkNameLengthComparator
    implements Comparator<Link>,
    Serializable {
        protected LinkNameLengthComparator() {
        }

        @Override
        public int compare(Link link, Link link2) {
            int n;
            int n2 = link.getRealFile().toString().length();
            int n3 = n2 > (n = link2.getRealFile().toString().length()) ? 1 : (n2 < n ? -1 : 0);
            return n3;
        }
    }

    protected static class Link {
        private File _realFile;
        private File _linkFile;

        public Link(File file, File file2) {
            this._realFile = file;
            this._linkFile = file2;
        }

        public Link(String string, String string2) {
            this._realFile = new File(string);
            this._linkFile = new File(string2);
        }

        public File getRealFile() {
            return this._realFile;
        }

        public File getLinkFile() {
            return this._linkFile;
        }

        public void create(boolean bl) throws IOException, InterruptedException {
            if (bl) {
                Process process = Runtime.getRuntime().exec(new String[]{"/bin/ln", "-s", this._realFile.getPath(), this._linkFile.getCanonicalPath()});
                int n = process.waitFor();
                if (n != 0) {
                    throw new IOException("Failed to create link from " + this._realFile + " to " + this._linkFile);
                }
            } else {
                try {
                    this.copyFileToFile(this._realFile, this._linkFile);
                }
                catch (IOException iOException) {
                    System.err.println(iOException.getMessage());
                }
            }
        }

        protected void copyFileToFile(File file, File file2) throws IOException {
            if (!file.exists()) {
                throw new IOException("The file '" + file + "' does not exist (tried to link to '" + file2 + "').");
            }
            if (file2.exists()) {
                throw new IOException("The file '" + file2 + "' already exists.");
            }
            if (file.isDirectory()) {
                if (!file2.mkdirs()) {
                    throw new IOException("Failed to create the directory '" + file2 + "'.");
                }
                for (File file3 : file.listFiles()) {
                    this.copyFileToFile(file3, new File(file2, file3.getName()));
                }
            } else {
                FileInputStream fileInputStream = new FileInputStream(file);
                FileUtilities.writeInputStreamToFile(fileInputStream, file2, (int)file.length(), new NullProgressMonitor());
            }
        }
    }
}

