/*
 * Decompiled with CFR 0.152.
 */
package er.woinstaller.archiver;

import java.io.File;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XarEntry
extends HashMap<String, Object> {
    private static final XPath xpath = XPathFactory.newInstance().newXPath();
    private static XPathExpression parentNodes;
    private static XPathExpression xpOffset;
    private static XPathExpression xpLength;
    private static XPathExpression xpName;
    private static XPathExpression xpType;
    private final Node data;
    private MessageDigest digest;

    public XarEntry(Node node) {
        this.data = node;
        try {
            Object object;
            NodeList nodeList = (NodeList)parentNodes.evaluate(this.data, XPathConstants.NODESET);
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                object = nodeList.item(i);
                stringBuilder.append(object.getTextContent()).append(File.separatorChar);
            }
            String string = xpName.evaluate(this.data);
            object = xpType.evaluate(this.data);
            stringBuilder.append(string);
            this.put("name", stringBuilder.toString());
            this.put("type", object);
            if (this.get("type").equals("file")) {
                this.put("offset", Long.valueOf(xpOffset.evaluate(this.data)));
                this.put("length", Long.valueOf(xpLength.evaluate(this.data)));
            }
        }
        catch (XPathExpressionException xPathExpressionException) {
            xPathExpressionException.printStackTrace();
        }
    }

    public static Map<String, XarEntry> getEntries(Document document) {
        HashMap<String, XarEntry> hashMap = new HashMap<String, XarEntry>();
        try {
            Object object = xpath.evaluate("//file[type=\"file\"]", document, XPathConstants.NODESET);
            NodeList nodeList = (NodeList)object;
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                XarEntry xarEntry = new XarEntry(node);
                hashMap.put(xarEntry.getName(), xarEntry);
            }
        }
        catch (XPathExpressionException xPathExpressionException) {
            xPathExpressionException.printStackTrace();
        }
        return hashMap;
    }

    public String getName() {
        return (String)this.get("name");
    }

    public Long getOffset() {
        return (Long)this.get("offset");
    }

    public Long getLength() {
        return (Long)this.get("length");
    }

    public String getCompression() {
        String string = (String)this.getValue("data.encoding.@style");
        if (string == null) {
            return null;
        }
        if ("application/x-bzip2".equals(string)) {
            return "bzip2";
        }
        if ("application/x-gzip".equals(string)) {
            return "gzip";
        }
        return string;
    }

    public String getExtractedChecksum() {
        return (String)this.getValue("data.extracted-checksum");
    }

    public long getSize() {
        return Long.valueOf((String)this.getValue("data.size"));
    }

    public boolean hasChecksum() {
        String string = this.getExtractedChecksum();
        return string != null && !"".equals(string);
    }

    private Object getValue(String string) {
        try {
            return xpath.evaluate("./" + string.replace(".", "/"), this.data);
        }
        catch (XPathExpressionException xPathExpressionException) {
            xPathExpressionException.printStackTrace();
            return null;
        }
    }

    public MessageDigest getMessageDigest(String string) {
        if (string == null) {
            return this.digest;
        }
        try {
            this.digest = MessageDigest.getInstance(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
        }
        return this.digest;
    }

    static {
        try {
            parentNodes = xpath.compile("ancestor::node()/name[../type=\"directory\"]");
            xpOffset = xpath.compile("./data/offset/text()");
            xpLength = xpath.compile("./data/length/text()");
            xpName = xpath.compile("./name");
            xpType = xpath.compile("./type");
        }
        catch (XPathExpressionException xPathExpressionException) {
            xPathExpressionException.printStackTrace();
        }
    }
}

